/*
 * mad - MPEG audio decoder
 * Copyright (C) 2000-2001 Robert Leslie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: strcasecmp.c,v 1.2 2001/01/21 00:18:10 rob Exp $
 */

# ifdef HAVE_CONFIG_H
#  include "config.h"
# endif

# include "global.h"

# include <ctype.h>

/*
 * NAME:	strcasecmp()
 * DESCRIPTION:	compare two strings without regard to case
 */
int strcasecmp(char const *str1, char const *str2)
{
  signed int c1, c2;

  do {
    c1 = tolower(*str1++);
    c2 = tolower(*str2++);
  }
  while (c1 && c1 == c2);

  return c1 - c2;
}
