------------------------------------------------------------------------------
--                                                                          --
--                       GNAT ncurses Binding Samples                       --
--                                                                          --
--                             Sample.Manifest                              --
--                                                                          --
--                                 S P E C                                  --
--                                                                          --
------------------------------------------------------------------------------
-- Copyright (c) 1998 Free Software Foundation, Inc.                        --
--                                                                          --
-- Permission is hereby granted, free of charge, to any person obtaining a  --
-- copy of this software and associated documentation files (the            --
-- "Software"), to deal in the Software without restriction, including      --
-- without limitation the rights to use, copy, modify, merge, publish,      --
-- distribute, distribute with modifications, sublicense, and/or sell       --
-- copies of the Software, and to permit persons to whom the Software is    --
-- furnished to do so, subject to the following conditions:                 --
--                                                                          --
-- The above copyright notice and this permission notice shall be included  --
-- in all copies or substantial portions of the Software.                   --
--                                                                          --
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  --
-- OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               --
-- MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   --
-- IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   --
-- DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    --
-- OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    --
-- THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               --
--                                                                          --
-- Except as contained in this notice, the name(s) of the above copyright   --
-- holders shall not be used in advertising or otherwise to promote the     --
-- sale, use or other dealings in this Software without prior written       --
-- authorization.                                                           --
------------------------------------------------------------------------------
--  Author: Juergen Pfeifer <juergen.pfeifer@gmx.net> 1996
--  Version Control
--  $Revision: 1.9 $
--  Binding Version 01.00
------------------------------------------------------------------------------
with Terminal_Interface.Curses; use Terminal_Interface.Curses;

package Sample.Manifest is

   QUIT         : constant User_Key_Code    := User_Key_Code'First;
   SELECT_ITEM  : constant User_Key_Code    := QUIT + 1;

   FKEY_HELP    : constant Label_Number     := 1;
   HELP_CODE    : constant Special_Key_Code := Key_F1;
   FKEY_EXPLAIN : constant Label_Number     := 2;
   EXPLAIN_CODE : constant Special_Key_Code := Key_F2;
   FKEY_QUIT    : constant Label_Number     := 3;
   QUIT_CODE    : constant Special_Key_Code := Key_F3;

   Menu_Marker : constant String := "=> ";

   Default_Colors  : constant Redefinable_Color_Pair := 1;
   Menu_Fore_Color : constant Redefinable_Color_Pair := 2;
   Menu_Back_Color : constant Redefinable_Color_Pair := 3;
   Menu_Grey_Color : constant Redefinable_Color_Pair := 4;
   Form_Fore_Color : constant Redefinable_Color_Pair := 5;
   Form_Back_Color : constant Redefinable_Color_Pair := 6;
   Notepad_Color   : constant Redefinable_Color_Pair := 7;
   Help_Color      : constant Redefinable_Color_Pair := 8;
   Header_Color    : constant Redefinable_Color_Pair := 9;

end Sample.Manifest;
