/* $XFree86: xc/programs/Xserver/hw/xfree86/vga256/drivers/tdfx/vbdefs.h,v 1.1.2.5 1999/07/13 07:09:54 hohndel Exp $ */
/*
   Voodoo Banshee driver version 1.0.2

   Author: Daryll Strauss

   Copyright: 1998,1999
*/

#ifndef _VBDEFS_H_
#define _VBDEFS_H_

#define VBIOMAPSIZE 0x2000000

#define BIT(n)  (1UL<<(n))
#define SST_SGRAM_OFLOP_DEL_ADJ_SHIFT   20
#define SST_SGRAM_CLK_NODELAY           BIT(13)
#define SST_DRAM_REFRESH_EN             BIT(0)
#define SST_DRAM_REFRESH_VALUE_SHIFT    1
#define SST_DRAM_REFRESH_VALUE          (0x1FF<<SST_DRAM_REFRESH_VALUE_SHIFT)
#define SST_SGRAM_TYPE_SHIFT            27
#define SST_SGRAM_TYPE                  (0x1L<<SST_SGRAM_TYPE_SHIFT)
#define SST_SGRAM_NUM_CHIPSETS          BIT(26)
#define SST_SGRAM_TYPE_8MBIT		(0x0L<<SST_SGRAM_TYPE_SHIFT)
#define SST_SGRAM_TYPE_16MBIT		(0x1L<<SST_SGRAM_TYPE_SHIFT)
#define SST_DISABLE_2D_BLOCK_WRITE      BIT(15)
#define SST_MCTL_TYPE_SDRAM             BIT(30)
#define SST_DAC_MODE_2X			BIT(0)
#define SST_VIDEO_2X_MODE_EN            BIT(26)
#define SST_VGA0_EXTENSIONS             BIT(6)
#define SST_WAKEUP_3C3                  1
#define SST_VGA0_WAKEUP_SELECT_SHIFT    8
#define SST_VGA0_LEGACY_DECODE_SHIFT    9
#define SST_VGA0_LEGACY_DECODE          (1 << SST_VGA0_LEGACY_DECODE_SHIFT)
#define SST_VGA0_ENABLE_DECODE          0
#define SST_ENABLE_ALT_READBACK         0
#define SST_VGA0_CONFIG_READBACK_SHIFT  10
#define SST_VIDEO_PROCESSOR_EN          BIT(0)
#define SST_CURSOR_MODE_SHIFT           1
#define SST_CURSOR_X11                  (1<<SST_CURSOR_MODE_SHIFT)
#define SST_DESKTOP_EN                  BIT(7)
#define SST_DESKTOP_PIXEL_FORMAT_SHIFT  18
#define SST_DESKTOP_CLUT_BYPASS         BIT(10)
#define SST_HALF_MODE                   BIT(4)
#define SST_CURSOR_EN                   BIT(27)
#define SST_BUSY                        BIT(9)
#define SST_RETRACE			BIT(6)

#define SST_2D_OFFSET           0x100000
#define SST_3D_OFFSET           0x200000
#define STATUS 0x0
#define PCIINIT0 0x4
#define SIPMONITOR 0x8
#define LFBMEMORYCONFIG 0xC
#define MISCINIT0 0x10
#define MISCINIT1 0x14
#define DRAMINIT0 0x18
#define DRAMINIT1 0x1C
#define AGPINIT 0x20
#define TMUGBEINIT 0x24
#define VGAINIT0 0x28
#define VGAINIT1 0x2c
#define DRAMCOMMAND 0x30
#define DRAMDATA 0x34
#define PLLCTRL0 0x40
#define PLLCTRL1 0x44
#define PLLCTRL2 0x48
#define DACMODE 0x4c
#define DACADDR 0x50
#define DACDATA 0x54
#define RGBMAXDELTA 0x58
#define VIDPROCCFG 0x5c
#define HWCURPATADDR 0x60
#define HWCURLOC 0x64
#define HWCURC0 0x68
#define HWCURC1 0x6c
#define VIDINFORMAT 0x70
#define VIDINSTATUS 0x74
#define VIDSERIALPARALLELPORT 0x78
#define VIDINXDECIMDELTAS 0x7c
#define VIDINDECIMINITERRS 0x80
#define VIDYDECIMDELTA 0x84
#define VIDPXELBUGTHOLD 0x88
#define VIDCHROMAMIN 0x8c
#define VIDCHROMAMAX 0x90
#define VIDCURRENTLINE 0x94
#define VIDSCREENSIZE 0x98
#define VIDOVERLAYSTARTCOORDS 0x9c
#define VIDOVERLAYENDSCREENCOORDS 0xa0
#define VIDOVERLAYDUDX 0xa4
#define VIDOVERLAYDUDXOFFSETSRCWIDTH 0xa8
#define VIDOVERLAYDVDY 0xac
#define VIDOVERLAYDVDYOFFSET 0xe0
#define VIDDESKTOPSTARTADDR 0xe4
#define VIDDESKTOPOVERLAYSTRIDE 0xe8
#define VIDINADDR0 0xec
#define VIDINADDR1 0xf0
#define VIDINADDR2 0xf4
#define VIDINSTRIDE 0xf8
#define VIDCUROVERLAYSTARTADDR 0xfc

#define MEM_TYPE_SGRAM  0
#define MEM_TYPE_SDRAM  1

#define SST_2D_NOP 0
#define SST_2D_SCRNTOSCRNBLIT 1
#define SST_2D_SCRNTOSCRNSTRETCH 2
#define SST_2D_HOSTTOSCRNBLIT 3
#define SST_2D_HOSTTOSCRNSTRECH 4
#define SST_2D_RECTANGLEFILL 5
#define SST_2D_LINE (6 | SST_2D_REVERSIBLE)
#define SST_2D_POLYLINE (7 | SST_2D_REVERSIBLE)
#define SST_2D_POLYGONFILL (8 | SST_2D_REVERSIBLE)
#define SST_2D_REVERSIBLE               BIT(9)
#define SST_2D_STIPPLE_LINE             BIT(12)
#define SST_2D_MONOCHROME_PATTERN       BIT(13)
#define SST_2D_X_RIGHT_TO_LEFT          BIT(14)
#define SST_2D_Y_BOTTOM_TO_TOP          BIT(15)
#define SST_2D_TRANSPARENT_MONOCHROME   BIT(16)
#define SST_2D_SOURCE_PACKING_SHIFT     22
#define SST_2D_SOURCE_PACKING_BYTE      (1<<SST_2D_SOURCE_PACKING_SHIFT)
#define SST_2D_SOURCE_PACKING_WORD      (2<<SST_2D_SOURCE_PACKING_SHIFT)
#define SST_2D_SOURCE_PACKING_DWORD     (3<<SST_2D_SOURCE_PACKING_SHIFT)

#define SST_2D_CLIP0MIN 0x8
#define SST_2D_CLIP0MAX 0xC
#define SST_2D_DSTBASEADDR 0x10
#define SST_2D_DSTFORMAT 0x14
#define SST_2D_SRCCOLORKEYMIN 0x18
#define SST_2D_SRCCOLORKEYMAX 0x1c
#define SST_2D_DSTCOLORKEYMIN 0x20
#define SST_2D_DSTCOLORKEYMAX 0x24
#define SST_2D_BRESERROR0 0x28
#define SST_2D_BRESERROR1 0x2c
#define SST_2D_ROP 0x30
#define SST_2D_SRCBASEADDR 0x34
#define SST_2D_COMMANDEXTRA 0x38
#define SST_2D_LINESTIPPLE 0x3c
#define SST_2D_LINESTYLE 0x40
#define SST_2D_CLIP1MIN 0x4C
#define SST_2D_CLIP1MAX 0x50
#define SST_2D_SRCFORMAT 0x54
#define SST_2D_SRCSIZE 0x58
#define SST_2D_SRCXY 0x5C
#define SST_2D_COLORBACK 0x60
#define SST_2D_COLORFORE 0x64
#define SST_2D_DSTSIZE 0x68
#define SST_2D_DSTXY 0x6C
#define SST_2D_COMMAND 0x70
#define SST_2D_LAUNCH 0x80
#define SST_2D_PATTERN0 0x100
#define SST_2D_PATTERN1 0x104

#define SST_3D_COMMAND 0x120
#define SST_3D_NOP 0

#define BLIT_LEFT 1
#define BLIT_UP 2

#endif
