#include <stdio.h>
#include <kdebug.h>
#include "kimgnum.h"

#include <qpixmap.h>

KImageNumber::KImageNumber(const QString& font,QWidget* parent,const char* name) :
    QFrame(parent,name), val(0)
{
    fontPix=new QPixmap(font);
    resize(sizeHint());
}

KImageNumber::~KImageNumber()
{
    delete fontPix;
}

void KImageNumber::paintEvent(QPaintEvent*)
{
    int w=fontPix->width();
    int each=w/11;

    QString data;
    data.sprintf("%06.1f",val);

    for(unsigned int i=0;i<data.length();i++) {

	int wl=data.at(i).latin1()-'0';
	if(data.at(i)=='.')
	    wl=10;
	
	bitBlt(this,i*each,0,fontPix,wl*each,0,each,fontPix->height());
    }
}

void KImageNumber::setValue(double v)
{
    val=v;
    repaint(false);
}

QSize KImageNumber::sizeHint() const
{
    int w=fontPix->width();
    int each=w/11;

    QString data;
    data.sprintf("%06.1f",val);

    return QSize(data.length()*each, fontPix->height());
}

