/* 
   This file is part of libodbc++.
   
   Copyright (C) 1999 Manush Dodunekov <manush@litecom.net>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __DRIVERINFO_H
#define __DRIVERINFO_H

#include <odbc++/types.h>

namespace odbc {

  class Connection;

  class ODBCXX_EXPORT DriverInfo {
    friend class Connection;
  public:
    int getMajorVersion() const {
      return majorVersion_;
    }

    int getMinorVersion() const {
      return minorVersion_;
    }

    // the mask returned by SQLGetInfo(SQL_SCROLL_OPTIONS)
    int getCursorMask() const {
      return cursorMask_;
    }

    bool supportsFunction(int funcId) const {
      return ODBC3_C
	(SQL_FUNC_EXISTS(supportedFunctions_,funcId),
	 supportedFunctions_[funcId])==SQL_TRUE;
    }
    
  private:
    // odbc version
    int majorVersion_;
    int minorVersion_;
    
    int cursorMask_;
    SQLUSMALLINT* supportedFunctions_;

    explicit DriverInfo(Connection* con);
    ~DriverInfo() {
      delete[] supportedFunctions_;
    }
  };

};


#endif // __DRIVERINFO_H

