/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _SEARCHJOB_H_
#define _SEARCHJOB_H_


#include <kio/job.h>

class Site;


class SearchJob : public KIO::TransferJob
{
    Q_OBJECT

public:
    SearchJob(Site *site, const QString &searchtext);
    ~SearchJob();

protected:
    virtual void parseItem(const QString &item) = 0;
    Site *m_site;

private slots:
    void gotData(KIO::Job *, const QByteArray &data);    
	
private:
    enum { Begin, ResultList, ResultItem, End } state;
    QByteArray makeArgs(Site *site, const QString &querytext);
    QString m_buf;
};

 
#endif 
