/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _LDAPSITE_H_
#define _LDAPSITE_H_


#include <qdict.h>
#include <qlist.h>
#include <qdom.h>


struct LdapInputTag
{
    QString name;
    QString value;
    bool user;
};


class LdapSite {

public:
  LdapSite();
  ~LdapSite();

  QString makeQueryUrl(const QString &query);

  QString name;
  QString action;
  QList<LdapInputTag> inputs;
};


class LdapSiteFactory
{
public:
    virtual LdapSite *create(const QString &filename);
    virtual void input(LdapSite *site, const QDomElement &el);
    virtual void interpret(LdapSite *site, const QDomElement &el);
    virtual LdapSite *newLdapSite();
};

    
class LdapSiteManager
{
public:
    LdapSiteManager(const QString &sitetype, LdapSiteFactory &factory);
    //    ~LdapSiteManager();

    QDict<LdapSite> dict;
};

    
#endif
