/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */

#include <kstddirs.h>

#include "misc.h"
#include "site.h"
#include "ftpsearch.h"


class FtpSite : public Site
{
public:
    FtpSite() : Site() {}
    ~FtpSite() {}
};


FtpSiteManager::FtpSiteManager()
{
    SiteFactory factory;
    d = new SiteManager("ftp-sites", factory);
}


FtpSiteManager::~FtpSiteManager()
{
    delete d;
}


FtpSite *FtpSiteManager::find(const QString &name)
{
    return static_cast<FtpSite*>(d->dict.find(name));
}


QStringList FtpSiteManager::siteList()
{
    QStringList list;
    QDictIterator<Site> it(d->dict);
    for (;  it.current(); ++it)
        list.append(it.currentKey());
    return list;
}


FtpSearch::FtpSearch(FtpSite *site, const QString &searchtext)
    : SearchJob(site, searchtext)
{}


void FtpSearch::parseItem(const QString &item) {
  QString host, path, size, date;
  int pos;
  qDebug( "Found: " + item );
  QString raw = removeHTML(item).simplifyWhiteSpace();
  pos = raw.find(' ');
  if (pos == -1)
    return;
  host = raw.left(pos);
  raw.remove(0, pos+1);
  pos = raw.find(' ');
  if (pos == -1)
    return;
  path = raw.left(pos);
  raw.remove(0, pos+1);
  pos = raw.find(' ');
  if (pos == -1)
    return;
  size = raw.left(pos);
  raw.remove(0, pos+1);
  emit foundItem(m_site->name, host, path, size, raw);
}
