/*************************************************************************

 Main KSirc start

 $$Id: ksirc.cpp,v 1.48 2000/05/14 16:09:23 pfeiffer Exp $$

 Main start file that defines 3 global vars, etc

*************************************************************************/

/*
 * Needed items
 * 4. Send a /quit and/or kill dsirc on exit
 * */


#include "servercontroller.h"
#include "welcomeWin.h"

#include <iostream.h>
#include <time.h>
#include <unistd.h>

#include <qfont.h>
#include <qmessagebox.h>

#include <kapp.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kaboutdata.h>

#include "config.h"
#include "version.h"
#include "cdate.h"
#include <klocale.h>
#include <kcmdlineargs.h>

static const char *description =
	I18N_NOOP("KDE Irc client");


KApplication *kApp;
KConfig *kConfig;
global_config *kSircConfig;
//QDict<KSircTopLevel> TopList;
//QDict<KSircMessageReceiver> TopList;

int main( int argc, char ** argv )
{
  KAboutData aboutData( "ksirc", I18N_NOOP("KSirc"),
    KSIRC_VERSION, description, KAboutData::License_Artistic,
    "(c) 1997-1999, Andrew Stanley-Jones");
  aboutData.addAuthor("Andrew Stanley-Jones",0, "asj@chowtown.cban.com");
  KCmdLineArgs::init( argc, argv, &aboutData );


  // Start the KDE application
  kApp = new("KApplication") KApplication;

  kConfig = kApp->config();

  QString ver = KSIRC_VERSION;
#if 0
  if(ver.contains(".") == 0){
    // This is a development version
    // 4 week timeout, warn after 2
    int ntime = time(NULL);
    if(ntime - COMPILE_DATE > 4838400){
      // To Old
      QMessageBox::critical(0, "kSirc",
			    i18n("kSirc Alpha releases have an 8 week\n"
                                         "expiry date.\n\n"
                                         "kSirc-ALPHA HAS EXPIRED!!\n"
                                         "Please upgrade or use a beta release"), i18n("OK"));
      exit(1);
    }
    else if(ntime - COMPILE_DATE > 2419200){
      QMessageBox::warning(0, "kSirc",
			   i18n("kSirc Alpha release have an 8 week\n"
                                        "expiry date.\n\n"
                                        "THIS VERSION WILL EXPIRE IN UNDER 4 WEEKS"), i18n("OK"));
    }
  }
#endif

  // Add extra searchpaths for icons
  KGlobal::dirs()->addResourceType("toolbar", KStandardDirs::kde_default("data")+"kwm/pics" );

  // Get config, and setup internal structure.

  kSircConfig = new("global_config") global_config;

  kConfig->setGroup("Colours");
  kSircConfig->colour_text = new("QColor") QColor(kConfig->readColorEntry("text", &Qt::black));
  kSircConfig->colour_info = new("QColor") QColor(kConfig->readColorEntry("info", &Qt::blue));
  kSircConfig->colour_chan = new("QColor") QColor(kConfig->readColorEntry("chan", &Qt::green));
  kSircConfig->colour_error = new("QColor") QColor(kConfig->readColorEntry("error", &Qt::red));
  if(kSircConfig->colour_text == 0x0)
      kSircConfig->colour_text = new("QColor") QColor("black");
  if(kSircConfig->colour_info == 0x0)
      kSircConfig->colour_info = new("QColor") QColor("blue");
  if(kSircConfig->colour_chan == 0x0)
      kSircConfig->colour_chan = new("QColor") QColor("green");
  if(kSircConfig->colour_error == 0x0)
      kSircConfig->colour_error = new("QColor") QColor("red");


  QWidget *w = new QWidget();
  kSircConfig->colour_background = new("QColor") QColor(kConfig->readColorEntry("Background", new("QColor") QColor(w->colorGroup().mid())));
  delete w;

  kSircConfig->filterKColour = kConfig->readNumEntry("kcolour", false);
  kSircConfig->filterMColour = kConfig->readNumEntry("mcolour", false);
  kSircConfig->nickFHighlight = kConfig->readNumEntry("nickfcolour", -1);
  kSircConfig->nickBHighlight = kConfig->readNumEntry("nickbcolour", -1);
  kSircConfig->usHighlight = kConfig->readNumEntry("uscolour", -1);
  kSircConfig->transparent = kConfig->readNumEntry("Transparent", false);

  QString ld_path = getenv("LD_LIBRARY_PATH");
  ld_path += ":" + locate( "appdata", "" ) + ":";
  ld_path.prepend("LD_LIBRARY_PATH=");
  putenv((char *)ld_path.data());

  kConfig->setGroup("GlobalOptions");
  kSircConfig->defaultfont = kConfig->readFontEntry("MainFont", new("QFont") QFont("fixed"));
  kConfig->setGroup("General");
  kSircConfig->DisplayMode = kConfig->readNumEntry("DisplayMode", 0);
  kSircConfig->WindowLength = kConfig->readNumEntry("WindowLength", 200);
  kSircConfig->transparent = kConfig->readNumEntry("transparent", 0);
  kSircConfig->BackgroundPix = kConfig->readNumEntry("BackgroundPix", 0);
  kSircConfig->BackgroundFile = kConfig->readEntry("BackgroundFile", "");

#if 0
  kConfig->setGroup("ReleaseNotes");
  if(kConfig->readNumEntry("LastRunRelease", 0) < COMPILE_DATE){
    welcomeWin ww;
    if(ww.exec())
      kConfig->writeEntry("LastRunRelease", COMPILE_DATE);
  }
#endif

  servercontroller *sc = 0x0;
  sc = new("servercontroller") servercontroller(0, "servercontroller");
  kApp->setMainWidget(sc);

  if(kApp->isRestored())
      sc->restore(1);

  // will eventually be overridden by readProperties() (Sessionmanagement)
  kConfig->setGroup("ServerController");
  bool docked = kConfig->readBoolEntry("Docked", FALSE);
  const QRect geom = kConfig->readRectEntry("Size");
  if(! geom.isEmpty())
      sc->setGeometry(geom);
  if ( docked )
      sc->setInitialDocking();
  else
      sc->show();
  
  try {
      kApp->exec();
  }
  catch(...){
      cerr << "Caught Unkown Exception, uhoh!!!\n";
      cerr << "Dying!!!\n";
      exit(10);
  }

  delete sc;

  kConfig->sync();
}
