/*
* gencfg.cpp -- Implementation of class KGeneralCfg.
* Author:	Sirtaj Singh Kang
* Version:	$Id: gencfg.cpp,v 1.5 2000/04/23 15:41:16 jansen Exp $
* Generated:	Wed Jul 29 03:47:49 EST 1998
*/

#include <assert.h>
#include <qgroupbox.h>
#include <qlined.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qlabel.h>

#include <kglobal.h>
#include <kcolorbtn.h>
#include <kicondialog.h>
#include <klocale.h>

#include "gencfg.h"
#include "maildrop.h"
//#include "typolayout.h"



QWidget *KGeneralCfg::makeWidget( QWidget *parent )
{
        QLabel *aLabel;
	QWidget *dlg = new QWidget( parent );
	QBoxLayout *layout = new QVBoxLayout( dlg, 10 );

	KMailDrop *d = drop();

	// View frame
	QGroupBox *aGroup = new QGroupBox(i18n("View"), dlg);
	layout->addWidget(aGroup);

	QGridLayout *slay = new QGridLayout(aGroup, 5, 3, 10);
	slay->addRowSpacing(0, 10);

	aLabel = new QLabel( i18n("Caption"), aGroup);
	slay->addWidget(aLabel, 1, 0);

	_caption = new QLineEdit(d->caption(), aGroup );
	slay->addMultiCellWidget(_caption, 1, 1, 1, 2);

	// colour options

	_useColour = new QCheckBox( i18n("Use Color"), aGroup );
	_useColour->setChecked( d->colour() );
	slay->addWidget(_useColour, 2, 0);

	connect( _useColour, SIGNAL(toggled(bool)), this, 
		SLOT(setUseColour(bool)) );

	// highlight button

	aLabel = new QLabel( i18n( "Highlight" ), aGroup );
	slay->addWidget(aLabel, 2, 1);

	_hlcBtn = new KColorButton( aGroup );
	slay->addWidget( _hlcBtn, 2, 2 );

	_hlcBtn->setEnabled( d->colour() );

	connect( this, SIGNAL(coloursEnabled(bool)), _hlcBtn,
		SLOT(setEnabled(bool)) );

	if( d->hlColour() ) {
		_hlcBtn->setColor( *d->hlColour() );
	}

	// text colour button

	aLabel = new QLabel( i18n( "Text" ), aGroup );
	slay->addWidget(aLabel, 3, 1);

	_tcBtn = new KColorButton( aGroup );
	slay->addWidget( _tcBtn, 3, 2 );

	_tcBtn->setEnabled( _useColour->isChecked() );

	connect( this, SIGNAL(coloursEnabled(bool)), _tcBtn,
		SLOT(setEnabled(bool)) );

	if( d->tColour() ) {
		_tcBtn->setColor( *d->tColour() );
	}

	// bg pixmap
	aLabel = new QLabel( i18n( "Background" ), aGroup );
	slay->addWidget(aLabel, 4, 1);

	_bgBtn = new KIconButton( KGlobal::iconLoader(), 
		aGroup);
	slay->addWidget( _bgBtn, 4, 2 );

	connect( this, SIGNAL(coloursEnabled(bool)), _bgBtn,
		SLOT(setEnabled(bool)) );

	if( d->bgTexture() ) {
		_bgBtn->setIcon( d->bgTexture() );
	}

	_tcBtn->setEnabled( _useColour->isChecked() );

	// Commands frame

	
	aGroup = new QGroupBox( i18n( "Commands" ), dlg );
	layout->addWidget( aGroup );

	slay = new QGridLayout( aGroup, 3, 2, 10);
	slay->addRowSpacing(0, 10);

	aLabel = new QLabel( i18n( "On Receipt" ), aGroup );
	slay->addWidget(aLabel, 1, 0);

	_onReceipt = new QLineEdit( d->newmailCmd(), aGroup );
	slay->addWidget(_onReceipt, 1, 1);

	aLabel = new QLabel( i18n( "On Click" ), aGroup );
	slay->addWidget(aLabel, 2, 0);

	_onClick = new QLineEdit( d->clickCmd(), aGroup );
	slay->addWidget (_onClick, 2, 1);

	return dlg;
}

const QString KGeneralCfg::name() const
{
	return i18n("General");
}

void KGeneralCfg::updateConfig()
{
	KMailDrop *d = drop();

	assert( _caption );
	assert( _onReceipt );
	assert( _onClick );

	d->setCaption( _caption->text() );
	d->setClickCmd( _onClick->text() );
	d->setNewmailCmd( _onReceipt->text() );

	d->setColour( _useColour->isChecked() );
	d->setHlColour( _hlcBtn->color() );
	d->setTColour( _tcBtn->color() );
	d->setBgTexture( _bgBtn->icon().isEmpty() ? ""  
				: _bgBtn->icon().ascii() );
}

void KGeneralCfg::setUseColour( bool status ) 
{
	emit coloursEnabled( status );
}
