/*
 *   mylistmanager.h - Widget for managing a list
 * 
 *   part of knu: KDE network utilities
 *   (will perhaps be part of kdelibs)
 *
 *   Copyright (C) 1997-1999  Bertrand Leconte
 *   Copyright (c) 1998 Cristian Tibirna <ctibirna@gch.ulaval.ca>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Id: mylistmanager.h,v 1.2 1999/06/25 21:29:25 leconte Exp $
 */
#ifndef __mylistmanager_h__
#define __mylistmanager_h__

#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwidget.h>

/**
 * Manage a string list.
 *
 * The widget can be used to create and manage a string list. The list
 * is based on QString.
 *
 * @see QListBox, QStringList
 * @author Bertrand Leconte <B.Leconte@mail.dotcom.fr>
 * @version $Id: mylistmanager.h,v 1.2 1999/06/25 21:29:25 leconte Exp $ 
 */
class myListManager: public QWidget
{
  Q_OBJECT

public:

  enum Features {
    NoFeature     = 0,
    UpDownButtons = 0x0001,	/* Up button and Down Button */
    ShortLabels   = 0x0002	/* Show +/- insteed of add/remove */
  }; 


  /**
   * Constructor with a title in a groupBox.
   *
   * Some day, I will add a functionality enum that will add/remove Up
   * and Down button.
   *
   * @param title Widget title
   * @param parent Parent widget
   * @param name Widget's name (internal only) 
   * @param f Feature list
   */
  myListManager(QString title, 
		QWidget *parent = 0, 
		const char *name = 0, Features f = NoFeature);
  /**
   * Constructor.
   *
   * Some day, I will add a functionality enum that will add/remove Up
   * and Down button.
   *
   * @param parent Parent widget
   * @param name Widget's name (internal only) 
   * @param f Feature list
   */
  myListManager(QWidget *parent = 0, 
		const char *name = 0, Features f = NoFeature);

  /**
   * Destructor
   */
  ~myListManager();

  /**
   * Add the given string list to the listbox
   *
   * @param list the string list to add
   */
  void setStringList(const QStringList &); 


  /**
   * Add the given string list to the listbox. The list will
   * be keeped in sync with the listbox.
   *
   * @param list the string list to add
   */
  void setStringList(QStringList *); 

  /**
   * Returns the resulting list
   *
   * @return a QStringList
   */
  QStringList stringList() const;

  /**
   * Clear all. 
   */
  void clear();

  /**
   * Returns a pointer to the list box used.
   *
   * @return a QListBox pointer
   */
  QListBox *listBox() { return myListBox; };
   
  /**
   * Returns a pointer to the "add" button
   *
   * @return a QPushButton pointer
   */
  QPushButton *addButton() { return myAddButton; };

  /**
   * Returns a pointer to the "remove" button
   *
   * @return a QPushButton pointer
   */
  QPushButton *removeButton() { return myRemoveButton; };

  /**
   * Returns a pointer to the "up" button
   *
   * @return a QPushButton pointer
   */
  QPushButton *upButton() { return myUpButton; };

  /**
   * Returns a pointer to the "down" button
   *
   * @return a QPushButton pointer
   */
  QPushButton *downButton() { return myDownButton; };

public slots:
  /**
   * Enables widget if enable is TRUE, otherwise disables widget. 
   *
   * @param enable enable or disable
   */
  virtual void setEnabled(bool enable);
 

protected slots:
  /**
   * Add button pressed
   */
  void addIt();
  /**
   * Remove button pressed
   */
  void removeIt();
  /**
   * Up button pressed
   */
  void moveUp();
  /**
   * Down button pressed
   */
  void moveDown();

  /**
   * Called when an item is hilited
   */
  void itemHilited();

  /**
   * Called when the lineedit is modified
   */
  void textChanged(const QString &);

protected:
  // Methods
  void manageButtons();
  void realConstructor(class QWidget *, bool, Features);
  
  // Widgets
  QGroupBox   *myGroupBox;
  QLineEdit   *myLineEdit;
  QListBox    *myListBox;
  QPushButton *myAddButton;
  QPushButton *myRemoveButton;
  QPushButton *myUpButton;
  QPushButton *myDownButton;

  // Data
  Features    features;
  QStringList *myStringList;
};  


#endif  /* __mylistmanager_h__ */
