/****************************************************************************
** $Id: qhostaddress.cpp,v 1.1 2000/05/28 19:26:42 rich Exp $
**
** Implementation of something useful.
**
** Created : 979899
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of Troll Tech's internal development tree for Qt.
**
** This header text will be replaced by an appropriate text by the
** mkdist script which generates external distributions.
**
** If you are using the Qt Professional Edition or the Qt Free Edition,
** please notify Troll Tech at <info@trolltech.com> if you see this text.
**
** To Troll Tech developers: This header was generated by the script
** fixcopyright-int. It has the same number of text lines as the free
** and professional editions to avoid line number inconsistency.
**
*****************************************************************************/

#include "qhostaddress.h"
#include "qglobal.h"


/*!
  \class QHostAddress qsocketdevice.h
  \brief QHostAddress provides an IP address.

  \ingroup kernel

  This class contains an IP address in a platform- and
  protocol-independent manner.  That is, it'll store the address in a
  way you can access easily on any platform, and it'll store both IPv4
  and IPv6 addresses.

  QHostAddress is normally used with the classes QSocketDevice and
  QSocket to set up a server or to connect to a host.

  \sa QSocket, QSocketDevice
*/


/*!
  Creates a socket address object with the port number 0 and IP address
  0.0.0.0.
*/

QHostAddress::QHostAddress()
    : d( 0 ), a( 0 )
{
}


/*!
  Creates a socket address object with a specified IPv4
  address.
*/

QHostAddress::QHostAddress( uint ip4Addr )
    : d(0)
{
    a = ip4Addr;
}


/*!
  Creates a copy of \a address.
*/

QHostAddress::QHostAddress( const QHostAddress &address )
    : d(0)
{
    a = address.a;
}


/*!
  Destructs the socket address object.
*/

QHostAddress::~QHostAddress()
{
    // nothing to d;
    // nothing to a
}


/*!
  Assigns another socket address object \a address to this object and
  returns a referense to this object.
*/

QHostAddress & QHostAddress::operator=( const QHostAddress & address )
{
    d = 0;
    a = address.a;
    return *this;
}


/*!
  Returns the IPc4 address as a number.

  For example, if the address is 127.0.0.1, the returned value is
  2130706433 (hex: 7f000001).

  \sa toString()
*/

uint QHostAddress::ip4Addr() const
{
    return a;
}


/*!
  Returns the address as a string.

  For example, if the address is the IPv4 address 127.0.0.1, the
  returned string is "127.0.0.1".

  \sa ip4Addr()
*/

QString QHostAddress::toString() const
{
    uint i = ip4Addr();
    QString s;
    s.sprintf( "%d.%d.%d.%d", (i>>24) & 0xff, (i>>16) & 0xff,
	       (i >> 8) & 0xff, i & 0xff );
    return s;
}


/*!
  Returns TRUE if this socket address is identical to \a other, or FALSE
  if they are different.
*/

bool QHostAddress::operator==( const QHostAddress & other ) const
{
    return  a == other.a;
}
