#include <qiconset.h>
#include <qdialog.h>
#include <klocale.h>
#include <qpixmap.h>
#include <qdom.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <kapp.h>
#include <kstdaction.h>
#include <kstddirs.h>
#include <khelpmenu.h>
#include <assert.h>

#include "kvnc.h"
#include "krfbcanvas.h"
#include "kvncaboutdlg.h"
#include "kvncoptionsdlg.h"
#include "krfbconnection.h"

#include "kvnc.moc"

const int StatusTextId = 0;

KVNC::KVNC( const char *name )
  : KTMainWindow( name )
{
  fullscreen = false;

  canvas = new KRFBCanvas( this, "canvas" );
  setView( canvas );

  connect( canvas, SIGNAL( statusChanged( const QString & ) ),
           statusBar(), SLOT( message( const QString & ) ) );

  setupActions();

  setupMenuBar();
  setupStatusBar();

  conserveMemory();
}

KVNC::~KVNC()
{

}

void KVNC::openURL( const KURL &url )
{
  canvas->openURL( url );
}

void KVNC::setupActions()
{
  new KRecentFilesAction( i18n("&Recent Connections"),
					 "connect",
					 0,
					 canvas, SLOT( openURL( const KURL & ) ),
					 actionCollection(),
           "recent_connections");

  KStdAction::quit(kapp, SLOT(quit()), actionCollection(), "quit");

  //
  // View menu
  //

  KStdAction::redisplay(canvas, SLOT( refresh() ), actionCollection() );

  new KToggleAction( i18n("&Full Screen"),
					//"fullscreen",
					0,
					this, SLOT( toggleFullScreen() ),
					actionCollection(),
          "fullscreen");

  //
  // Options menu
  //
  KStdAction::showMenubar(
					this, SLOT( toggleShowMenu() ),
					actionCollection() );

  KStdAction::showStatusbar(
					this, SLOT( toggleShowStatus() ),
					actionCollection() );

  KStdAction::saveOptions(
				    this, SLOT( toggleFullScreen() ),
				    actionCollection() );

  KStdAction::preferences(
				    this, SLOT( showOptions() ),
				    actionCollection() );

  createGUI( QString::null, false );
}

void KVNC::setupMenuBar()
{
  cornerMenu = new KPopupMenu();

  QDomElement menuBar = domDocument().documentElement().namedItem( "MenuBar" ).toElement();
  QDomElement e = menuBar.firstChild().toElement();
  for (; !e.isNull(); e = e.nextSibling().toElement() )
  {
    QWidget *cont = factory()->container( e.attribute( "name" ), this );
    assert( cont->inherits( "QPopupMenu" ) );
    QPopupMenu *popup = static_cast<QPopupMenu *>( cont );
    cornerMenu->insertItem( i18n( e.namedItem( "text" ).toElement().text().latin1() ),
			    popup );
  }

  cornerButton = new QPushButton( this );
  cornerButton->setText( "K" );
  cornerButton->setPopup( cornerMenu );
  cornerButton->hide();
}

void KVNC::setupStatusBar()
{
  KStatusBar *status = statusBar();
  status->insertItem( "Welcome to Keystone", StatusTextId );
}

void KVNC::toggleFullScreen()
{
  if ( fullscreen ) {
    showNormal();
    canvas->releaseKeyboard();
  }
  else {
    showFullScreen();
    raise();
    canvas->setFocus();
    canvas->grabKeyboard();
  }

  fullscreen = !fullscreen;
}

void KVNC::showAboutApplication()
{
  KVNCAboutDlg about;
  about.exec();
}

void KVNC::toggleShowStatus()
{
  if (statusBar()->isVisible())
    enableStatusBar(KStatusBar::Hide);
  else
    enableStatusBar(KStatusBar::Show);
}

void KVNC::toggleShowMenu()
{
  if (menuBar()->isVisible()) {
    menuBar()->hide();
    cornerButton->show();
    canvas->setCornerWidget( cornerButton );
  }
  else {
    menuBar()->show();
    canvas->setCornerWidget( 0 );
    cornerButton->hide();
  }
}

void KVNC::showOptions()
{
  KVNCOptionsDlg *wdg = new KVNCOptionsDlg( canvas->connection()->options(),
                                            this );
  wdg->exec();
  delete wdg;
}

