/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qdragobject.h>
#include <klocale.h>

#include "peopleresults.h"


PeopleResultView::PeopleResultView(QWidget *parent, const char *name)
    : QListView(parent, name)
{
    setAllColumnsShowFocus(true);
    addColumn( i18n("Name") );
    addColumn( i18n("Email") );
    addColumn( i18n("Phone") );
    
    connect( this, SIGNAL(doubleClicked(QListViewItem*)),
             SLOT(itemActivated(QListViewItem*)) );
}


void PeopleResultView::contentsMouseMoveEvent(QMouseEvent *e)
{
    QListView::contentsMouseMoveEvent(e);

    if (! (e->state() & LeftButton))
        return;

    QListViewItem *item = itemAt(contentsToViewport(e->pos()));
    if (!item)
        return;

    QString url = "mailto://" + item->text(1);
    QStrList uris;
    uris.append(url);
    QUriDrag *drag = new QUriDrag(uris, this, "drag");
    drag->dragCopy();
}


void PeopleResultView::insertItem(const QString &icon, const QString &name, const QString &email,
                                  const QString &phone, const LdapItem &item)
{
    (void) new QListViewItem(this, name, email, phone);
}


void PeopleResultView::itemActivated(QListViewItem *item)
{
    emit emailActivated(item->text(1));
}
