/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qdragobject.h>
#include <klocale.h>

#include "ftpresults.h"


FtpResultView::FtpResultView(QWidget *parent, const char *name)
    : QListView(parent, name)
{
    setAllColumnsShowFocus(true);
    addColumn( i18n("Date") );
    addColumn( i18n("Size") );
    addColumn( i18n("Server"), 100 );
    addColumn( i18n("Path"), 200 );
    
    connect( this, SIGNAL(doubleClicked(QListViewItem*)),
             SLOT(itemActivated(QListViewItem*)) );
}


void FtpResultView::contentsMouseMoveEvent(QMouseEvent *e)
{
    QListView::contentsMouseMoveEvent(e);

    if (! (e->state() & LeftButton))
        return;

    QListViewItem *item = itemAt(contentsToViewport(e->pos()));
    if (!item)
        return;

    QString url = "ftp://" + item->text(2) + '/' + item->text(3);
    QStrList uris;
    uris.append(url);
    QUriDrag *drag = new QUriDrag(uris, this, "drag");
    drag->dragCopy();
}


void FtpResultView::insertItem(const QString &host, const QString &path,
                               const QString &size, const QString &date)
{
    (void) new QListViewItem(this, date, size, host, path);
}


void FtpResultView::itemActivated(QListViewItem *item)
{
    QString url = "ftp://" + item->text(2) + '/' + item->text(3);
    emit urlActivated(url);
}
