/* $Id: dlgSystem.cpp,v 1.16 2000/04/08 16:24:11 koss Exp $
   $Log: dlgSystem.cpp,v $
   Revision 1.16  2000/04/08 16:24:11  koss
   ported to KAudioPlayer

   Revision 1.15  2000/02/20 14:13:57  porten
   kDebug*

   Revision 1.14  1999/11/27 18:16:46  koss
   Little fix for a warning.

   Revision 1.13  1999/11/19 18:51:20  koss
   FIxed remaining stuff for Settings class.

   Revision 1.12  1999/11/18 21:28:05  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.11  1999/11/15 20:14:10  koss
   Search entries moved to dlgSearch.
   Fixed layout again.
   Now we use units in KNumInput and not in separate QLabels.

   Revision 1.9  1999/11/09 18:24:38  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.5  1999/05/16 16:59:53  koss
   Added "Window style" radio group and "Windows 9x style for docking" checkbutton
   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kfontdialog.h>
#include <kaudioplayer.h>
#include <kdebug.h>
#include <klineeditdlg.h>
#include <klocale.h>
#include <kdialog.h>

#include "settings.h"
#include "kmainwidget.h"
#include "dlgSystem.h"


DlgSystem::DlgSystem( QWidget *parent )
  : QWidget( parent, "", 0 ) {

  QGridLayout *topGridLayout = new QGridLayout(this, 4, 4, 20, KDialog::spacingHint());

  topGridLayout->setRowStretch(0,7);
  topGridLayout->setRowStretch(1,7);
  topGridLayout->setRowStretch(2,5);
  topGridLayout->setRowStretch(3,5);
    
  topGridLayout->setColStretch(0,5);
  topGridLayout->setColStretch(1,5);
  topGridLayout->setColStretch(2,5);
  topGridLayout->setColStretch(3,5);

  // sound settings

  cb_useSound = new QCheckBox(i18n("Use Sounds"), this );
  topGridLayout->addWidget( cb_useSound, 0, 0 );
  
  cmb_sounds = new QComboBox( this );

  cmb_sounds->insertItem( i18n("Added") );
  cmb_sounds->insertItem( i18n("Started") );
  cmb_sounds->insertItem( i18n("Finished") );
  cmb_sounds->insertItem( i18n("Finished All") );
  topGridLayout->addWidget( cmb_sounds, 0, 1 );

  pb_changesound = new QPushButton(i18n("Change"), this );
  topGridLayout->addWidget( pb_changesound, 0, 2 );
  connect( pb_changesound, SIGNAL( clicked() ), SLOT( setupSound() ) );

  pb_testsound = new QPushButton(i18n("Test"), this );
  topGridLayout->addWidget( pb_testsound, 0, 3 );
  connect( pb_testsound, SIGNAL( clicked() ), SLOT( testSound() ) );

  connect( cb_useSound, SIGNAL(toggled(bool)), cmb_sounds, SLOT(setEnabled(bool)) );
  connect( cb_useSound, SIGNAL(toggled(bool)), pb_changesound, SLOT(setEnabled(bool)) );
  connect( cb_useSound, SIGNAL(toggled(bool)), pb_testsound, SLOT(setEnabled(bool)) );

  // animation settings
  cb_useAnimation = new QCheckBox(i18n("Use Animation"), this );
  topGridLayout->addMultiCellWidget( cb_useAnimation, 1, 1, 0, 1 );

  // window style
  bg_window = new QButtonGroup( i18n("Window Style"), this, "bg_window");
  topGridLayout->addMultiCellWidget( bg_window, 2, 2, 0, 3 );

  QHBoxLayout *hLayout = new QHBoxLayout( bg_window, 20, KDialog::spacingHint() );

  rb_normal = new QRadioButton( i18n("Normal"), bg_window );
  bg_window->insert( rb_normal );
  hLayout->addWidget( rb_normal );

  rb_docked = new QRadioButton( i18n("Dock widget"), bg_window );
  bg_window->insert( rb_docked );
  hLayout->addWidget( rb_docked );

  rb_droptarget = new QRadioButton( i18n("Drop Target"), bg_window );
  bg_window->insert( rb_droptarget );
  hLayout->addWidget( rb_droptarget );

  // font groupbox
  gb_font = new QGroupBox(this, "gb_font");
  gb_font->setTitle(i18n("Font Settings"));
  topGridLayout->addMultiCellWidget( gb_font, 3, 3, 0, 3 );

  QGridLayout *gLayout = new QGridLayout( gb_font, 1, 2, 20, KDialog::spacingHint() );

  gLayout->setRowStretch(0,1);
    
  gLayout->setColStretch(0,10);
  gLayout->setColStretch(1,5);

  lb_font = new QLabel(i18n("Dolor lpse"), gb_font);
  lb_font->setAlignment(AlignHCenter | AlignVCenter);
  lb_font->setBackgroundColor( QColor( white ));
  lb_font->setFrameStyle( QFrame::Box | QFrame::Sunken );
  gLayout->addWidget( lb_font, 0, 0 );

  pb_browse = new QPushButton(i18n("Change"), gb_font );
  connect( pb_browse, SIGNAL( clicked() ), SLOT( changeFont() ) );
  gLayout->addWidget( pb_browse, 0, 1 );
}


void DlgSystem::setupSound() {
  QString s, t;

  int id = cmb_sounds->currentItem();

  switch ( id ) {
  case 0:
    s = i18n( "Filename for sound added :" );
    t = soundAdded;
    break;
  case 1:
    s = i18n( "Filename for sound started :" );
    t = soundStarted;
    break;
  case 2:
    s = i18n( "Filename for sound finished :" );
    t = soundFinished;
    break;
  case 3:
    s = i18n( "Filename for sound finished-all :" );
    t = soundFinishedAll;
    break;
  }

  KLineEditDlg *box = new KLineEditDlg( s, t, this);
  box->show();

  if (!box->result()) {  /* cancelled */
    return;
  }

  s = box->text();
  if ( s.isEmpty() ) { /* answer is "" */
    return;
  }

  switch ( id ) {
  case 0:
    soundAdded = s;
    break;

  case 1:
    soundStarted = s;
    break;

  case 2:
    soundFinished = s;
    break;

  case 3:
    soundFinishedAll = s;
    break;
  }
}



void DlgSystem::testSound() {
  switch ( cmb_sounds->currentItem() ) {
  case 0:
    KAudioPlayer::play( soundAdded );
    break;

  case 1:
    KAudioPlayer::play( soundStarted );
    break;

  case 2:
    KAudioPlayer::play( soundFinished );
    break;

  case 3:
    KAudioPlayer::play( soundFinishedAll );
    break;
  }

}


void DlgSystem::changeFont() {
  KFontDialog *fnd = new KFontDialog( this, "", true );
  fnd->setFont( lb_font->font() );

  if ( fnd->exec() ) {
    lb_font->setFont( fnd->font() );
  }

  delete fnd;
}


void DlgSystem::setData() {
  cb_useSound->setChecked( ksettings.b_useSound );
  cmb_sounds->setEnabled( ksettings.b_useSound );
  pb_changesound->setEnabled( ksettings.b_useSound );
  pb_testsound->setEnabled( ksettings.b_useSound );

  soundAdded = ksettings.audioAdded;
  soundStarted = ksettings.audioStarted;
  soundFinished = ksettings.audioFinished;
  soundFinishedAll = ksettings.audioFinishedAll;

  cb_useAnimation->setChecked( ksettings.b_useAnimation );

  bg_window->setButton( ksettings.windowStyle );

  lb_font->setFont( ksettings.listViewFont );
}


void DlgSystem::applyData() {
  if ( cb_useSound->isChecked() != ksettings.b_useSound ) {
    kmain->slotToggleSound();
  }

  ksettings.audioAdded = soundAdded;
  ksettings.audioStarted = soundStarted;
  ksettings.audioFinished = soundFinished;
  ksettings.audioFinishedAll = soundFinishedAll;

  if ( cb_useAnimation->isChecked() != ksettings.b_useAnimation ) {
    kmain->slotToggleAnimation();
  }

  uint itmp = NORMAL;
  if ( rb_normal->isChecked() ) {
    itmp = NORMAL;
  } else if ( rb_docked->isChecked() ) {
    itmp = DOCKED;
  } else if ( rb_droptarget->isChecked() ) {
    itmp = DROP_TARGET;
  }

  if ( itmp != ksettings.windowStyle ) {
    ksettings.windowStyle = itmp;
    kmain->setWindowStyle();
  }

  ksettings.listViewFont = lb_font->font();
  kmain->setListFont();

}

