/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef CORE_H
#define CORE_H

#include "common.h"

namespace Arts {
enum HeaderMagic {MCOP_MAGIC = 1347371853};
enum MessageType {mcopInvocation = 1, mcopReturn = 2, mcopServerHello = 3, mcopClientHello = 4, mcopAuthAccept = 5, mcopOnewayInvocation = 6};
enum MethodType {methodOneway = 1, methodTwoway = 2};
enum AttributeType {streamIn = 1, streamOut = 2, streamMulti = 4, attributeStream = 8, attributeAttribute = 16, streamAsync = 32, streamDefault = 64};
};
namespace Arts {
class Header : public Arts::Type {
public:
	Header();
	Header(Arts::HeaderMagic magic, long messageLength, Arts::MessageType messageType);
	Header(Arts::Buffer& stream);
	Header(const Header& copyType);
	Header& operator=(const Header& assignType);
	Arts::HeaderMagic magic;
	long messageLength;
	Arts::MessageType messageType;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class Invocation : public Arts::Type {
public:
	Invocation();
	Invocation(long requestID, long objectID, long methodID);
	Invocation(Arts::Buffer& stream);
	Invocation(const Invocation& copyType);
	Invocation& operator=(const Invocation& assignType);
	long requestID;
	long objectID;
	long methodID;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class OnewayInvocation : public Arts::Type {
public:
	OnewayInvocation();
	OnewayInvocation(long objectID, long methodID);
	OnewayInvocation(Arts::Buffer& stream);
	OnewayInvocation(const OnewayInvocation& copyType);
	OnewayInvocation& operator=(const OnewayInvocation& assignType);
	long objectID;
	long methodID;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class ServerHello : public Arts::Type {
public:
	ServerHello();
	ServerHello(const std::string& serverID, const std::vector<std::string>& authProtocols, const std::string& authSeed);
	ServerHello(Arts::Buffer& stream);
	ServerHello(const ServerHello& copyType);
	ServerHello& operator=(const ServerHello& assignType);
	std::string serverID;
	std::vector<std::string> authProtocols;
	std::string authSeed;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class ClientHello : public Arts::Type {
public:
	ClientHello();
	ClientHello(const std::string& serverID, const std::string& authProtocol, const std::string& authData);
	ClientHello(Arts::Buffer& stream);
	ClientHello(const ClientHello& copyType);
	ClientHello& operator=(const ClientHello& assignType);
	std::string serverID;
	std::string authProtocol;
	std::string authData;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class ObjectReference : public Arts::Type {
public:
	ObjectReference();
	ObjectReference(const std::string& serverID, long objectID, const std::vector<std::string>& urls);
	ObjectReference(Arts::Buffer& stream);
	ObjectReference(const ObjectReference& copyType);
	ObjectReference& operator=(const ObjectReference& assignType);
	std::string serverID;
	long objectID;
	std::vector<std::string> urls;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class ParamDef : public Arts::Type {
public:
	ParamDef();
	ParamDef(const std::string& type, const std::string& name);
	ParamDef(Arts::Buffer& stream);
	ParamDef(const ParamDef& copyType);
	ParamDef& operator=(const ParamDef& assignType);
	std::string type;
	std::string name;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class MethodDef : public Arts::Type {
public:
	MethodDef();
	MethodDef(const std::string& name, const std::string& type, Arts::MethodType flags, const std::vector<Arts::ParamDef>& signature);
	MethodDef(Arts::Buffer& stream);
	MethodDef(const MethodDef& copyType);
	MethodDef& operator=(const MethodDef& assignType);
	std::string name;
	std::string type;
	Arts::MethodType flags;
	std::vector<Arts::ParamDef> signature;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class AttributeDef : public Arts::Type {
public:
	AttributeDef();
	AttributeDef(const std::string& name, const std::string& type, Arts::AttributeType flags);
	AttributeDef(Arts::Buffer& stream);
	AttributeDef(const AttributeDef& copyType);
	AttributeDef& operator=(const AttributeDef& assignType);
	std::string name;
	std::string type;
	Arts::AttributeType flags;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class InterfaceDef : public Arts::Type {
public:
	InterfaceDef();
	InterfaceDef(const std::string& name, const std::vector<std::string>& inheritedInterfaces, const std::vector<Arts::MethodDef>& methods, const std::vector<Arts::AttributeDef>& attributes, const std::vector<std::string>& defaultPorts);
	InterfaceDef(Arts::Buffer& stream);
	InterfaceDef(const InterfaceDef& copyType);
	InterfaceDef& operator=(const InterfaceDef& assignType);
	std::string name;
	std::vector<std::string> inheritedInterfaces;
	std::vector<Arts::MethodDef> methods;
	std::vector<Arts::AttributeDef> attributes;
	std::vector<std::string> defaultPorts;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class TypeComponent : public Arts::Type {
public:
	TypeComponent();
	TypeComponent(const std::string& type, const std::string& name);
	TypeComponent(Arts::Buffer& stream);
	TypeComponent(const TypeComponent& copyType);
	TypeComponent& operator=(const TypeComponent& assignType);
	std::string type;
	std::string name;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class TypeDef : public Arts::Type {
public:
	TypeDef();
	TypeDef(const std::string& name, const std::vector<Arts::TypeComponent>& contents);
	TypeDef(Arts::Buffer& stream);
	TypeDef(const TypeDef& copyType);
	TypeDef& operator=(const TypeDef& assignType);
	std::string name;
	std::vector<Arts::TypeComponent> contents;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class EnumComponent : public Arts::Type {
public:
	EnumComponent();
	EnumComponent(const std::string& name, long value);
	EnumComponent(Arts::Buffer& stream);
	EnumComponent(const EnumComponent& copyType);
	EnumComponent& operator=(const EnumComponent& assignType);
	std::string name;
	long value;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class EnumDef : public Arts::Type {
public:
	EnumDef();
	EnumDef(const std::string& name, const std::vector<Arts::EnumComponent>& contents);
	EnumDef(Arts::Buffer& stream);
	EnumDef(const EnumDef& copyType);
	EnumDef& operator=(const EnumDef& assignType);
	std::string name;
	std::vector<Arts::EnumComponent> contents;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class ModuleDef : public Arts::Type {
public:
	ModuleDef();
	ModuleDef(const std::string& moduleName, const std::vector<Arts::ModuleDef>& modules, const std::vector<Arts::EnumDef>& enums, const std::vector<Arts::TypeDef>& types, const std::vector<Arts::InterfaceDef>& interfaces);
	ModuleDef(Arts::Buffer& stream);
	ModuleDef(const ModuleDef& copyType);
	ModuleDef& operator=(const ModuleDef& assignType);
	std::string moduleName;
	std::vector<Arts::ModuleDef> modules;
	std::vector<Arts::EnumDef> enums;
	std::vector<Arts::TypeDef> types;
	std::vector<Arts::InterfaceDef> interfaces;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

};
namespace Arts {
class InterfaceRepo;
class FlowSystemSender;
class FlowSystemReceiver;
class FlowSystem;
class GlobalComm;
class TmpGlobalComm;
class TraderOffer;
class TraderQuery;

class InterfaceRepo_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static InterfaceRepo_base *_create(const std::string& subClass = "Arts::InterfaceRepo");
	static InterfaceRepo_base *_fromString(std::string objectref);
	static InterfaceRepo_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline InterfaceRepo_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long insertModule(const Arts::ModuleDef& newModule) = 0;
	virtual void removeModule(long moduleID) = 0;
	virtual Arts::InterfaceDef queryInterface(const std::string& name) = 0;
	virtual Arts::TypeDef queryType(const std::string& name) = 0;
};

class InterfaceRepo_stub : virtual public InterfaceRepo_base, virtual public Arts::Object_stub {
protected:
	InterfaceRepo_stub();

public:
	InterfaceRepo_stub(Arts::Connection *connection, long objectID);

	long insertModule(const Arts::ModuleDef& newModule);
	void removeModule(long moduleID);
	Arts::InterfaceDef queryInterface(const std::string& name);
	Arts::TypeDef queryType(const std::string& name);
};

class InterfaceRepo_skel : virtual public InterfaceRepo_base, virtual public Arts::Object_skel {
public:
	InterfaceRepo_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class InterfaceRepo : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	InterfaceRepo_base *_cache;
	inline InterfaceRepo_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(InterfaceRepo_base *)_pool->base->_cast(InterfaceRepo_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline InterfaceRepo(InterfaceRepo_base* b) : Object(b), _cache(0) {}


public:
	typedef InterfaceRepo_base _base_class;

	inline InterfaceRepo() : Arts::Object(_Creator), _cache(0) {}
	inline InterfaceRepo(const Arts::SubClass& s) :
		Arts::Object(InterfaceRepo_base::_create(s.string())), _cache(0) {}
	inline InterfaceRepo(const Arts::Reference &r) :
		Arts::Object(r.isString()?(InterfaceRepo_base::_fromString(r.string())):(InterfaceRepo_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline InterfaceRepo(const Arts::DynamicCast& c) : Arts::Object(InterfaceRepo_base::_fromString(c.object().toString())), _cache(0) {}
	inline InterfaceRepo(const InterfaceRepo& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline InterfaceRepo(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static InterfaceRepo null() {return InterfaceRepo((InterfaceRepo_base*)0);}
	inline static InterfaceRepo _from_base(InterfaceRepo_base* b) {return InterfaceRepo(b);}
	inline InterfaceRepo& operator=(const InterfaceRepo& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline InterfaceRepo_base* _base() {return _cache?_cache:_method_call();}

	inline long insertModule(const Arts::ModuleDef& newModule);
	inline void removeModule(long moduleID);
	inline Arts::InterfaceDef queryInterface(const std::string& name);
	inline Arts::TypeDef queryType(const std::string& name);
};

class FlowSystemSender_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static FlowSystemSender_base *_create(const std::string& subClass = "Arts::FlowSystemSender");
	static FlowSystemSender_base *_fromString(std::string objectref);
	static FlowSystemSender_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline FlowSystemSender_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void processed() = 0;
};

class FlowSystemSender_stub : virtual public FlowSystemSender_base, virtual public Arts::Object_stub {
protected:
	FlowSystemSender_stub();

public:
	FlowSystemSender_stub(Arts::Connection *connection, long objectID);

	void processed();
};

class FlowSystemSender_skel : virtual public FlowSystemSender_base, virtual public Arts::Object_skel {
public:
	FlowSystemSender_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class FlowSystemSender : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	FlowSystemSender_base *_cache;
	inline FlowSystemSender_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FlowSystemSender_base *)_pool->base->_cast(FlowSystemSender_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline FlowSystemSender(FlowSystemSender_base* b) : Object(b), _cache(0) {}


public:
	typedef FlowSystemSender_base _base_class;

	inline FlowSystemSender() : Arts::Object(_Creator), _cache(0) {}
	inline FlowSystemSender(const Arts::SubClass& s) :
		Arts::Object(FlowSystemSender_base::_create(s.string())), _cache(0) {}
	inline FlowSystemSender(const Arts::Reference &r) :
		Arts::Object(r.isString()?(FlowSystemSender_base::_fromString(r.string())):(FlowSystemSender_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FlowSystemSender(const Arts::DynamicCast& c) : Arts::Object(FlowSystemSender_base::_fromString(c.object().toString())), _cache(0) {}
	inline FlowSystemSender(const FlowSystemSender& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline FlowSystemSender(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static FlowSystemSender null() {return FlowSystemSender((FlowSystemSender_base*)0);}
	inline static FlowSystemSender _from_base(FlowSystemSender_base* b) {return FlowSystemSender(b);}
	inline FlowSystemSender& operator=(const FlowSystemSender& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline FlowSystemSender_base* _base() {return _cache?_cache:_method_call();}

	inline void processed();
};

class FlowSystemReceiver_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static FlowSystemReceiver_base *_create(const std::string& subClass = "Arts::FlowSystemReceiver");
	static FlowSystemReceiver_base *_fromString(std::string objectref);
	static FlowSystemReceiver_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline FlowSystemReceiver_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long receiveHandlerID() = 0;
};

class FlowSystemReceiver_stub : virtual public FlowSystemReceiver_base, virtual public Arts::Object_stub {
protected:
	FlowSystemReceiver_stub();

public:
	FlowSystemReceiver_stub(Arts::Connection *connection, long objectID);

	long receiveHandlerID();
};

class FlowSystemReceiver_skel : virtual public FlowSystemReceiver_base, virtual public Arts::Object_skel {
public:
	FlowSystemReceiver_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class FlowSystemReceiver : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	FlowSystemReceiver_base *_cache;
	inline FlowSystemReceiver_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FlowSystemReceiver_base *)_pool->base->_cast(FlowSystemReceiver_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline FlowSystemReceiver(FlowSystemReceiver_base* b) : Object(b), _cache(0) {}


public:
	typedef FlowSystemReceiver_base _base_class;

	inline FlowSystemReceiver() : Arts::Object(_Creator), _cache(0) {}
	inline FlowSystemReceiver(const Arts::SubClass& s) :
		Arts::Object(FlowSystemReceiver_base::_create(s.string())), _cache(0) {}
	inline FlowSystemReceiver(const Arts::Reference &r) :
		Arts::Object(r.isString()?(FlowSystemReceiver_base::_fromString(r.string())):(FlowSystemReceiver_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FlowSystemReceiver(const Arts::DynamicCast& c) : Arts::Object(FlowSystemReceiver_base::_fromString(c.object().toString())), _cache(0) {}
	inline FlowSystemReceiver(const FlowSystemReceiver& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline FlowSystemReceiver(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static FlowSystemReceiver null() {return FlowSystemReceiver((FlowSystemReceiver_base*)0);}
	inline static FlowSystemReceiver _from_base(FlowSystemReceiver_base* b) {return FlowSystemReceiver(b);}
	inline FlowSystemReceiver& operator=(const FlowSystemReceiver& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline FlowSystemReceiver_base* _base() {return _cache?_cache:_method_call();}

	inline long receiveHandlerID();
};

class FlowSystem_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static FlowSystem_base *_create(const std::string& subClass = "Arts::FlowSystem");
	static FlowSystem_base *_fromString(std::string objectref);
	static FlowSystem_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline FlowSystem_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void startObject(Arts::Object node) = 0;
	virtual void stopObject(Arts::Object node) = 0;
	virtual void connectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort) = 0;
	virtual void disconnectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort) = 0;
	virtual Arts::AttributeType queryFlags(Arts::Object node, const std::string& port) = 0;
	virtual Arts::FlowSystemReceiver createReceiver(Arts::Object destObject, const std::string& destPort, Arts::FlowSystemSender sender) = 0;
};

class FlowSystem_stub : virtual public FlowSystem_base, virtual public Arts::Object_stub {
protected:
	FlowSystem_stub();

public:
	FlowSystem_stub(Arts::Connection *connection, long objectID);

	void startObject(Arts::Object node);
	void stopObject(Arts::Object node);
	void connectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort);
	void disconnectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort);
	Arts::AttributeType queryFlags(Arts::Object node, const std::string& port);
	Arts::FlowSystemReceiver createReceiver(Arts::Object destObject, const std::string& destPort, Arts::FlowSystemSender sender);
};

class FlowSystem_skel : virtual public FlowSystem_base, virtual public Arts::Object_skel {
public:
	FlowSystem_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class FlowSystem : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	FlowSystem_base *_cache;
	inline FlowSystem_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(FlowSystem_base *)_pool->base->_cast(FlowSystem_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline FlowSystem(FlowSystem_base* b) : Object(b), _cache(0) {}


public:
	typedef FlowSystem_base _base_class;

	inline FlowSystem() : Arts::Object(_Creator), _cache(0) {}
	inline FlowSystem(const Arts::SubClass& s) :
		Arts::Object(FlowSystem_base::_create(s.string())), _cache(0) {}
	inline FlowSystem(const Arts::Reference &r) :
		Arts::Object(r.isString()?(FlowSystem_base::_fromString(r.string())):(FlowSystem_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline FlowSystem(const Arts::DynamicCast& c) : Arts::Object(FlowSystem_base::_fromString(c.object().toString())), _cache(0) {}
	inline FlowSystem(const FlowSystem& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline FlowSystem(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static FlowSystem null() {return FlowSystem((FlowSystem_base*)0);}
	inline static FlowSystem _from_base(FlowSystem_base* b) {return FlowSystem(b);}
	inline FlowSystem& operator=(const FlowSystem& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline FlowSystem_base* _base() {return _cache?_cache:_method_call();}

	inline void startObject(Arts::Object node);
	inline void stopObject(Arts::Object node);
	inline void connectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort);
	inline void disconnectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort);
	inline Arts::AttributeType queryFlags(Arts::Object node, const std::string& port);
	inline Arts::FlowSystemReceiver createReceiver(Arts::Object destObject, const std::string& destPort, Arts::FlowSystemSender sender);
};

class GlobalComm_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static GlobalComm_base *_create(const std::string& subClass = "Arts::GlobalComm");
	static GlobalComm_base *_fromString(std::string objectref);
	static GlobalComm_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline GlobalComm_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual bool put(const std::string& variable, const std::string& value) = 0;
	virtual std::string get(const std::string& variable) = 0;
	virtual void erase(const std::string& variable) = 0;
};

class GlobalComm_stub : virtual public GlobalComm_base, virtual public Arts::Object_stub {
protected:
	GlobalComm_stub();

public:
	GlobalComm_stub(Arts::Connection *connection, long objectID);

	bool put(const std::string& variable, const std::string& value);
	std::string get(const std::string& variable);
	void erase(const std::string& variable);
};

class GlobalComm_skel : virtual public GlobalComm_base, virtual public Arts::Object_skel {
public:
	GlobalComm_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class GlobalComm : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	GlobalComm_base *_cache;
	inline GlobalComm_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(GlobalComm_base *)_pool->base->_cast(GlobalComm_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline GlobalComm(GlobalComm_base* b) : Object(b), _cache(0) {}


public:
	typedef GlobalComm_base _base_class;

	inline GlobalComm() : Arts::Object(_Creator), _cache(0) {}
	inline GlobalComm(const Arts::SubClass& s) :
		Arts::Object(GlobalComm_base::_create(s.string())), _cache(0) {}
	inline GlobalComm(const Arts::Reference &r) :
		Arts::Object(r.isString()?(GlobalComm_base::_fromString(r.string())):(GlobalComm_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline GlobalComm(const Arts::DynamicCast& c) : Arts::Object(GlobalComm_base::_fromString(c.object().toString())), _cache(0) {}
	inline GlobalComm(const GlobalComm& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline GlobalComm(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static GlobalComm null() {return GlobalComm((GlobalComm_base*)0);}
	inline static GlobalComm _from_base(GlobalComm_base* b) {return GlobalComm(b);}
	inline GlobalComm& operator=(const GlobalComm& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline GlobalComm_base* _base() {return _cache?_cache:_method_call();}

	inline bool put(const std::string& variable, const std::string& value);
	inline std::string get(const std::string& variable);
	inline void erase(const std::string& variable);
};

class TmpGlobalComm_base : virtual public Arts::GlobalComm_base {
public:
	static unsigned long _IID; // interface ID

	static TmpGlobalComm_base *_create(const std::string& subClass = "Arts::TmpGlobalComm");
	static TmpGlobalComm_base *_fromString(std::string objectref);
	static TmpGlobalComm_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline TmpGlobalComm_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class TmpGlobalComm_stub : virtual public TmpGlobalComm_base, virtual public Arts::GlobalComm_stub {
protected:
	TmpGlobalComm_stub();

public:
	TmpGlobalComm_stub(Arts::Connection *connection, long objectID);

};

class TmpGlobalComm_skel : virtual public TmpGlobalComm_base, virtual public Arts::GlobalComm_skel {
public:
	TmpGlobalComm_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class TmpGlobalComm : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	TmpGlobalComm_base *_cache;
	inline TmpGlobalComm_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(TmpGlobalComm_base *)_pool->base->_cast(TmpGlobalComm_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline TmpGlobalComm(TmpGlobalComm_base* b) : Object(b), _cache(0) {}


public:
	typedef TmpGlobalComm_base _base_class;

	inline TmpGlobalComm() : Arts::Object(_Creator), _cache(0) {}
	inline TmpGlobalComm(const Arts::SubClass& s) :
		Arts::Object(TmpGlobalComm_base::_create(s.string())), _cache(0) {}
	inline TmpGlobalComm(const Arts::Reference &r) :
		Arts::Object(r.isString()?(TmpGlobalComm_base::_fromString(r.string())):(TmpGlobalComm_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline TmpGlobalComm(const Arts::DynamicCast& c) : Arts::Object(TmpGlobalComm_base::_fromString(c.object().toString())), _cache(0) {}
	inline TmpGlobalComm(const TmpGlobalComm& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline TmpGlobalComm(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static TmpGlobalComm null() {return TmpGlobalComm((TmpGlobalComm_base*)0);}
	inline static TmpGlobalComm _from_base(TmpGlobalComm_base* b) {return TmpGlobalComm(b);}
	inline TmpGlobalComm& operator=(const TmpGlobalComm& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GlobalComm() const { return Arts::GlobalComm(*_pool); }
	inline TmpGlobalComm_base* _base() {return _cache?_cache:_method_call();}

	inline bool put(const std::string& variable, const std::string& value);
	inline std::string get(const std::string& variable);
	inline void erase(const std::string& variable);
};

class TraderOffer_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static TraderOffer_base *_create(const std::string& subClass = "Arts::TraderOffer");
	static TraderOffer_base *_fromString(std::string objectref);
	static TraderOffer_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline TraderOffer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string interfaceName() = 0;
	virtual std::vector<std::string> * getProperty(const std::string& name) = 0;
};

class TraderOffer_stub : virtual public TraderOffer_base, virtual public Arts::Object_stub {
protected:
	TraderOffer_stub();

public:
	TraderOffer_stub(Arts::Connection *connection, long objectID);

	std::string interfaceName();
	std::vector<std::string> * getProperty(const std::string& name);
};

class TraderOffer_skel : virtual public TraderOffer_base, virtual public Arts::Object_skel {
public:
	TraderOffer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class TraderOffer : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	TraderOffer_base *_cache;
	inline TraderOffer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(TraderOffer_base *)_pool->base->_cast(TraderOffer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline TraderOffer(TraderOffer_base* b) : Object(b), _cache(0) {}


public:
	typedef TraderOffer_base _base_class;

	inline TraderOffer() : Arts::Object(_Creator), _cache(0) {}
	inline TraderOffer(const Arts::SubClass& s) :
		Arts::Object(TraderOffer_base::_create(s.string())), _cache(0) {}
	inline TraderOffer(const Arts::Reference &r) :
		Arts::Object(r.isString()?(TraderOffer_base::_fromString(r.string())):(TraderOffer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline TraderOffer(const Arts::DynamicCast& c) : Arts::Object(TraderOffer_base::_fromString(c.object().toString())), _cache(0) {}
	inline TraderOffer(const TraderOffer& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline TraderOffer(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static TraderOffer null() {return TraderOffer((TraderOffer_base*)0);}
	inline static TraderOffer _from_base(TraderOffer_base* b) {return TraderOffer(b);}
	inline TraderOffer& operator=(const TraderOffer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline TraderOffer_base* _base() {return _cache?_cache:_method_call();}

	inline std::string interfaceName();
	inline std::vector<std::string> * getProperty(const std::string& name);
};

class TraderQuery_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static TraderQuery_base *_create(const std::string& subClass = "Arts::TraderQuery");
	static TraderQuery_base *_fromString(std::string objectref);
	static TraderQuery_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	inline TraderQuery_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void supports(const std::string& property, const std::string& value) = 0;
	virtual std::vector<Arts::TraderOffer> * query() = 0;
};

class TraderQuery_stub : virtual public TraderQuery_base, virtual public Arts::Object_stub {
protected:
	TraderQuery_stub();

public:
	TraderQuery_stub(Arts::Connection *connection, long objectID);

	void supports(const std::string& property, const std::string& value);
	std::vector<Arts::TraderOffer> * query();
};

class TraderQuery_skel : virtual public TraderQuery_base, virtual public Arts::Object_skel {
public:
	TraderQuery_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace Arts {
class TraderQuery : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	TraderQuery_base *_cache;
	inline TraderQuery_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(TraderQuery_base *)_pool->base->_cast(TraderQuery_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline TraderQuery(TraderQuery_base* b) : Object(b), _cache(0) {}


public:
	typedef TraderQuery_base _base_class;

	inline TraderQuery() : Arts::Object(_Creator), _cache(0) {}
	inline TraderQuery(const Arts::SubClass& s) :
		Arts::Object(TraderQuery_base::_create(s.string())), _cache(0) {}
	inline TraderQuery(const Arts::Reference &r) :
		Arts::Object(r.isString()?(TraderQuery_base::_fromString(r.string())):(TraderQuery_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline TraderQuery(const Arts::DynamicCast& c) : Arts::Object(TraderQuery_base::_fromString(c.object().toString())), _cache(0) {}
	inline TraderQuery(const TraderQuery& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline TraderQuery(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static TraderQuery null() {return TraderQuery((TraderQuery_base*)0);}
	inline static TraderQuery _from_base(TraderQuery_base* b) {return TraderQuery(b);}
	inline TraderQuery& operator=(const TraderQuery& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline TraderQuery_base* _base() {return _cache?_cache:_method_call();}

	inline void supports(const std::string& property, const std::string& value);
	inline std::vector<Arts::TraderOffer> * query();
};

// Forward wrapper calls to _base classes:

inline long Arts::InterfaceRepo::insertModule(const Arts::ModuleDef& newModule)
{
	return _cache?static_cast<Arts::InterfaceRepo_base*>(_cache)->insertModule(newModule):static_cast<Arts::InterfaceRepo_base*>(_method_call())->insertModule(newModule);
}

inline void Arts::InterfaceRepo::removeModule(long moduleID)
{
	 _cache?static_cast<Arts::InterfaceRepo_base*>(_cache)->removeModule(moduleID):static_cast<Arts::InterfaceRepo_base*>(_method_call())->removeModule(moduleID);
}

inline Arts::InterfaceDef Arts::InterfaceRepo::queryInterface(const std::string& name)
{
	return _cache?static_cast<Arts::InterfaceRepo_base*>(_cache)->queryInterface(name):static_cast<Arts::InterfaceRepo_base*>(_method_call())->queryInterface(name);
}

inline Arts::TypeDef Arts::InterfaceRepo::queryType(const std::string& name)
{
	return _cache?static_cast<Arts::InterfaceRepo_base*>(_cache)->queryType(name):static_cast<Arts::InterfaceRepo_base*>(_method_call())->queryType(name);
}

inline void Arts::FlowSystemSender::processed()
{
	 _cache?static_cast<Arts::FlowSystemSender_base*>(_cache)->processed():static_cast<Arts::FlowSystemSender_base*>(_method_call())->processed();
}

inline long Arts::FlowSystemReceiver::receiveHandlerID()
{
	return _cache?static_cast<Arts::FlowSystemReceiver_base*>(_cache)->receiveHandlerID():static_cast<Arts::FlowSystemReceiver_base*>(_method_call())->receiveHandlerID();
}

inline void Arts::FlowSystem::startObject(Arts::Object node)
{
	 _cache?static_cast<Arts::FlowSystem_base*>(_cache)->startObject(node):static_cast<Arts::FlowSystem_base*>(_method_call())->startObject(node);
}

inline void Arts::FlowSystem::stopObject(Arts::Object node)
{
	 _cache?static_cast<Arts::FlowSystem_base*>(_cache)->stopObject(node):static_cast<Arts::FlowSystem_base*>(_method_call())->stopObject(node);
}

inline void Arts::FlowSystem::connectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort)
{
	 _cache?static_cast<Arts::FlowSystem_base*>(_cache)->connectObject(sourceObject, sourcePort, destObject, destPort):static_cast<Arts::FlowSystem_base*>(_method_call())->connectObject(sourceObject, sourcePort, destObject, destPort);
}

inline void Arts::FlowSystem::disconnectObject(Arts::Object sourceObject, const std::string& sourcePort, Arts::Object destObject, const std::string& destPort)
{
	 _cache?static_cast<Arts::FlowSystem_base*>(_cache)->disconnectObject(sourceObject, sourcePort, destObject, destPort):static_cast<Arts::FlowSystem_base*>(_method_call())->disconnectObject(sourceObject, sourcePort, destObject, destPort);
}

inline Arts::AttributeType Arts::FlowSystem::queryFlags(Arts::Object node, const std::string& port)
{
	return _cache?static_cast<Arts::FlowSystem_base*>(_cache)->queryFlags(node, port):static_cast<Arts::FlowSystem_base*>(_method_call())->queryFlags(node, port);
}

inline Arts::FlowSystemReceiver Arts::FlowSystem::createReceiver(Arts::Object destObject, const std::string& destPort, Arts::FlowSystemSender sender)
{
	return _cache?static_cast<Arts::FlowSystem_base*>(_cache)->createReceiver(destObject, destPort, sender):static_cast<Arts::FlowSystem_base*>(_method_call())->createReceiver(destObject, destPort, sender);
}

inline bool Arts::GlobalComm::put(const std::string& variable, const std::string& value)
{
	return _cache?static_cast<Arts::GlobalComm_base*>(_cache)->put(variable, value):static_cast<Arts::GlobalComm_base*>(_method_call())->put(variable, value);
}

inline std::string Arts::GlobalComm::get(const std::string& variable)
{
	return _cache?static_cast<Arts::GlobalComm_base*>(_cache)->get(variable):static_cast<Arts::GlobalComm_base*>(_method_call())->get(variable);
}

inline void Arts::GlobalComm::erase(const std::string& variable)
{
	 _cache?static_cast<Arts::GlobalComm_base*>(_cache)->erase(variable):static_cast<Arts::GlobalComm_base*>(_method_call())->erase(variable);
}

inline bool Arts::TmpGlobalComm::put(const std::string& variable, const std::string& value)
{
	return _cache?static_cast<Arts::GlobalComm_base*>(_cache)->put(variable, value):static_cast<Arts::GlobalComm_base*>(_method_call())->put(variable, value);
}

inline std::string Arts::TmpGlobalComm::get(const std::string& variable)
{
	return _cache?static_cast<Arts::GlobalComm_base*>(_cache)->get(variable):static_cast<Arts::GlobalComm_base*>(_method_call())->get(variable);
}

inline void Arts::TmpGlobalComm::erase(const std::string& variable)
{
	 _cache?static_cast<Arts::GlobalComm_base*>(_cache)->erase(variable):static_cast<Arts::GlobalComm_base*>(_method_call())->erase(variable);
}

inline std::string Arts::TraderOffer::interfaceName()
{
	return _cache?static_cast<Arts::TraderOffer_base*>(_cache)->interfaceName():static_cast<Arts::TraderOffer_base*>(_method_call())->interfaceName();
}

inline std::vector<std::string> * Arts::TraderOffer::getProperty(const std::string& name)
{
	return _cache?static_cast<Arts::TraderOffer_base*>(_cache)->getProperty(name):static_cast<Arts::TraderOffer_base*>(_method_call())->getProperty(name);
}

inline void Arts::TraderQuery::supports(const std::string& property, const std::string& value)
{
	 _cache?static_cast<Arts::TraderQuery_base*>(_cache)->supports(property, value):static_cast<Arts::TraderQuery_base*>(_method_call())->supports(property, value);
}

inline std::vector<Arts::TraderOffer> * Arts::TraderQuery::query()
{
	return _cache?static_cast<Arts::TraderQuery_base*>(_cache)->query():static_cast<Arts::TraderQuery_base*>(_method_call())->query();
}

};
#endif /* CORE_H */
