/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <qtooltip.h>

#include <kglobal.h>

#include "global.h"
#include "player.h"
#include "playerbox.h"
#include "defines.h"

PlayerBox::PlayerBox(QWidget* parent, const char* name) : QGroupBox(parent, name)
{
 cardW = new CardWidget *[CARDS];
 heldLabels = new QLabel *[CARDS];
 QFont myFixedFont("Helvetica", 12);

 for (int i = 0; i < CARDS; i++) {
	cardW[i] = new CardWidget(this, 0);
	cardW[i]->move(cardHDist + i * (cardHDist + cardWidth), cardDistFromTop);

	heldLabels[i] = new QLabel(this, 0);
	heldLabels[i]->hide();
 	heldLabels[i]->setFont(myFixedFont);
	heldLabels[i]->setText(i18n("Held"));
	heldLabels[i]->adjustSize(); // setAutoResize() is obsolete :-(
	heldLabels[i]->move(((cardWidth + 2) /2 - heldLabels[i]->width() /2) + cardHDist + i * (cardHDist + cardWidth), cardDistFromTop - 15);
	cardW[i]->heldLabel = heldLabels[i];

	//connects for player 1 -> make them for all players. I hope they'll only be used by player 1
//	connect(cardW[i], SIGNAL(clicked()), cardW[i], SLOT(ownClick()));
	}

 cashLabel = new QLabel(this, 0);
 cashLabel->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
 cashLabel->setFont(myFixedFont);

 currentBetLabel = new QLabel(this, 0);
 currentBetLabel->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
 currentBetLabel->setFont(myFixedFont);

 QToolTip::add(cashLabel, i18n("Money of %1").arg("Player"));//change via setName()

 onePlayer = false;

}

PlayerBox::~PlayerBox()
{

}

void PlayerBox::resizeEvent(QResizeEvent* e)
{
 QGroupBox::resizeEvent(e);

 paintCash();
 setName();
}

void PlayerBox::paintCash()
{
 cashLabel->setText(i18n("Cash: %1").arg(KGlobal::locale()->formatMoney(localPlayer->getCash())));
 cashLabel->update();
 cashLabel->adjustSize();
 cashLabel->move((cardW[CARDS-1]->x() + cardW[CARDS-1]->width()) /2 + this->width() /2 - cashLabel->width() /2, 15 + 20); // let's hold it in the middle of the free area

 if (!localPlayer->out()) {
	if (!onePlayer)
		currentBetLabel->setText(i18n("Bet: %1").arg(KGlobal::locale()->formatMoney(localPlayer->getCurrentBet())));
	else
		currentBetLabel->setText(i18n("Cash per round: %1").arg(KGlobal::locale()->formatMoney(cashPerRound)));
	}
 else
	currentBetLabel->setText(i18n("Out"));
 currentBetLabel->update();
 currentBetLabel->adjustSize();
 int freeAreaX = this->width() - (this->width() - cardW[CARDS-1]->x() - cardW[CARDS-1]->width());
 currentBetLabel->move(this->width() - (this->width() - freeAreaX) /2 - currentBetLabel->width() /2, 15 + 50);

}

void PlayerBox::setName()
{
 setTitle(localPlayer->getName());
 QToolTip::remove(cashLabel);
 QToolTip::add(cashLabel, i18n("Money of %1").arg(localPlayer->getName()));
}

void PlayerBox::showHelds(bool e) 
{
 for (int i = 0; i < CARDS; i++) {
	if (!e) {
 		cardW[i]->heldLabel->hide();
 		cardW[i]->setHeld(e);
	}
	else
		cardW[i]->heldLabel->show();
 }
}

void PlayerBox::paintCard(int nr)
{
 cardW[nr]->paintCard(localPlayer->getCard(nr));
 cardW[nr]->show();
}

void PlayerBox::activateToggleHeld()
{
 for (int i = 0; i < CARDS; i++) {
	 connect(cardW[i], SIGNAL(pClicked(CardWidget*)), this, SLOT(cardClicked(CardWidget*)));
 }
}

void PlayerBox::cardClicked(CardWidget* MyCW)
{
 if (showLabels && MyCW->toggleHeld()) 
 	MyCW->heldLabel->show();
 else
 	MyCW->heldLabel->hide();
}


void PlayerBox::paintDeck(int nr)
{
 localPlayer->giveCardBack(nr);
 paintCard(nr);
}

void PlayerBox::blinkOn()
{
 for (int i = 0; i < CARDS; i++) {
	if (localPlayer->getFoundCard(i).cardType != 0) 
		hideCard(localPlayer->getFoundCard(i).cardNum);
 }
}

void PlayerBox::blinkOff()
{
 for (int i = 0; i < CARDS; i++) {
	if (!cardW[i]->isVisible())
		paintCard(i);
 }
// repaintCards(); 
}

void PlayerBox::setHeldEnabled(bool on)
{
 showLabels = on;
 if (!on) {
	for (int i = 0; i < CARDS; i++)
		heldLabels[i]->hide();
 }
}

void PlayerBox::onePlayerGame(int newCashPerRound)
{
 onePlayer = true;
 cashPerRound = newCashPerRound;
}


