/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef TASKBAR_H
#define TASKBAR_H

#include <qpushbutton.h>
#include <qtimer.h>
#include <qlist.h>
#include <qintdict.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <dcopobject.h>
#include "../../internalapplet.h"
#include "AppStarting.h"


class AppStartButton : public QPushButton
{
    Q_OBJECT
public:
    AppStartButton(const QString &text, const QString &icon, pid_t pid, QWidget * parent);
    QSizePolicy sizePolicy() const;
    QSize sizeHint() const;
signals:
    void killMe(pid_t);
protected slots:
    void animTimerFired();
protected:
    void timerEvent(QTimerEvent *);
    void drawButton( QPainter *p );
    void mousePressEvent( QMouseEvent *e );
private:
    QPixmap pixmap;
    QList<QPixmap> anim;
    int frame;
    QTimer animTimer;
    pid_t pid_;
};


class TaskButton: public QPushButton
{
    Q_OBJECT
public:
    TaskButton( WId w, QWidget * parent, const char *name = 0 );
    ~TaskButton();

    WId window() const { return win; }
    void setActiveButton();
    void refresh();
    bool onCurrentDesktop() const;
    QSizePolicy sizePolicy() const;
    QSize sizeHint() const;
    static void noActiveButton();

protected:
    enum WindowOperation {
        MaximizeOp = 100,
        IconifyOp,
        CloseOp
    };
    void drawButton(QPainter *p);
    void mousePressEvent( QMouseEvent *e );

private slots:
    void toggled();
    void clientPopupAboutToShow();
    void desktopPopupAboutToShow();

    void clientPopupActivated(int);
    void sendToDesktop(int);

private:
    static TaskButton* activeButton;
    WId win;
    QPixmap pixmap;
    int desktop;
    bool sticky;

    QPopupMenu *popup;
    QPopupMenu *desk_popup;
};

class TaskbarApplet : public InternalApplet, virtual public AppStarting
{
    Q_OBJECT
public:
    TaskbarApplet(const char* name = 0);
    TaskbarApplet(QWidget* parent, const char* name = 0);
    ~TaskbarApplet();

    int widthForHeight(int h);
    int heightForWidth(int w);
  
    void resetLayout();

    void clientStarted(QString, QString, pid_t);
    void clientMapped(pid_t);
    void clientDied(pid_t);

protected slots:
    void killAppStartButton(pid_t);
    void windowAdd(WId);
    void windowRemove(WId);
    void windowChange(WId);
    void windowActivate(WId);

    void desktopChange(int);

 protected:
    void resizeEvent(QResizeEvent*);

    void setPosition(Position p);
    void layoutExternal();

private:
    QMap<pid_t, AppStartButton *> appsStarting;
    QList<TaskButton> buttons;
    int taskbar_size;
    int lastH;
    TaskButton* findButton(WId w);

    Position pos;

    bool show_all;
};

#endif
