/*
 *  Copyright (c) 2000 Matthias Hlzer-Klpfel <hoelzer@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 */

#include <kapp.h>
#include <kcmdlineargs.h>
#include <klocale.h>


#include "swallow.h"


static KCmdLineOptions options[] =
{ 
  { "appletId <id>", I18N_NOOP("For internal use only."), "" },
  {"c <cmd>", I18N_NOOP("The command to execute"), 0},
  {"t <title>", I18N_NOOP("The window title to trigger swallowing"), 0},
  {0, 0, 0}
};

int main( int argc, char ** argv )
{
  KCmdLineArgs::init(argc, argv, "swallowapplet", I18N_NOOP("Swallow applet for kicker."), "v0.1.0" );
  KCmdLineArgs::addCmdLineOptions(options);
  KApplication::addCmdLineOptions();

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  KApplication a;
  
  SwallowApplet applet( 0, "swallow applet");
  a.setMainWidget( &applet );
  if(applet.dock(args->getOption("appletId")))
    return a.exec();
  else
    return 1;
}
