#ifndef USERCLASSES_H
#define USERCLASSES_H

#include "ftpaccess.h"
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

class UserClasses : public QWidget {
	Q_OBJECT
public:
			UserClasses(QWidget * parent=0, const char * name=0);
			~UserClasses();
public slots:
	void		newClassPressed();
	void		deleteClassPressed();
	void		addLimitPressed();
	void		editLimitPressed();
	void		deleteLimitPressed();
	void		limitChanged(ftplimit *f, ftpclass *c);
	void		classAdded(ftpclass *c);
	void		classDeleted(char const * const c);
	void		groupSelected(const QString &item);
	void		autogroupSelected();
	void		classSelected(const QString &item);
	void		ftpaccessLoaded(ftpaccess *xs);
	void		update();
private:
	void		redrawList();
	void		redrawLimits();
	ftpaccess *	ftpxs;
	char const *	current;

	QListBox *	classes;	// for class definition
	QCheckBox *	anon;
	QCheckBox *	guest;
	QCheckBox *	real;
	QPushButton *	newclass;
	QPushButton *	deleteclass;
	QLineEdit *	addrs;

	QCheckBox *	autogroup;	// for autogroup
	QListBox *	groups;

	QListBox *	limits;		// for limit
	QPushButton *	addLimit;
	QPushButton *	editLimit;
	QPushButton *	rmLimit;
};

#endif

