// Widget for chosing a filename...

#include <kapp.h>
#include <stdlib.h>
#include <klocale.h>
#include <kdialog.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include "InputFileCtl.moc"

InputFileCtl::InputFileCtl(QString const prompt, QString const initial, bool wDir, QString const sel, QWidget *parent, const char *name):QWidget(parent, name)
{
	int space=KDialog::spacingHint();
	DirDlg=wDir;
	filename=new InputCtl(prompt,initial,this);
	if(sel==QString::null)
		select=new QPushButton(i18n("&Select"),this);
	else
		select=new QPushButton(sel,this);
	select->resize(select->sizeHint().width(),select->height());
	filename->setGeometry(0,0,width()-select->width()-space,filename->height());
	select->move(filename->width()+space,0);
	connect(select,SIGNAL(clicked()),SLOT(selectPressed()));
}
void InputFileCtl::resize(int w, int h)
{
	int space=KDialog::spacingHint();
	QWidget::resize(w,h);
	filename->resize(w-select->width()-space,filename->height());
	select->move(filename->x()+filename->width()+space,0);
}
void InputFileCtl::setGeometry(int x, int y, int w, int h)
{
	move(x,y);
	resize(w,h);
}
InputFileCtl::~InputFileCtl()
{
	delete filename;
	delete select;
}
void InputFileCtl::setText(QString const txt)
{
	filename->setText(txt);
}
QString const InputFileCtl::text()
{
	return filename->text();
}
void InputFileCtl::selectPressed()
{
	QString n;
	
	if( DirDlg )
	{
		n = KFileDialog::getExistingDirectory(getenv("PWD"),this,i18n("Select file"));

		if( n.right( 1 ) == "/" )
		  n = n.left( n.length() - 1 );
	}
	else
	{
		KURL url;
		url = KFileDialog::getOpenURL(getenv("PWD"),"*",this,i18n("Select file"));

                if( !url.isLocalFile() )
		{
		  KMessageBox::sorry( 0L, i18n( "Only local files are supported yes." ) );
		  return;
		}

		n = url.path();
	}
	
	if( !n.isEmpty() )
		filename->setText(n);
}
void InputFileCtl::setEnabled(bool enable)
{
	filename->setEnabled(enable);
	select->setEnabled(enable);
}
