#include "AddVHost.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <qtooltip.h>
#include <kapp.h>

AddVHost::AddVHost(QWidget * parent, char * wname): QWidget(parent, wname)
{
	int y;
	this->setCaption(i18n("Add virtual host"));
	resize(320,80);
	setFixedSize(320,80);
	IP=new InputCtl(i18n("&IP:"),0,this);
	IP->setGeometry(5,5,width()-10,IP->height());
	y=5+IP->height()+5;
	QToolTip::add(IP,i18n("Enter the IP address of the new virtual host here."));
	ok=new QPushButton(i18n("&OK"),this);
	ok->setAutoDefault(true);
	ok->setDefault(true);
	ok->setGeometry(5,y,this->width()/2-10,ok->height());
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
	cancel->setGeometry(this->width()/2+5,y,this->width()/2-10,cancel->height());
	show();
}
AddVHost::~AddVHost()
{
	delete IP;
	delete ok;
	delete cancel;
}
void AddVHost::okButtonPressed()
{
	QString I=IP->text();
	if(I!=QString::null)
		emit VHostAdded(I);
	delete this;
}
void AddVHost::cancelButtonPressed()
{
	delete this;
}
