/***************************************************************************
                          kservice.h  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSERVICE_H
#define KSERVICE_H

#pragma interface

#include <qstring.h>

/**
 * The long description for this class goes here
 *
 * @short This is the short description
 * @author Peter Putzer <putzer@kde.org>
 * @version 0.1
 */
class KService 
{
public:

  /**
   * Named constructor
   */
  static KService* newService (QString name, QString basedir);

  /**
   * Destructor
   */
  ~KService();
  
  /**
   * Is the service active in runlevel "level"?
   */
  bool isOn (int level) const;

  /**
   * Is the service configured for runlevel "level"?
   */
  bool isConfigured (int level) const;
  
  /**
   * Set the service on or off in runlevel "level"
   */
  int set( int level, bool on = true );

  /**
   * Returns the description of the service
   */
  QString description () const;

private:
  /**
   * Copy Constructor
   */
  KService(const KService&);

  /**
   * Default Constructor
   */
  KService();

protected:
  friend class KServiceGUI;
  friend class KServiceManagerWidget;

  /**
   * Constructor
   */
  KService (QString name, QString basedir);

  /**
   * Name of the service
   */
  QString name_;

  /**
   * Description of the service (i.e. what it does)
   */
  QString desc_;
  
  /**
   * Base dir for storing runlevel dirs
   */
  QString base_;

  int levels, kPriority, sPriority;
};

#endif // KSERVICE_H
