// (c) 2000 Peter Putzer

#ifndef KNDRAGLIST_H
#define KNDRAGLIST_H

#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <klistview.h>
#include <qdragobject.h>

class QPopupMenu;
class QDragObject;
class QString;
class QPoint;
class K2ListView;

class K2ListViewItem
{
public:
  inline virtual ~K2ListViewItem () {}

  /**
   * Set the context menu for the item. You still
   * have to delete this somewhere, KDLItem does NOT
   * assume ownership of the menu!
   *
   * @param m if 0 no menu will be shown on right click
   */
  inline void setContextMenu (QPopupMenu* m)
  {
    mContextMenu = m;
  }

  /**
   * Returns the current context menu for the item.
   */
  inline QPopupMenu* contextMenu() const
  {
    return mContextMenu;
  }

  /**
   * returns a deep copy
   */
  virtual K2ListViewItem* clone() const /* = 0; */ { return 0L; }

  /**
   * Text for tooltip when cursor is over the item
   */
  virtual QString tooltip() const = 0;

  /**
   * Popup context menu at (global) position pos
   */
  void showContextMenu ( const QPoint& pos ) const;

  inline int popupMenuAtIndex () const { return mMenuIndex; }
  void setPopupMenuAtIndex (int index);

  virtual void setDragEnabled (bool allow);
  virtual void setDropEnabled (bool allow);

  inline bool dragEnabled () const { return mDragEnabled; }
  inline bool dropEnabled () const { return mDropEnabled; }

protected:
  K2ListViewItem (bool drag = false, bool drop = false, QPopupMenu* menu = 0L);

private:
  QPopupMenu* mContextMenu;
  bool mDragEnabled;
  bool mDropEnabled;
  
  int mMenuIndex;
};


/**
 * Can be used like a @ref QListView BUT you shouldn't insert @ref QListViewItem's, only
 * @ref K2ListViewItem's!
 */
class K2ListView : public KListView
{
  Q_OBJECT

//   Q_PROPERTY (int popupMenuAtIndex READ popupMenuAtIndex WRITE setPopupMenuAtIndex)

public:
  K2ListView (QWidget* parent, const char* name = 0L);
  virtual ~K2ListView();

  QListViewItem* where (const QPoint& pos);

//   inline QPopupMenu* contextMenu () const { return mContextMenu; }
//   inline void setContextMenu (QPopupMenu* m) { mContextMenu = m; }

  inline bool displayToolTips () const { return mDisplayToolTips; }
  inline bool commonToolTips () const { return mCommonToolTips; }

  inline const QString& tooltip () const { return mToolTip; }
  inline const QString& horizontalScrollBarTip () const { return mHorizontalTip; }
  inline const QString& verticalScrollBarTip () const { return mVerticalTip; }
  inline QDragObject::DragMode dragMode () const { return mDragMode; }

  /**
   * \return the width of the insertmarker.
   */
  inline int insertMarkerWidth () const { return mMarkerWidth; }

//   inline int popupMenuAtIndex () const { return mMenuIndex; }

public slots:
  inline void setDisplayToolTips (bool val) { mDisplayToolTips = val; }
  inline void setCommonToolTips (bool val) { mCommonToolTips = val; }
  inline void setHorizontalScrollBarTip (const QString& t) { mHorizontalTip = t; }
  inline void setVerticalScrollBarTip (const QString& t) { mVerticalTip = t; }
  inline void setToolTip (const QString& t) { mToolTip = t; }
  inline void setDragMode (QDragObject::DragMode mode = QDragObject::DragDefault) { mDragMode = mode; }
  inline void setInsertMarkerWidth (int w) { mMarkerWidth = w; }

//   void setPopupMenuAtIndex (int index);

protected:
//   virtual void contentsDragEnterEvent (QDragEnterEvent*);
//   virtual void contentsDragLeaveEvent (QDragLeaveEvent*);
//   virtual void contentsDragMoveEvent (QDragMoveEvent*);
//   virtual void contentsDropEvent (QDropEvent*);
//   virtual void contentsMouseMoveEvent (QMouseEvent*);
//   virtual void contentsMousePressEvent (QMouseEvent*);
//   virtual void contentsMouseReleaseEvent (QMouseEvent*);
  virtual QDragObject* dragObject ();
  virtual void startDrag ();
  virtual bool acceptDrag (QDropEvent*) const;
//   virtual void drawDropVisualizer (QPainter* p, QListViewItem* parent, QListViewItem* after);



protected slots:
//   void showItemContextMenu (QListViewItem*, const QPoint&, int);
//   void showContextMenu (QListViewItem*, const QPoint&, int);
  virtual void clearInsertMarker ();

private slots:
  void settingsChanged (int category);

private:
  bool mDragging;
  QPoint mOldPos;
  QRect mOldInsertMarker;
  QPopupMenu* mContextMenu;
  bool mDisplayToolTips;
  bool mCommonToolTips;
  QString mToolTip;
  QString mVerticalTip;
  QString mHorizontalTip;
  QDragObject::DragMode mDragMode;
  
  int mMarkerWidth;
  int mMenuIndex;
  int mDNDDelay;
  bool mDisplayMenuOnPress;
};

#endif // KNDRAGLIST_H
