#ifndef RUNLEVEL_AUTH_ICON_H
#define RUNLEVEL_AUTH_ICON_H

// (c) 2000 Peter Putzer <putzer@kde.org>
#pragma interface

#include <kauthicon.h>
#include "Constants.h"

class QTimer;
class QFileInfo;

class RunlevelAuthIcon : public KAuthIcon
{
  Q_OBJECT
  Q_PROPERTY (int refreshInterval READ refreshInterval WRITE setRefreshInterval)

public:
  RunlevelAuthIcon (const QString& scriptPath, const QString& runlevelPath,
					QWidget* parent = 0L, const char* name = 0L);

  virtual ~RunlevelAuthIcon ();

  virtual bool status () const;

  inline int refreshInterval () const { return mInterval; }

public slots:
  virtual void updateStatus ();

  void setScriptPath (const QString& scriptPath);
  void setRunlevelPath (const QString& runlevelPath);

  void setRefreshInterval (int);

private slots:
  void timerEvent ();

private:
  QTimer* mTimer;
  QFileInfo* mScriptInfo;
  QFileInfo* mRLInfo [RUNLEVEL_NR];
  bool mOld;
  int mInterval;
};

#endif // RUNLEVEL_AUTH_ICON_H
