// (c) 2000 Peter Putzer

#ifndef PREFERENCES_DIALOG_H
#define PREFERENCES_DIALOG_H

#pragma interface

#include <kdialogbase.h>
#include <qcolor.h>
#include <qstring.h>

class KDualColorButton;
class KLineEdit;
class KSVConfig;
class QPushButton;

class KSVPreferences : public KDialogBase
{
  Q_OBJECT

public:
  static KSVPreferences* self ();
  virtual ~KSVPreferences ();

  QColor newNormal () const;
  QColor newSelected () const;
  QColor changedNormal () const;
  QColor changedSelected () const;

  QString runlevelPath () const;
  QString scriptPath () const;

  inline bool aColorChanged () const { return mColorsChanged; }

protected slots:
  virtual void slotApply ();
  virtual void slotCancel ();
  virtual void slotOk ();

private slots:
  void scriptDir();
  void runlevelDir();
  void colorChanged();
  void reReadConfig();

private:
  KSVPreferences (QWidget* parent);
  void setConfig ();

  KSVConfig* mConfig;

  KDualColorButton* mNewColors;
  KDualColorButton* mChangedColors;

  KLineEdit* mScriptPath;
  KLineEdit* mRunlevelsPath;

  QPushButton* mBrowseScripts;
  QPushButton* mBrowseRunlevels;

  bool mColorsChanged;
};


#endif // PREFERENCES_DIALOG_H
