//////////////////////////////////////////////////////////////         
//      $Id: kplview.h,v 1.4 2000/05/02 15:01:38 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef KPLVITEM_H
#define KPLVITEM_H

#include "../config.h"
// Standard Headers

// Qt Headers
#include <qframe.h>
#include <qpushbt.h>
#include <qlist.h>
#include <qstring.h>
#include <qlayout.h>

// KDE headers
#include "klistview.h"

// ksetup headers
#include "packageInfo.h"

////////////////////////////////////////////////////////////////////////
class KPLVItem : public QListViewItem
{
public:
KPLVItem( QListViewItem *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  const char * label1 = 0, const char * label2  = 0,
                  const char * label3  = 0, const char * label4  = 0,
                  const char * label5  = 0, const char * label6  = 0,
                  const char * label7  = 0, const char * label8 = 0);
 
 
KPLVItem( KListView *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  const char * label1 = 0, const char * label2  = 0,
                  const char * label3  = 0, const char * label4  = 0,
                  const char * label5  = 0, const char * label6  = 0,
                  const char * label7  = 0, const char * label8 = 0);
 

KPLVItem *firstChild();
KPLVItem *nextSibling();

void toggleMark();
void setMark(bool mark);
// flag for install/uninstall

void hide();
void show();

packageInfo *info;
bool marked;
};

////////////////////////////////////////////////////////////////////////
class KPQListView: public KListView
{
public:
KPQListView ( QWidget * parent = 0, const char * name = 0 );

void contentsMousePressEvent ( QMouseEvent * e );

bool inMark(int x);

KPLVItem *firstChild();
KPLVItem *currentItem();
void clear();

KPLVItem *markPkg;
};

#endif
