/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _WEBSEARCH_H_
#define _WEBSEARCH_H_


#include "searchjob.h"
#include "site.h"


class WebSite : public Site {

public:
  WebSite() : Site() {}

  QString relevanceStart;
  QString relevanceEnd;
};


class WebSiteManager : public SiteManager {

public:
  WebSiteManager();

protected:

  virtual Site *newSite() {
    return new WebSite();
  }

  virtual void readInterpret(Site *site, SiteConfig *config);
};


class WebSearch : public SearchJob {

  Q_OBJECT

public:
  WebSearch(WebSite *site) : SearchJob(site) {}

signals:
  void foundItem(QString icon, QString name, QString url,
		 int relevance, QString details);

protected:
  virtual void parseItem(QString item);

  WebSite *site() { return static_cast<WebSite*>(m_site); }

};

#endif 
