/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <stdlib.h>

#include <qregexp.h>

#include <kstddirs.h>

#include "misc.h"
#include "websearch.h"


WebSiteManager::WebSiteManager() {
  KGlobal::dirs()->addResourceType("www-sites", KStandardDirs::kde_default("data") + "libsearch/www-sites/");
  QStringList list = KGlobal::dirs()->findDirs("www-sites", "");
  
  for (QStringList::ConstIterator it = list.begin(); it != list.end(); it++) {
    readSites( *it );
  }
}


void WebSiteManager::readInterpret(Site *site, SiteConfig *config) {
  WebSite *cwsite = static_cast<WebSite*>(site);
  cwsite->relevanceStart = config->readEntry("relevanceStart");
  cwsite->relevanceEnd = config->readEntry("relevanceEnd");
}


void WebSearch::parseItem(QString item) {
  int pos1, pos2, pos3;
  QString url, name, relevstr;
  int relevance;

#if 0
  qDebug( "-----------------------------------------------------------" );
  qDebug( "Parsing Item: " + item + "|" );
  qDebug( "-----------------------------------------------------------" );
#endif
    
  // This parser sucks.
  pos1 = item.find(QRegExp("<a href=", false));
  if (pos1 == -1)
    return;
    
  pos2 = item.find(">", pos1+8);
  if (pos2 == -1)
    return;
    
  pos3 = item.find(QRegExp("</a>", false), pos2+1);
  if (pos3 == -1)
    return;

  url = item.mid(pos1+8, pos2-(pos1+8)).stripWhiteSpace();

  if (url.left(1) == "\"") {
    url.remove(0, 1);
  }
  if (url.right(1) == "\"") {
    url.remove(url.length()-1, 1);
  }

  qDebug( "Url: " + url );
    
  name = removeHTML(item.mid(pos2+1, pos3-(pos2+1)));
  if ( (pos3 = name.find('\n')) != -1) {
    name.truncate(pos3);
  }

  qDebug( "Name: " + name );

  relevance = -1;
  if (!site()->relevanceStart.isEmpty() &&
      !site()->relevanceEnd.isEmpty()) {
    pos1 = item.find(site()->relevanceStart);
    if (pos1 != -1) {
      pos2 = item.find(site()->relevanceEnd, pos1+1);
      if (pos2 != -1) {
	relevstr = item.mid(pos1+site()->relevanceStart.length(),
			    pos2-(pos1+site()->relevanceStart.length()));
	pos3 = relevstr.find(QRegExp("[0-9]"));
	if (pos3 != -1) {
	  relevstr.remove(0, pos3);
	  relevance = atoi(relevstr);

	  if (relevance > 100) {
	    relevance = -1;
	  }
	}
      }
    }
  }

  qDebug( "Relevance: %d", relevance );
  emit foundItem(m_site->icon, name, url, relevance, item);
}
