/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */

#include <qdir.h>
#include <qstringlist.h>

#include <kapp.h>

#include "misc.h"
#include "site.h"


QString SiteConfig::readEntry(const char *key) {
  QString res = KSimpleConfig::readEntry(key);
  int l = res.length();

  if (l > 2 & res[0] == '"' && res[l-1] == '"') {
    res = res.mid(1, l-2);
  }

  return res;
}


QString Site::makeQueryUrl(QString query) {
  QString url = action;
  url += "?";
  QListIterator<InputTag> it(inputs);

  for (; it.current(); ++it) {
    url += it.current()->name;
    url += "=";

    if (it.current()->user) {
      url += encodeString(query);
    } else {
      url += it.current()->value;
    }

    if (!it.atLast()) {
      url += "&";
    }
  }
  return url;
}


void SiteManager::readSites(QString dirname) {
  QDir dir(dirname);
  dir.setFilter( QDir::Files );

  QStringList strlist = dir.entryList();
  QStringList::Iterator it;

  for ( it = strlist.begin(); it != strlist.end(); ++it ) {
    QString filename = QString(dir.path()) + "/" + *it;
    qDebug( "Reading " + filename );
	
    QString name;
    Site *site = newSite();
	
    SiteConfig config(filename);
    config.setGroup("General");
    name = config.readEntry("Name");
    qDebug( "Name " + name );
    site->description = config.readEntry("Description");
    qDebug( "Description " + site->description );
    site->action = config.readEntry("Action");
    qDebug( "action " + site->action );
    site->icon = config.readEntry("Icon");
    qDebug( "Icon " + site->icon );
    config.setGroup("Input");
    int n = config.readUnsignedNumEntry("NumberOfInputs");
    qDebug( "NumberOfInputs %d", n );

    for (int i = 0; i < n; ++i) {
      InputTag *tag = new InputTag();
      QString s;
      s.setNum(i);
      s.prepend("InputName");
      tag->name = config.readEntry(s);
      qDebug( s + "(name) is " + tag->name );
      s.setNum(i);
      s.prepend("InputValue");
      tag->value = config.readEntry(s);
      qDebug( s + "(value) is " + tag->value );
      s.setNum(i);
      s.prepend("InputUser");
      tag->user = config.readBoolEntry(s);
      qDebug( s + "(user) is %b", tag->user );
      site->inputs.append(tag);
    }

    config.setGroup("Interpret");
    site->resultListStart = config.readEntry("resultListStart");
    site->resultItemStart = config.readEntry("resultItemStart");
    site->resultListEnd = config.readEntry("resultListEnd");
    site->resultItemEnd = config.readEntry("resultItemEnd");
    qDebug( "resultListStart --" + site->resultListStart +" ---" );
    qDebug( "resultListEnd --" + site->resultListEnd +" ---" );
    qDebug( "resultItemStart --" + site->resultItemStart +" ---" );
    qDebug( "resultItemEnd --" + site->resultItemEnd +" ---" );
    readInterpret(site, &config);
    map.insert(name, site);
  }
}


Site *SiteManager::find(QString name) {
  return map[name];
}


Site *SiteManager::newSite() {
  return new Site();
}


void SiteManager::readInterpret(Site *, SiteConfig *) {
}
