//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1998 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <qdir.h>

#include <kapp.h>
#include <kglobal.h>
#include <kstddirs.h>
#include "new_globals.h"
#include "new_groupdlg.h"

KApplication *app;
Groupdlg  *main_widget;

int main( int argc, char **argv )
{

    KApplication a( argc, argv, "krn" );

    app=&a;
    conf=a.config();

    // Create our directory. If it exists, no problem
    // Should do some checking, though

    KStandardDirs *dirs = KGlobal::dirs();

    (void) dirs->getSaveLocation("data", "krn/folders", true );
    (void) dirs->getSaveLocation("data", "krn/cache", true );
    (void) dirs->getSaveLocation("data", "krn/groupinfo", true );
    (void) dirs->getSaveLocation("data", "krn/outgoing", true );
    
    Groupdlg *k=new Groupdlg();
    main_widget = k;

    //insert this: (said Matthias)
    if (a.isRestored())
        k->restore(1);

    a.setMainWidget( k );
    
    k->setMinimumSize( 250, 250 );
    k->show();

    a.exec();

    k->close();
}
