/*
 * $Id: klistmanagertest.cpp,v 1.3 2000/01/14 15:57:49 waba Exp $
 *
 * $Log: klistmanagertest.cpp,v $
 * Revision 1.3  2000/01/14 15:57:49  waba
 * WABA: Use KCmdLineArgs
 *
 * Revision 1.2  1999/06/25 21:29:24  leconte
 * . no space arround the widget
 * . created Features: ShortLabels, UpDownButtons
 * . setStringList can take a pointer to the QStringList
 * . command line arguments for klistmanagertest
 *
 * Revision 1.1  1999/06/18 21:30:50  leconte
 * . myListManager widget: it's a QStringList manager (inspired by
 *   kdebase/kcontrol/kwn/advanced.{cpp,h}) and test program
 *
 */

#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "mylistmanager.h"
#include "klistmanagertest.h"


static const char *description = 
	I18N_NOOP("A Test program for myListManager.");

static const char *version = "v0.0.1";

static KCmdLineOptions option [] =
{
   { "groupbox", I18N_NOOP("Put a QGroupBox arround the widget"), 0 },
   { "short",    I18N_NOOP("Display +/- isntead of add/remove"), 0 },
   { "updown",   I18N_NOOP("Display and manage up and down buttons"), 0 },
   { 0, 0, 0 }
};

KApplication *a;

myListManager::Features features = myListManager::NoFeature;

TopLevel::TopLevel(QWidget *parent, const char *name, bool optGroupbox)
  : QWidget(parent, name)
{
  setCaption("myListManager test application");

  QFrame *frame = new QFrame(this);
  frame->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    
  if (optGroupbox) {
    listManager = new myListManager("title", frame, "lm", features);
  } else {
    listManager = new myListManager(frame, "lm", features);
  }

  QPushButton *bt = new QPushButton("Click here to quit", this, "qb");

  connect(bt, SIGNAL(clicked()), this, SLOT(okPressed()));
  bt->adjustSize();
  bt->setFixedSize(bt->size());

  QBoxLayout *layIn = new QVBoxLayout(frame, 1, 0, "layIn");
  layIn->addWidget(listManager);
  layIn->activate();

  QBoxLayout *lay = new QVBoxLayout(this, 10, 5, "klmtest");
  lay->addWidget(frame, 10);
  lay->addWidget(bt);
  lay->activate();


  // Populate listmanager
  QStringList sl;
  sl << "bijou" << "caillou" << "chou" << "hibou" << "genou" << "pou";
  listManager->setStringList(sl);
}


void 
TopLevel::okPressed()
{
  QStringList sl;
  printf("QStringList = (");
  sl = listManager->stringList();
  for (QStringList::Iterator it = sl.begin();
       it != sl.end(); ++it) {
    printf("\"%s\", ", (const char *)*it);
  }
  printf("\b\b) \n");
  a->quit();
}


int 
main(int argc, char *argv[])
{
  KCmdLineArgs::init(argc, argv, "klistmanagertest", description, version);

  KCmdLineArgs::addCmdLineOptions( option );

  a = new KApplication;
  int i = argc-1;
  bool optGroupbox = false;

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  optGroupbox = args->isSet("groupbox");

  features = myListManager::NoFeature;
  if (args->isSet("updown"))
    features |= myListManager::UpDownButtons;

  if (args->isSet("short"))
    features |= myListManager::ShortLabels;

  TopLevel *toplevel = new TopLevel(0, "toplevel", optGroupbox);
  
  toplevel->show();
  a->setMainWidget(toplevel);
  a->exec();
}

#include "klistmanagertest.moc"

