/*
 * notify.cpp
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the implementation of the KBiffNotify
 * widget
 *
 * $Id: notify.cpp,v 1.17 2000/04/23 15:41:16 jansen Exp $
 */
#include "notify.h"

#include "Trace.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <klocale.h>
#include <kglobal.h>
#include <kwm.h>
#include <kprocess.h>
#include <kiconloader.h>

KBiffNotify::KBiffNotify(const int num_new, const QString& mailbx)
	: QDialog(0, 0, false, 0)
{
TRACEINIT("KBiffNotify::KBiffNotify()");
	// we do *not* want this window to have focus when it pops up
	KWM::setDecoration(winId(), KWM::normalDecoration | KWM::noFocus);

	setIcon(kapp->miniIcon());
	setCaption(i18n("You have new mail!"));

	QLabel *pixmap = new QLabel(this);
	pixmap->setPixmap(kapp->icon());
	pixmap->setFixedSize(pixmap->sizeHint());

	QLabel *congrats = new QLabel(i18n("You have new mail!"), this);
	QFont the_font(congrats->font());
	the_font.setBold(true);
	congrats->setFont(the_font);

	QString msg;
	msg = i18n("New Messages: %1").arg(num_new);
	msgLabel = new QLabel(msg, this);

	msg = i18n("Mailbox: %1").arg(mailbx);
	QLabel *which_one = new QLabel(msg, this);

	QPushButton *ok = new QPushButton(i18n("OK"), this);
	ok->setDefault(true);

	QPushButton *launch = new QPushButton(i18n("Mailer"), this);

	// connect the signals to slots
	connect(ok, SIGNAL(clicked()), SLOT(accept()));
	connect(launch, SIGNAL(clicked()), SLOT(launchMailClient()));
	connect(launch, SIGNAL(clicked()), SLOT(accept()));

	// Now do the layout
	QVBoxLayout *info_layout = new QVBoxLayout(12);
	info_layout->addWidget(congrats);
	info_layout->addWidget(msgLabel);
	info_layout->addWidget(which_one);

	QHBoxLayout *upper_layout = new QHBoxLayout;
	upper_layout->addWidget(pixmap);
	upper_layout->addLayout(info_layout, 1);

	QHBoxLayout *button_layout = new QHBoxLayout;
	button_layout->addStretch(1);
	button_layout->addWidget(launch);
	button_layout->addWidget(ok);
	button_layout->addStretch(1);

	QVBoxLayout *top_layout = new QVBoxLayout(this, 12);
	top_layout->addLayout(upper_layout);
	top_layout->addLayout(button_layout);

	mailbox = mailbx;
	messages = num_new;
}

KBiffNotify::~KBiffNotify()
{
}

void KBiffNotify::setNew(const int num_new)
{
	QString msg;
	msg = i18n("New Messages: %1").arg(num_new);
	msgLabel->setText(msg);
	messages = num_new;
}

void KBiffNotify::slotLaunchMailClient()
{
TRACEINIT("KBiffNotify::slotLaunchMailClient()");
	emit(signalLaunchMailClient());
}
