/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _CRITERIA_H_
#define _CRITERIA_H_


#include <qwidget.h>
#include <qdatetime.h>


class QComboBox;
class QCheckBox;
class QLabel;
class QLineEdit;
class QBoxLayout;

class KDatePicker;


class CriterionSpecial : public QObject
{
    Q_OBJECT
    
public:

    virtual ~CriterionSpecial() {}

    virtual int type() = 0;
    virtual void addToLayout(QBoxLayout *lay) = 0;
    virtual QString findString() = 0;

signals:
    void wantLayout();
};


class CriterionName : public CriterionSpecial
{
public:
    CriterionName(QWidget *parent);
    virtual ~CriterionName();
    
    virtual int type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private:
    QComboBox *combo;
    QLineEdit *line;
};


class CriterionTime : public CriterionSpecial
{
    Q_OBJECT
    
public:
    CriterionTime(QWidget *parent);
    virtual ~CriterionTime();
    
    virtual int type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private slots:
    void datePicked(QDate);

private:
    QComboBox *combo;
    KDatePicker *picker;
    QDate date;
};


class CriterionSize : public CriterionSpecial
{
public:
    CriterionSize(QWidget *parent);
    virtual ~CriterionSize();
    
    virtual int type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private:
    QComboBox *combo;
    QLineEdit *line;
};


class CriterionType : public CriterionSpecial
{
public:
    CriterionType(QWidget *parent);
    virtual ~CriterionType();
    
    virtual int type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private:
    QComboBox *combo;
    //    QLineEdit *line;
};


class CriterionOwner : public CriterionSpecial
{
public:
    CriterionOwner(QWidget *parent);
    virtual ~CriterionOwner();
    
    virtual int type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private:
    QComboBox *combo;
    QLineEdit *line;
};


class CriterionGroup : public CriterionSpecial
{
public:
    CriterionGroup(QWidget *parent);
    virtual ~CriterionGroup();
    
    virtual int type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private:
    QComboBox *combo;
    QLineEdit *line;
};


class Criterion : public QWidget
{
    Q_OBJECT
    
public:
    enum FindType{ Name, Time, Size, Type, Owner, Group };

    Criterion( QWidget *parent=0, const char *name=0 );
    QString findString();

protected slots:
    void typeActivated(int);
    void layout();

private:
    QBoxLayout *lay;
    QComboBox *typecombo;
    CriterionSpecial *spec;
};

#endif
