/* $Id: docking.cpp,v 1.12 1999/11/21 10:30:41 koss Exp $
   $Log: docking.cpp,v $
   Revision 1.12  1999/11/21 10:30:41  koss
   XPM -> PNG
   In offline mode we now draw offline icon, too.

   Revision 1.11  1999/11/18 21:31:38  koss
   Renamed slotPreferences(0 to slotTogglePreferences(0.

   Revision 1.4  1999/05/16 16:57:20  koss
   Reworked docking policy again.
   Now we have two modes : Dock widget, Drop target or Normal window
   Another options is Windows 9x style - toggle this to have Windows 9x
   docking behaviour, this applies also to drop target

   Revision 1.3  1999/02/19 15:41:32  koss
   Reenbled pasting with middle button in the dock widget ( now it also
   beeps for notification )

   Revision 1.1  1998/03/02 14:28:43  matt
   Added animation


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#include <qpainter.h>

#include <kapp.h>
#include <kstddirs.h>
#include <klocale.h>

#include "kmainwidget.h"
#include "settings.h"
#include "docking.h"

#define ICONWIDTH 24
#define ICONHEIGHT 24


DockWidget::DockWidget( KMainWidget *_parent )
  : KDockWindow( _parent ) {

  parent = _parent;

  QString path = "caitoo/pics/";

  QPixmap *tmppix = new QPixmap();
  tmppix->load( locate( "data", path + "dock_hand1.png") );

  handpix1 = new QPixmap( ICONWIDTH, ICONHEIGHT );
  handpix1->fill(backgroundColor());
  bitBlt( handpix1, 0, 0, tmppix );

  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( locate( "data", path + "dock_hand2.png") );

  handpix2 = new QPixmap( ICONWIDTH, ICONHEIGHT );
  handpix2->fill(backgroundColor());
  bitBlt( handpix2, 0, 0, tmppix );

  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( locate( "data", path + "dock_hand3.png") );

  handpix3 = new QPixmap( ICONWIDTH, ICONHEIGHT );
  handpix3->fill(backgroundColor());
  bitBlt( handpix3, 0, 0, tmppix );

  delete tmppix;

  setPixmap( *handpix1 );

  for ( int i = 0; i < 3; i++ ) {
    size[i] = 0;
  }

  // popup menu for right mouse button
  KPopupMenu *popupMenu = contextMenu();
  popupMenu->insertItem(i18n("Preferences"), parent, SLOT( slotTogglePreferences() ) );

  // Enable dropping
  setAcceptDrops( true );
}


DockWidget::~DockWidget() {
  delete handpix1;
  delete handpix2;
  delete handpix3;
}


void DockWidget::setAnim( int i1, int i2, int i3, bool online ) {

  size[0] = i1;
  size[1] = i2;
  size[2] = i3;

  if ( isVisible() ) {
    if ( !online || ksettings.b_offlineMode ) {
      setPixmap( *handpix3 );
    } else if ( size[0] == 0 && size[1] == 0 && size[2] == 0 ) {
      setPixmap( *handpix1 );
    } else {
      QPixmap pm( *handpix2 );
      QPainter p;
      p.begin( &pm );

      p.setPen( white );
      for ( int i = 0; i < 3; i++ ) {
	if ( size[i] != 0 ) {
	  int pixels = (int)( ICONWIDTH * (float)size[i] / 100.0 );
	  p.fillRect( 1, i*8, pixels, 7, blue );
	}
      }

      p.end();
      setPixmap( pm );
    }
  }
}


void DockWidget::dragEnterEvent(QDragEnterEvent* event) {
  event->accept( QUriDrag::canDecode(event) || QTextDrag::canDecode(event) );
}


void DockWidget::dropEvent( QDropEvent* event ) {
  QStrList list;
  QString str;

  if ( QUriDrag::decode(event, list) ) {
    parent->addDropTransfers( &list );
  } else if ( QTextDrag::decode(event, str) ) {
    parent->addTransfer( str );
  }
}


void DockWidget::mousePressEvent(QMouseEvent *e) {
  if ( e->button() == MidButton ) {
    parent->slotPasteTransfer();
  } else {
    KDockWindow::mousePressEvent( e );
  }
}
