/* $Id: dlgAutomation.h,v 1.11 1999/11/18 21:28:04 koss Exp $
   $Log: dlgAutomation.h,v $
   Revision 1.11  1999/11/18 21:28:04  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.10  1999/11/15 20:14:09  koss
   Search entries moved to dlgSearch.
   Fixed layout again.
   Now we use units in KNumInput and not in separate QLabels.

   Revision 1.9  1999/11/09 18:24:35  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.8  1999/10/18 21:49:53  koss
   switched from QStrList to QStringList.
   fixed layout.
   removed getIntFromString() and getStringFromInt().
   getBoolFromString() renamed to stringToBool().
   getStringFromBool() renamed to boolToString().

   Revision 1.7  1999/08/01 15:41:12  corey
   move to KIntNumInput.

   Revision 1.6  1999/05/30 22:19:35  dmuell
   kintlineedit.h -> knumlineedit.h

   Revision 1.5  1999/05/16 16:58:44  koss
   Added timed-disconnect options

   Revision 1.4  1999/05/08 18:17:07  porten
   KIntegerLine -> KIntLineEdit

   Revision 1.3  1999/04/17 10:06:50  koss
   had to include qstrlist.h

   Revision 1.2  1999/04/08 17:13:02  koss
   reworked layouts

   Revision 1.1.1.1  1999/04/04 13:02:46  koss
   Renamed kget to caitoo

   Revision 1.3  1999/03/21 12:11:35  koss
   Fixed layout for Qt 2.0

   Revision 1.2  1999/03/20 10:40:13  koss
   Merged with my harddisk, from now on I work on the HEAD branch kget.

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGAUTOMATION_H
#define _DLGAUTOMATION_H

#include <qgroupbox.h> 
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qstringlist.h>

#include <knuminput.h>

#include "bwdatetime.h"

class DlgAutomation : public QGroupBox {

  Q_OBJECT

public:

  DlgAutomation( QWidget *parent );
  ~DlgAutomation() {}

  void applyData();
  void setData();
     
private:

  // auto save settings
  QCheckBox *cb_autoSave;
  KIntNumInput *le_autoSave;

  // auto disconnect settings
  QCheckBox *cb_autoDisconnect;
  QLabel    *lb_autoDisconnect;
  QLineEdit *le_autoDisconnect;
  QCheckBox *cb_timedDisconnect;
  BWDateTime *spins;

  QDateTime disconnectDateTime;

  // auto shutdown settings
  QCheckBox *cb_autoShutdown;
  
  // auto paste settings
  QCheckBox *cb_autoPaste;

public slots:
  void slotTypeChanged( int );

protected slots:
  void disconnectToggled( bool );

};

#endif // _DLGAUTOMATION_H
