/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#include "core.h"

// Implementation
Header::Header()
{
}

Header::Header(HeaderMagic magic, long messageLength, MessageType messageType)
{
	this->magic = magic;
	this->messageLength = messageLength;
	this->messageType = messageType;
}

Header::Header(Buffer& stream)
{
	readType(stream);
}

Header::Header(const Header& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Header& Header::operator=(const Header& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

Header::~Header()
{
}

void Header::readType(Buffer& stream)
{
	magic = (HeaderMagic)stream.readLong();
	messageLength = stream.readLong();
	messageType = (MessageType)stream.readLong();
}

void Header::writeType(Buffer& stream) const
{
	stream.writeLong(magic);
	stream.writeLong(messageLength);
	stream.writeLong(messageType);
}

Invocation::Invocation()
{
}

Invocation::Invocation(long requestID, long objectID, long methodID)
{
	this->requestID = requestID;
	this->objectID = objectID;
	this->methodID = methodID;
}

Invocation::Invocation(Buffer& stream)
{
	readType(stream);
}

Invocation::Invocation(const Invocation& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

Invocation& Invocation::operator=(const Invocation& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

Invocation::~Invocation()
{
}

void Invocation::readType(Buffer& stream)
{
	requestID = stream.readLong();
	objectID = stream.readLong();
	methodID = stream.readLong();
}

void Invocation::writeType(Buffer& stream) const
{
	stream.writeLong(requestID);
	stream.writeLong(objectID);
	stream.writeLong(methodID);
}

OnewayInvocation::OnewayInvocation()
{
}

OnewayInvocation::OnewayInvocation(long objectID, long methodID)
{
	this->objectID = objectID;
	this->methodID = methodID;
}

OnewayInvocation::OnewayInvocation(Buffer& stream)
{
	readType(stream);
}

OnewayInvocation::OnewayInvocation(const OnewayInvocation& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

OnewayInvocation& OnewayInvocation::operator=(const OnewayInvocation& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

OnewayInvocation::~OnewayInvocation()
{
}

void OnewayInvocation::readType(Buffer& stream)
{
	objectID = stream.readLong();
	methodID = stream.readLong();
}

void OnewayInvocation::writeType(Buffer& stream) const
{
	stream.writeLong(objectID);
	stream.writeLong(methodID);
}

ServerHello::ServerHello()
{
}

ServerHello::ServerHello(const std::string& serverID, const std::vector<std::string>& authProtocols, const std::string& authSeed)
{
	this->serverID = serverID;
	this->authProtocols = authProtocols;
	this->authSeed = authSeed;
}

ServerHello::ServerHello(Buffer& stream)
{
	readType(stream);
}

ServerHello::ServerHello(const ServerHello& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

ServerHello& ServerHello::operator=(const ServerHello& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

ServerHello::~ServerHello()
{
}

void ServerHello::readType(Buffer& stream)
{
	stream.readString(serverID);
	stream.readStringSeq(authProtocols);
	stream.readString(authSeed);
}

void ServerHello::writeType(Buffer& stream) const
{
	stream.writeString(serverID);
	stream.writeStringSeq(authProtocols);
	stream.writeString(authSeed);
}

ClientHello::ClientHello()
{
}

ClientHello::ClientHello(const std::string& serverID, const std::string& authProtocol, const std::string& authData)
{
	this->serverID = serverID;
	this->authProtocol = authProtocol;
	this->authData = authData;
}

ClientHello::ClientHello(Buffer& stream)
{
	readType(stream);
}

ClientHello::ClientHello(const ClientHello& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

ClientHello& ClientHello::operator=(const ClientHello& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

ClientHello::~ClientHello()
{
}

void ClientHello::readType(Buffer& stream)
{
	stream.readString(serverID);
	stream.readString(authProtocol);
	stream.readString(authData);
}

void ClientHello::writeType(Buffer& stream) const
{
	stream.writeString(serverID);
	stream.writeString(authProtocol);
	stream.writeString(authData);
}

ObjectReference::ObjectReference()
{
}

ObjectReference::ObjectReference(const std::string& serverID, long objectID, const std::vector<std::string>& urls)
{
	this->serverID = serverID;
	this->objectID = objectID;
	this->urls = urls;
}

ObjectReference::ObjectReference(Buffer& stream)
{
	readType(stream);
}

ObjectReference::ObjectReference(const ObjectReference& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

ObjectReference& ObjectReference::operator=(const ObjectReference& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

ObjectReference::~ObjectReference()
{
}

void ObjectReference::readType(Buffer& stream)
{
	stream.readString(serverID);
	objectID = stream.readLong();
	stream.readStringSeq(urls);
}

void ObjectReference::writeType(Buffer& stream) const
{
	stream.writeString(serverID);
	stream.writeLong(objectID);
	stream.writeStringSeq(urls);
}

ParamDef::ParamDef()
{
}

ParamDef::ParamDef(const std::string& type, const std::string& name)
{
	this->type = type;
	this->name = name;
}

ParamDef::ParamDef(Buffer& stream)
{
	readType(stream);
}

ParamDef::ParamDef(const ParamDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

ParamDef& ParamDef::operator=(const ParamDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

ParamDef::~ParamDef()
{
}

void ParamDef::readType(Buffer& stream)
{
	stream.readString(type);
	stream.readString(name);
}

void ParamDef::writeType(Buffer& stream) const
{
	stream.writeString(type);
	stream.writeString(name);
}

MethodDef::MethodDef()
{
}

MethodDef::MethodDef(const std::string& name, const std::string& type, MethodType flags, const std::vector<ParamDef *>& signature)
{
	this->name = name;
	this->type = type;
	this->flags = flags;
	this->signature = signature;
}

MethodDef::MethodDef(Buffer& stream)
{
	readType(stream);
}

MethodDef::MethodDef(const MethodDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

MethodDef& MethodDef::operator=(const MethodDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

MethodDef::~MethodDef()
{
	freeTypeSeq(signature);
}

void MethodDef::readType(Buffer& stream)
{
	stream.readString(name);
	stream.readString(type);
	flags = (MethodType)stream.readLong();
	readTypeSeq(stream,signature);
}

void MethodDef::writeType(Buffer& stream) const
{
	stream.writeString(name);
	stream.writeString(type);
	stream.writeLong(flags);
	writeTypeSeq(stream,signature);
}

AttributeDef::AttributeDef()
{
}

AttributeDef::AttributeDef(const std::string& name, const std::string& type, AttributeType flags)
{
	this->name = name;
	this->type = type;
	this->flags = flags;
}

AttributeDef::AttributeDef(Buffer& stream)
{
	readType(stream);
}

AttributeDef::AttributeDef(const AttributeDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

AttributeDef& AttributeDef::operator=(const AttributeDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

AttributeDef::~AttributeDef()
{
}

void AttributeDef::readType(Buffer& stream)
{
	stream.readString(name);
	stream.readString(type);
	flags = (AttributeType)stream.readLong();
}

void AttributeDef::writeType(Buffer& stream) const
{
	stream.writeString(name);
	stream.writeString(type);
	stream.writeLong(flags);
}

InterfaceDef::InterfaceDef()
{
}

InterfaceDef::InterfaceDef(const std::string& name, const std::vector<std::string>& inheritedInterfaces, const std::vector<MethodDef *>& methods, const std::vector<AttributeDef *>& attributes, const std::vector<std::string>& defaultPorts)
{
	this->name = name;
	this->inheritedInterfaces = inheritedInterfaces;
	this->methods = methods;
	this->attributes = attributes;
	this->defaultPorts = defaultPorts;
}

InterfaceDef::InterfaceDef(Buffer& stream)
{
	readType(stream);
}

InterfaceDef::InterfaceDef(const InterfaceDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

InterfaceDef& InterfaceDef::operator=(const InterfaceDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

InterfaceDef::~InterfaceDef()
{
	freeTypeSeq(methods);
	freeTypeSeq(attributes);
}

void InterfaceDef::readType(Buffer& stream)
{
	stream.readString(name);
	stream.readStringSeq(inheritedInterfaces);
	readTypeSeq(stream,methods);
	readTypeSeq(stream,attributes);
	stream.readStringSeq(defaultPorts);
}

void InterfaceDef::writeType(Buffer& stream) const
{
	stream.writeString(name);
	stream.writeStringSeq(inheritedInterfaces);
	writeTypeSeq(stream,methods);
	writeTypeSeq(stream,attributes);
	stream.writeStringSeq(defaultPorts);
}

TypeComponent::TypeComponent()
{
}

TypeComponent::TypeComponent(const std::string& type, const std::string& name)
{
	this->type = type;
	this->name = name;
}

TypeComponent::TypeComponent(Buffer& stream)
{
	readType(stream);
}

TypeComponent::TypeComponent(const TypeComponent& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

TypeComponent& TypeComponent::operator=(const TypeComponent& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

TypeComponent::~TypeComponent()
{
}

void TypeComponent::readType(Buffer& stream)
{
	stream.readString(type);
	stream.readString(name);
}

void TypeComponent::writeType(Buffer& stream) const
{
	stream.writeString(type);
	stream.writeString(name);
}

TypeDef::TypeDef()
{
}

TypeDef::TypeDef(const std::string& name, const std::vector<TypeComponent *>& contents)
{
	this->name = name;
	this->contents = contents;
}

TypeDef::TypeDef(Buffer& stream)
{
	readType(stream);
}

TypeDef::TypeDef(const TypeDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

TypeDef& TypeDef::operator=(const TypeDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

TypeDef::~TypeDef()
{
	freeTypeSeq(contents);
}

void TypeDef::readType(Buffer& stream)
{
	stream.readString(name);
	readTypeSeq(stream,contents);
}

void TypeDef::writeType(Buffer& stream) const
{
	stream.writeString(name);
	writeTypeSeq(stream,contents);
}

EnumComponent::EnumComponent()
{
}

EnumComponent::EnumComponent(const std::string& name, long value)
{
	this->name = name;
	this->value = value;
}

EnumComponent::EnumComponent(Buffer& stream)
{
	readType(stream);
}

EnumComponent::EnumComponent(const EnumComponent& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

EnumComponent& EnumComponent::operator=(const EnumComponent& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

EnumComponent::~EnumComponent()
{
}

void EnumComponent::readType(Buffer& stream)
{
	stream.readString(name);
	value = stream.readLong();
}

void EnumComponent::writeType(Buffer& stream) const
{
	stream.writeString(name);
	stream.writeLong(value);
}

EnumDef::EnumDef()
{
}

EnumDef::EnumDef(const std::string& name, const std::vector<EnumComponent *>& contents)
{
	this->name = name;
	this->contents = contents;
}

EnumDef::EnumDef(Buffer& stream)
{
	readType(stream);
}

EnumDef::EnumDef(const EnumDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

EnumDef& EnumDef::operator=(const EnumDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

EnumDef::~EnumDef()
{
	freeTypeSeq(contents);
}

void EnumDef::readType(Buffer& stream)
{
	stream.readString(name);
	readTypeSeq(stream,contents);
}

void EnumDef::writeType(Buffer& stream) const
{
	stream.writeString(name);
	writeTypeSeq(stream,contents);
}

ModuleDef::ModuleDef()
{
}

ModuleDef::ModuleDef(const std::string& moduleName, const std::vector<ModuleDef *>& modules, const std::vector<EnumDef *>& enums, const std::vector<TypeDef *>& types, const std::vector<InterfaceDef *>& interfaces)
{
	this->moduleName = moduleName;
	this->modules = modules;
	this->enums = enums;
	this->types = types;
	this->interfaces = interfaces;
}

ModuleDef::ModuleDef(Buffer& stream)
{
	readType(stream);
}

ModuleDef::ModuleDef(const ModuleDef& copyType) : ::Type(copyType)
{
	Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

ModuleDef& ModuleDef::operator=(const ModuleDef& assignType)
{
	Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

ModuleDef::~ModuleDef()
{
	freeTypeSeq(modules);
	freeTypeSeq(enums);
	freeTypeSeq(types);
	freeTypeSeq(interfaces);
}

void ModuleDef::readType(Buffer& stream)
{
	stream.readString(moduleName);
	readTypeSeq(stream,modules);
	readTypeSeq(stream,enums);
	readTypeSeq(stream,types);
	readTypeSeq(stream,interfaces);
}

void ModuleDef::writeType(Buffer& stream) const
{
	stream.writeString(moduleName);
	writeTypeSeq(stream,modules);
	writeTypeSeq(stream,enums);
	writeTypeSeq(stream,types);
	writeTypeSeq(stream,interfaces);
}

InterfaceRepo_base *InterfaceRepo_base::_create(const std::string& subClass)
{
	Object_skel *skel = ObjectManager::the()->create(subClass);
	assert(skel);
	InterfaceRepo_base *castedObject = (InterfaceRepo_base *)skel->_cast(InterfaceRepo_base::_IID);
	assert(castedObject);
	return castedObject;
}

InterfaceRepo_base *InterfaceRepo_base::_fromString(std::string objectref)
{
	ObjectReference r;

	if(Dispatcher::the()->stringToObjectReference(r,objectref))
		return InterfaceRepo_base::_fromReference(r,true);
	return 0;
}

InterfaceRepo_base *InterfaceRepo_base::_fromReference(ObjectReference r, bool needcopy)
{
	InterfaceRepo_base *result;
	result = (InterfaceRepo_base *)Dispatcher::the()->connectObjectLocal(r,"InterfaceRepo");
	if(!result)
	{
		Connection *conn = Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new InterfaceRepo_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
		}
	}
	return result;
}

vector<std::string> InterfaceRepo_base::_defaultPortsIn() const {
	vector<std::string> ret;
	return ret;
}
vector<std::string> InterfaceRepo_base::_defaultPortsOut() const {
	vector<std::string> ret;
	return ret;
}

void *InterfaceRepo_base::_cast(unsigned long iid)
{
	if(iid == InterfaceRepo_base::_IID) return (InterfaceRepo_base *)this;
	if(iid == Object_base::_IID) return (Object_base *)this;
	return 0;
}

InterfaceRepo_stub::InterfaceRepo_stub()
{
	// constructor for subclasses (don't use directly)
}

InterfaceRepo_stub::InterfaceRepo_stub(Connection *connection, long objectID)
	: Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long InterfaceRepo_stub::insertModule(const ModuleDef& newModule)
{
	long methodID = _lookupMethodFast("method:0d000000696e736572744d6f64756c6500050000006c6f6e670002000000010000000a0000004d6f64756c65446566000a0000006e65774d6f64756c6500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	newModule.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void InterfaceRepo_stub::removeModule(long moduleID)
{
	long methodID = _lookupMethodFast("method:0d00000072656d6f76654d6f64756c650005000000766f6964000200000001000000050000006c6f6e6700090000006d6f64756c65494400");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(moduleID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

InterfaceDef* InterfaceRepo_stub::queryInterface(const std::string& name)
{
	long methodID = _lookupMethodFast("method:0f0000007175657279496e74657266616365000d000000496e7465726661636544656600020000000100000007000000737472696e6700050000006e616d6500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(name);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return new InterfaceDef(); // error occured
	InterfaceDef *_returnCode = new InterfaceDef(*result);
	delete result;
	return _returnCode;
}

TypeDef* InterfaceRepo_stub::queryType(const std::string& name)
{
	long methodID = _lookupMethodFast("method:0a00000071756572795479706500080000005479706544656600020000000100000007000000737472696e6700050000006e616d6500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(name);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return new TypeDef(); // error occured
	TypeDef *_returnCode = new TypeDef(*result);
	delete result;
	return _returnCode;
}

std::string InterfaceRepo_skel::_interfaceName()
{
	return "InterfaceRepo";
}

std::string InterfaceRepo_skel::_interfaceNameSkel()
{
	return "InterfaceRepo";
}

// insertModule
static void _dispatch_InterfaceRepo_00(void *object, Buffer *request, Buffer *result)
{
	ModuleDef newModule(*request);
	result->writeLong(((InterfaceRepo_skel *)object)->insertModule(newModule));
}

// removeModule
static void _dispatch_InterfaceRepo_01(void *object, Buffer *request, Buffer *)
{
	long moduleID = request->readLong();
	((InterfaceRepo_skel *)object)->removeModule(moduleID);
}

// queryInterface
static void _dispatch_InterfaceRepo_02(void *object, Buffer *request, Buffer *result)
{
	std::string name;
	request->readString(name);
	InterfaceDef *_returnCode = ((InterfaceRepo_skel *)object)->queryInterface(name);
	_returnCode->writeType(*result);
	delete _returnCode;
}

// queryType
static void _dispatch_InterfaceRepo_03(void *object, Buffer *request, Buffer *result)
{
	std::string name;
	request->readString(name);
	TypeDef *_returnCode = ((InterfaceRepo_skel *)object)->queryType(name);
	_returnCode->writeType(*result);
	delete _returnCode;
}

void InterfaceRepo_skel::_buildMethodTable()
{
	Buffer m;
	m.fromString(
        "MethodTable:0d000000696e736572744d6f64756c6500050000006c6f6e670002"
        "000000010000000a0000004d6f64756c65446566000a0000006e65774d6f64756c"
        "65000d00000072656d6f76654d6f64756c650005000000766f6964000200000001"
        "000000050000006c6f6e6700090000006d6f64756c654944000f00000071756572"
        "79496e74657266616365000d000000496e74657266616365446566000200000001"
        "00000007000000737472696e6700050000006e616d65000a000000717565727954"
        "79706500080000005479706544656600020000000100000007000000737472696e"
        "6700050000006e616d6500",
		"MethodTable"
	);
	_addMethod(_dispatch_InterfaceRepo_00,this,MethodDef(m));
	_addMethod(_dispatch_InterfaceRepo_01,this,MethodDef(m));
	_addMethod(_dispatch_InterfaceRepo_02,this,MethodDef(m));
	_addMethod(_dispatch_InterfaceRepo_03,this,MethodDef(m));
}

InterfaceRepo_skel::InterfaceRepo_skel()
{
}

Object_base* InterfaceRepo::_Creator() {
	return InterfaceRepo_base::_create();
}

unsigned long InterfaceRepo_base::_IID = MCOPUtils::makeIID("InterfaceRepo");

FlowSystemSender_base *FlowSystemSender_base::_create(const std::string& subClass)
{
	Object_skel *skel = ObjectManager::the()->create(subClass);
	assert(skel);
	FlowSystemSender_base *castedObject = (FlowSystemSender_base *)skel->_cast(FlowSystemSender_base::_IID);
	assert(castedObject);
	return castedObject;
}

FlowSystemSender_base *FlowSystemSender_base::_fromString(std::string objectref)
{
	ObjectReference r;

	if(Dispatcher::the()->stringToObjectReference(r,objectref))
		return FlowSystemSender_base::_fromReference(r,true);
	return 0;
}

FlowSystemSender_base *FlowSystemSender_base::_fromReference(ObjectReference r, bool needcopy)
{
	FlowSystemSender_base *result;
	result = (FlowSystemSender_base *)Dispatcher::the()->connectObjectLocal(r,"FlowSystemSender");
	if(!result)
	{
		Connection *conn = Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new FlowSystemSender_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
		}
	}
	return result;
}

vector<std::string> FlowSystemSender_base::_defaultPortsIn() const {
	vector<std::string> ret;
	return ret;
}
vector<std::string> FlowSystemSender_base::_defaultPortsOut() const {
	vector<std::string> ret;
	return ret;
}

void *FlowSystemSender_base::_cast(unsigned long iid)
{
	if(iid == FlowSystemSender_base::_IID) return (FlowSystemSender_base *)this;
	if(iid == Object_base::_IID) return (Object_base *)this;
	return 0;
}

FlowSystemSender_stub::FlowSystemSender_stub()
{
	// constructor for subclasses (don't use directly)
}

FlowSystemSender_stub::FlowSystemSender_stub(Connection *connection, long objectID)
	: Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void FlowSystemSender_stub::processed()
{
	long methodID = _lookupMethodFast("method:0a00000070726f6365737365640005000000766f6964000100000000000000");
	Buffer *request = Dispatcher::the()->createOnewayRequest(_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

}

std::string FlowSystemSender_skel::_interfaceName()
{
	return "FlowSystemSender";
}

std::string FlowSystemSender_skel::_interfaceNameSkel()
{
	return "FlowSystemSender";
}

// processed
static void _dispatch_FlowSystemSender_00(void *object, Buffer *)
{
	((FlowSystemSender_skel *)object)->processed();
}

void FlowSystemSender_skel::_buildMethodTable()
{
	Buffer m;
	m.fromString(
        "MethodTable:0a00000070726f6365737365640005000000766f69640001000000"
        "00000000",
		"MethodTable"
	);
	_addMethod(_dispatch_FlowSystemSender_00,this,MethodDef(m));
}

FlowSystemSender_skel::FlowSystemSender_skel()
{
}

Object_base* FlowSystemSender::_Creator() {
	return FlowSystemSender_base::_create();
}

unsigned long FlowSystemSender_base::_IID = MCOPUtils::makeIID("FlowSystemSender");

FlowSystemReceiver_base *FlowSystemReceiver_base::_create(const std::string& subClass)
{
	Object_skel *skel = ObjectManager::the()->create(subClass);
	assert(skel);
	FlowSystemReceiver_base *castedObject = (FlowSystemReceiver_base *)skel->_cast(FlowSystemReceiver_base::_IID);
	assert(castedObject);
	return castedObject;
}

FlowSystemReceiver_base *FlowSystemReceiver_base::_fromString(std::string objectref)
{
	ObjectReference r;

	if(Dispatcher::the()->stringToObjectReference(r,objectref))
		return FlowSystemReceiver_base::_fromReference(r,true);
	return 0;
}

FlowSystemReceiver_base *FlowSystemReceiver_base::_fromReference(ObjectReference r, bool needcopy)
{
	FlowSystemReceiver_base *result;
	result = (FlowSystemReceiver_base *)Dispatcher::the()->connectObjectLocal(r,"FlowSystemReceiver");
	if(!result)
	{
		Connection *conn = Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new FlowSystemReceiver_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
		}
	}
	return result;
}

vector<std::string> FlowSystemReceiver_base::_defaultPortsIn() const {
	vector<std::string> ret;
	return ret;
}
vector<std::string> FlowSystemReceiver_base::_defaultPortsOut() const {
	vector<std::string> ret;
	return ret;
}

void *FlowSystemReceiver_base::_cast(unsigned long iid)
{
	if(iid == FlowSystemReceiver_base::_IID) return (FlowSystemReceiver_base *)this;
	if(iid == Object_base::_IID) return (Object_base *)this;
	return 0;
}

FlowSystemReceiver_stub::FlowSystemReceiver_stub()
{
	// constructor for subclasses (don't use directly)
}

FlowSystemReceiver_stub::FlowSystemReceiver_stub(Connection *connection, long objectID)
	: Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long FlowSystemReceiver_stub::receiveHandlerID()
{
	long methodID = _lookupMethodFast("method:160000005f6765745f7265636569766548616e646c6572494400050000006c6f6e67000200000000000000");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

std::string FlowSystemReceiver_skel::_interfaceName()
{
	return "FlowSystemReceiver";
}

std::string FlowSystemReceiver_skel::_interfaceNameSkel()
{
	return "FlowSystemReceiver";
}

// _get_receiveHandlerID
static void _dispatch_FlowSystemReceiver_00(void *object, Buffer *, Buffer *result)
{
	result->writeLong(((FlowSystemReceiver_skel *)object)->receiveHandlerID());
}

void FlowSystemReceiver_skel::_buildMethodTable()
{
	Buffer m;
	m.fromString(
        "MethodTable:160000005f6765745f7265636569766548616e646c657249440005"
        "0000006c6f6e67000200000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_FlowSystemReceiver_00,this,MethodDef(m));
}

FlowSystemReceiver_skel::FlowSystemReceiver_skel()
{
}

Object_base* FlowSystemReceiver::_Creator() {
	return FlowSystemReceiver_base::_create();
}

unsigned long FlowSystemReceiver_base::_IID = MCOPUtils::makeIID("FlowSystemReceiver");

FlowSystem_base *FlowSystem_base::_create(const std::string& subClass)
{
	Object_skel *skel = ObjectManager::the()->create(subClass);
	assert(skel);
	FlowSystem_base *castedObject = (FlowSystem_base *)skel->_cast(FlowSystem_base::_IID);
	assert(castedObject);
	return castedObject;
}

FlowSystem_base *FlowSystem_base::_fromString(std::string objectref)
{
	ObjectReference r;

	if(Dispatcher::the()->stringToObjectReference(r,objectref))
		return FlowSystem_base::_fromReference(r,true);
	return 0;
}

FlowSystem_base *FlowSystem_base::_fromReference(ObjectReference r, bool needcopy)
{
	FlowSystem_base *result;
	result = (FlowSystem_base *)Dispatcher::the()->connectObjectLocal(r,"FlowSystem");
	if(!result)
	{
		Connection *conn = Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new FlowSystem_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
		}
	}
	return result;
}

vector<std::string> FlowSystem_base::_defaultPortsIn() const {
	vector<std::string> ret;
	return ret;
}
vector<std::string> FlowSystem_base::_defaultPortsOut() const {
	vector<std::string> ret;
	return ret;
}

void *FlowSystem_base::_cast(unsigned long iid)
{
	if(iid == FlowSystem_base::_IID) return (FlowSystem_base *)this;
	if(iid == Object_base::_IID) return (Object_base *)this;
	return 0;
}

FlowSystem_stub::FlowSystem_stub()
{
	// constructor for subclasses (don't use directly)
}

FlowSystem_stub::FlowSystem_stub(Connection *connection, long objectID)
	: Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void FlowSystem_stub::startObject(Object node)
{
	long methodID = _lookupMethodFast("method:0c00000073746172744f626a6563740005000000766f6964000200000001000000070000006f626a65637400050000006e6f646500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	writeObject(*request,node._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void FlowSystem_stub::stopObject(Object node)
{
	long methodID = _lookupMethodFast("method:0b00000073746f704f626a6563740005000000766f6964000200000001000000070000006f626a65637400050000006e6f646500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	writeObject(*request,node._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void FlowSystem_stub::connectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort)
{
	long methodID = _lookupMethodFast("method:0e000000636f6e6e6563744f626a6563740005000000766f6964000200000004000000070000006f626a656374000d000000736f757263654f626a6563740007000000737472696e67000b000000736f75726365506f727400070000006f626a656374000b000000646573744f626a6563740007000000737472696e67000900000064657374506f727400");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	writeObject(*request,sourceObject._base());
	request->writeString(sourcePort);
	writeObject(*request,destObject._base());
	request->writeString(destPort);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void FlowSystem_stub::disconnectObject(Object sourceObject, const std::string& sourcePort, Object destObject, const std::string& destPort)
{
	long methodID = _lookupMethodFast("method:11000000646973636f6e6e6563744f626a6563740005000000766f6964000200000004000000070000006f626a656374000d000000736f757263654f626a6563740007000000737472696e67000b000000736f75726365506f727400070000006f626a656374000b000000646573744f626a6563740007000000737472696e67000900000064657374506f727400");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	writeObject(*request,sourceObject._base());
	request->writeString(sourcePort);
	writeObject(*request,destObject._base());
	request->writeString(destPort);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

AttributeType FlowSystem_stub::queryFlags(Object node, const std::string& port)
{
	long methodID = _lookupMethodFast("method:0b0000007175657279466c616773000e00000041747472696275746554797065000200000002000000070000006f626a65637400050000006e6f64650007000000737472696e670005000000706f727400");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	writeObject(*request,node._base());
	request->writeString(port);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return (AttributeType)0; // error occured
	AttributeType returnCode = (AttributeType)result->readLong();
	delete result;
	return returnCode;
}

FlowSystemReceiver FlowSystem_stub::createReceiver(Object destObject, const std::string& destPort, FlowSystemSender sender)
{
	long methodID = _lookupMethodFast("method:0f00000063726561746552656365697665720013000000466c6f7753797374656d5265636569766572000200000003000000070000006f626a656374000b000000646573744f626a6563740007000000737472696e67000900000064657374506f72740011000000466c6f7753797374656d53656e646572000700000073656e64657200");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	writeObject(*request,destObject._base());
	request->writeString(destPort);
	writeObject(*request,sender._base());
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	FlowSystemReceiver_base* returnCode;
	readObject(*result,returnCode);
	delete result;
	return FlowSystemReceiver(returnCode);
}

std::string FlowSystem_skel::_interfaceName()
{
	return "FlowSystem";
}

std::string FlowSystem_skel::_interfaceNameSkel()
{
	return "FlowSystem";
}

// startObject
static void _dispatch_FlowSystem_00(void *object, Buffer *request, Buffer *)
{
	Object_base* _temp_node;
	readObject(*request,_temp_node);
	Object node = _temp_node;
	((FlowSystem_skel *)object)->startObject(node);
}

// stopObject
static void _dispatch_FlowSystem_01(void *object, Buffer *request, Buffer *)
{
	Object_base* _temp_node;
	readObject(*request,_temp_node);
	Object node = _temp_node;
	((FlowSystem_skel *)object)->stopObject(node);
}

// connectObject
static void _dispatch_FlowSystem_02(void *object, Buffer *request, Buffer *)
{
	Object_base* _temp_sourceObject;
	readObject(*request,_temp_sourceObject);
	Object sourceObject = _temp_sourceObject;
	std::string sourcePort;
	request->readString(sourcePort);
	Object_base* _temp_destObject;
	readObject(*request,_temp_destObject);
	Object destObject = _temp_destObject;
	std::string destPort;
	request->readString(destPort);
	((FlowSystem_skel *)object)->connectObject(sourceObject,sourcePort,destObject,destPort);
}

// disconnectObject
static void _dispatch_FlowSystem_03(void *object, Buffer *request, Buffer *)
{
	Object_base* _temp_sourceObject;
	readObject(*request,_temp_sourceObject);
	Object sourceObject = _temp_sourceObject;
	std::string sourcePort;
	request->readString(sourcePort);
	Object_base* _temp_destObject;
	readObject(*request,_temp_destObject);
	Object destObject = _temp_destObject;
	std::string destPort;
	request->readString(destPort);
	((FlowSystem_skel *)object)->disconnectObject(sourceObject,sourcePort,destObject,destPort);
}

// queryFlags
static void _dispatch_FlowSystem_04(void *object, Buffer *request, Buffer *result)
{
	Object_base* _temp_node;
	readObject(*request,_temp_node);
	Object node = _temp_node;
	std::string port;
	request->readString(port);
	result->writeLong(((FlowSystem_skel *)object)->queryFlags(node,port));
}

// createReceiver
static void _dispatch_FlowSystem_05(void *object, Buffer *request, Buffer *result)
{
	Object_base* _temp_destObject;
	readObject(*request,_temp_destObject);
	Object destObject = _temp_destObject;
	std::string destPort;
	request->readString(destPort);
	FlowSystemSender_base* _temp_sender;
	readObject(*request,_temp_sender);
	FlowSystemSender sender = _temp_sender;
	FlowSystemReceiver returnCode = ((FlowSystem_skel *)object)->createReceiver(destObject,destPort,sender);
	writeObject(*result,returnCode._base());
}

void FlowSystem_skel::_buildMethodTable()
{
	Buffer m;
	m.fromString(
        "MethodTable:0c00000073746172744f626a6563740005000000766f6964000200"
        "000001000000070000006f626a65637400050000006e6f6465000b00000073746f"
        "704f626a6563740005000000766f6964000200000001000000070000006f626a65"
        "637400050000006e6f6465000e000000636f6e6e6563744f626a65637400050000"
        "00766f6964000200000004000000070000006f626a656374000d000000736f7572"
        "63654f626a6563740007000000737472696e67000b000000736f75726365506f72"
        "7400070000006f626a656374000b000000646573744f626a656374000700000073"
        "7472696e67000900000064657374506f72740011000000646973636f6e6e656374"
        "4f626a6563740005000000766f6964000200000004000000070000006f626a6563"
        "74000d000000736f757263654f626a6563740007000000737472696e67000b0000"
        "00736f75726365506f727400070000006f626a656374000b000000646573744f62"
        "6a6563740007000000737472696e67000900000064657374506f7274000b000000"
        "7175657279466c616773000e000000417474726962757465547970650002000000"
        "02000000070000006f626a65637400050000006e6f64650007000000737472696e"
        "670005000000706f7274000f000000637265617465526563656976657200130000"
        "00466c6f7753797374656d5265636569766572000200000003000000070000006f"
        "626a656374000b000000646573744f626a6563740007000000737472696e670009"
        "00000064657374506f72740011000000466c6f7753797374656d53656e64657200"
        "0700000073656e64657200",
		"MethodTable"
	);
	_addMethod(_dispatch_FlowSystem_00,this,MethodDef(m));
	_addMethod(_dispatch_FlowSystem_01,this,MethodDef(m));
	_addMethod(_dispatch_FlowSystem_02,this,MethodDef(m));
	_addMethod(_dispatch_FlowSystem_03,this,MethodDef(m));
	_addMethod(_dispatch_FlowSystem_04,this,MethodDef(m));
	_addMethod(_dispatch_FlowSystem_05,this,MethodDef(m));
}

FlowSystem_skel::FlowSystem_skel()
{
}

Object_base* FlowSystem::_Creator() {
	return FlowSystem_base::_create();
}

unsigned long FlowSystem_base::_IID = MCOPUtils::makeIID("FlowSystem");

GlobalComm_base *GlobalComm_base::_create(const std::string& subClass)
{
	Object_skel *skel = ObjectManager::the()->create(subClass);
	assert(skel);
	GlobalComm_base *castedObject = (GlobalComm_base *)skel->_cast(GlobalComm_base::_IID);
	assert(castedObject);
	return castedObject;
}

GlobalComm_base *GlobalComm_base::_fromString(std::string objectref)
{
	ObjectReference r;

	if(Dispatcher::the()->stringToObjectReference(r,objectref))
		return GlobalComm_base::_fromReference(r,true);
	return 0;
}

GlobalComm_base *GlobalComm_base::_fromReference(ObjectReference r, bool needcopy)
{
	GlobalComm_base *result;
	result = (GlobalComm_base *)Dispatcher::the()->connectObjectLocal(r,"GlobalComm");
	if(!result)
	{
		Connection *conn = Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new GlobalComm_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
		}
	}
	return result;
}

vector<std::string> GlobalComm_base::_defaultPortsIn() const {
	vector<std::string> ret;
	return ret;
}
vector<std::string> GlobalComm_base::_defaultPortsOut() const {
	vector<std::string> ret;
	return ret;
}

void *GlobalComm_base::_cast(unsigned long iid)
{
	if(iid == GlobalComm_base::_IID) return (GlobalComm_base *)this;
	if(iid == Object_base::_IID) return (Object_base *)this;
	return 0;
}

GlobalComm_stub::GlobalComm_stub()
{
	// constructor for subclasses (don't use directly)
}

GlobalComm_stub::GlobalComm_stub(Connection *connection, long objectID)
	: Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

bool GlobalComm_stub::put(const std::string& variable, const std::string& value)
{
	long methodID = _lookupMethodFast("method:040000007075740008000000626f6f6c65616e00020000000200000007000000737472696e6700090000007661726961626c650007000000737472696e67000600000076616c756500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(variable);
	request->writeString(value);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occured
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string GlobalComm_stub::get(const std::string& variable)
{
	long methodID = _lookupMethodFast("method:040000006765740007000000737472696e6700020000000100000007000000737472696e6700090000007661726961626c6500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(variable);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occured
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

void GlobalComm_stub::erase(const std::string& variable)
{
	long methodID = _lookupMethodFast("method:0600000065726173650005000000766f696400020000000100000007000000737472696e6700090000007661726961626c6500");
	long requestID;
	Buffer *request, *result;
	request = Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(variable);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string GlobalComm_skel::_interfaceName()
{
	return "GlobalComm";
}

std::string GlobalComm_skel::_interfaceNameSkel()
{
	return "GlobalComm";
}

// put
static void _dispatch_GlobalComm_00(void *object, Buffer *request, Buffer *result)
{
	std::string variable;
	request->readString(variable);
	std::string value;
	request->readString(value);
	result->writeBool(((GlobalComm_skel *)object)->put(variable,value));
}

// get
static void _dispatch_GlobalComm_01(void *object, Buffer *request, Buffer *result)
{
	std::string variable;
	request->readString(variable);
	result->writeString(((GlobalComm_skel *)object)->get(variable));
}

// erase
static void _dispatch_GlobalComm_02(void *object, Buffer *request, Buffer *)
{
	std::string variable;
	request->readString(variable);
	((GlobalComm_skel *)object)->erase(variable);
}

void GlobalComm_skel::_buildMethodTable()
{
	Buffer m;
	m.fromString(
        "MethodTable:040000007075740008000000626f6f6c65616e0002000000020000"
        "0007000000737472696e6700090000007661726961626c65000700000073747269"
        "6e67000600000076616c756500040000006765740007000000737472696e670002"
        "0000000100000007000000737472696e6700090000007661726961626c65000600"
        "000065726173650005000000766f69640002000000010000000700000073747269"
        "6e6700090000007661726961626c6500",
		"MethodTable"
	);
	_addMethod(_dispatch_GlobalComm_00,this,MethodDef(m));
	_addMethod(_dispatch_GlobalComm_01,this,MethodDef(m));
	_addMethod(_dispatch_GlobalComm_02,this,MethodDef(m));
}

GlobalComm_skel::GlobalComm_skel()
{
}

Object_base* GlobalComm::_Creator() {
	return GlobalComm_base::_create();
}

unsigned long GlobalComm_base::_IID = MCOPUtils::makeIID("GlobalComm");

TmpGlobalComm_base *TmpGlobalComm_base::_create(const std::string& subClass)
{
	Object_skel *skel = ObjectManager::the()->create(subClass);
	assert(skel);
	TmpGlobalComm_base *castedObject = (TmpGlobalComm_base *)skel->_cast(TmpGlobalComm_base::_IID);
	assert(castedObject);
	return castedObject;
}

TmpGlobalComm_base *TmpGlobalComm_base::_fromString(std::string objectref)
{
	ObjectReference r;

	if(Dispatcher::the()->stringToObjectReference(r,objectref))
		return TmpGlobalComm_base::_fromReference(r,true);
	return 0;
}

TmpGlobalComm_base *TmpGlobalComm_base::_fromReference(ObjectReference r, bool needcopy)
{
	TmpGlobalComm_base *result;
	result = (TmpGlobalComm_base *)Dispatcher::the()->connectObjectLocal(r,"TmpGlobalComm");
	if(!result)
	{
		Connection *conn = Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new TmpGlobalComm_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
		}
	}
	return result;
}

vector<std::string> TmpGlobalComm_base::_defaultPortsIn() const {
	vector<std::string> ret;
	return ret;
}
vector<std::string> TmpGlobalComm_base::_defaultPortsOut() const {
	vector<std::string> ret;
	return ret;
}

void *TmpGlobalComm_base::_cast(unsigned long iid)
{
	if(iid == TmpGlobalComm_base::_IID) return (TmpGlobalComm_base *)this;
	if(iid == GlobalComm_base::_IID) return (GlobalComm_base *)this;
	if(iid == Object_base::_IID) return (Object_base *)this;
	return 0;
}

TmpGlobalComm_stub::TmpGlobalComm_stub()
{
	// constructor for subclasses (don't use directly)
}

TmpGlobalComm_stub::TmpGlobalComm_stub(Connection *connection, long objectID)
	: Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::string TmpGlobalComm_skel::_interfaceName()
{
	return "TmpGlobalComm";
}

std::string TmpGlobalComm_skel::_interfaceNameSkel()
{
	return "TmpGlobalComm";
}

void TmpGlobalComm_skel::_buildMethodTable()
{
	Buffer m;
	m.fromString(
        "MethodTable:",
		"MethodTable"
	);
	GlobalComm_skel::_buildMethodTable();
}

TmpGlobalComm_skel::TmpGlobalComm_skel()
{
}

Object_base* TmpGlobalComm::_Creator() {
	return TmpGlobalComm_base::_create();
}

unsigned long TmpGlobalComm_base::_IID = MCOPUtils::makeIID("TmpGlobalComm");

static IDLFileReg IDLFileReg_core("core",
    "IDLFile:010000000000000000040000000c0000004865616465724d61676963000100"
    "00000b0000004d434f505f4d41474943004d434f500c0000004d657373616765547970"
    "6500060000000f0000006d636f70496e766f636174696f6e00010000000b0000006d63"
    "6f7052657475726e0002000000100000006d636f7053657276657248656c6c6f000300"
    "0000100000006d636f70436c69656e7448656c6c6f00040000000f0000006d636f7041"
    "7574684163636570740005000000150000006d636f704f6e65776179496e766f636174"
    "696f6e00060000000b0000004d6574686f645479706500020000000d0000006d657468"
    "6f644f6e6577617900010000000d0000006d6574686f6454776f77617900020000000e"
    "0000004174747269627574655479706500070000000900000073747265616d496e0001"
    "0000000a00000073747265616d4f757400020000000c00000073747265616d4d756c74"
    "6900040000001000000061747472696275746553747265616d00080000001300000061"
    "747472696275746541747472696275746500100000000c00000073747265616d417379"
    "6e6300200000000e00000073747265616d44656661756c7400400000000f0000000700"
    "000048656164657200030000000c0000004865616465724d6167696300060000006d61"
    "67696300050000006c6f6e67000e0000006d6573736167654c656e677468000c000000"
    "4d65737361676554797065000c0000006d65737361676554797065000b000000496e76"
    "6f636174696f6e0003000000050000006c6f6e67000a00000072657175657374494400"
    "050000006c6f6e6700090000006f626a656374494400050000006c6f6e670009000000"
    "6d6574686f64494400110000004f6e65776179496e766f636174696f6e000200000005"
    "0000006c6f6e6700090000006f626a656374494400050000006c6f6e6700090000006d"
    "6574686f644944000c00000053657276657248656c6c6f000300000007000000737472"
    "696e670009000000736572766572494400080000002a737472696e67000e0000006175"
    "746850726f746f636f6c730007000000737472696e6700090000006175746853656564"
    "000c000000436c69656e7448656c6c6f000300000007000000737472696e6700090000"
    "0073657276657249440007000000737472696e67000d0000006175746850726f746f63"
    "6f6c0007000000737472696e670009000000617574684461746100100000004f626a65"
    "63745265666572656e6365000300000007000000737472696e67000900000073657276"
    "6572494400050000006c6f6e6700090000006f626a656374494400080000002a737472"
    "696e67000500000075726c730009000000506172616d44656600020000000700000073"
    "7472696e670005000000747970650007000000737472696e6700050000006e616d6500"
    "0a0000004d6574686f64446566000400000007000000737472696e6700050000006e61"
    "6d650007000000737472696e67000500000074797065000b0000004d6574686f645479"
    "70650006000000666c616773000a0000002a506172616d446566000a0000007369676e"
    "6174757265000d00000041747472696275746544656600030000000700000073747269"
    "6e6700050000006e616d650007000000737472696e67000500000074797065000e0000"
    "00417474726962757465547970650006000000666c616773000d000000496e74657266"
    "616365446566000500000007000000737472696e6700050000006e616d650008000000"
    "2a737472696e670014000000696e68657269746564496e7465726661636573000b0000"
    "002a4d6574686f6444656600080000006d6574686f6473000e0000002a417474726962"
    "757465446566000b0000006174747269627574657300080000002a737472696e67000d"
    "00000064656661756c74506f727473000e00000054797065436f6d706f6e656e740002"
    "00000007000000737472696e670005000000747970650007000000737472696e670005"
    "0000006e616d65000800000054797065446566000200000007000000737472696e6700"
    "050000006e616d65000f0000002a54797065436f6d706f6e656e740009000000636f6e"
    "74656e7473000e000000456e756d436f6d706f6e656e74000200000007000000737472"
    "696e6700050000006e616d6500050000006c6f6e67000600000076616c756500080000"
    "00456e756d446566000200000007000000737472696e6700050000006e616d65000f00"
    "00002a456e756d436f6d706f6e656e740009000000636f6e74656e7473000a0000004d"
    "6f64756c65446566000500000007000000737472696e67000b0000006d6f64756c654e"
    "616d65000b0000002a4d6f64756c6544656600080000006d6f64756c65730009000000"
    "2a456e756d4465660006000000656e756d7300090000002a5479706544656600060000"
    "007479706573000e0000002a496e74657266616365446566000b000000696e74657266"
    "6163657300060000000e000000496e746572666163655265706f000000000004000000"
    "0d000000696e736572744d6f64756c6500050000006c6f6e670002000000010000000a"
    "0000004d6f64756c65446566000a0000006e65774d6f64756c65000d00000072656d6f"
    "76654d6f64756c650005000000766f6964000200000001000000050000006c6f6e6700"
    "090000006d6f64756c654944000f0000007175657279496e74657266616365000d0000"
    "00496e7465726661636544656600020000000100000007000000737472696e67000500"
    "00006e616d65000a000000717565727954797065000800000054797065446566000200"
    "00000100000007000000737472696e6700050000006e616d6500000000000000000011"
    "000000466c6f7753797374656d53656e6465720000000000010000000a00000070726f"
    "6365737365640005000000766f69640001000000000000000000000000000000130000"
    "00466c6f7753797374656d526563656976657200000000000000000001000000110000"
    "007265636569766548616e646c6572494400050000006c6f6e67001200000000000000"
    "0b000000466c6f7753797374656d0000000000060000000c00000073746172744f626a"
    "6563740005000000766f6964000200000001000000070000006f626a65637400050000"
    "006e6f6465000b00000073746f704f626a6563740005000000766f6964000200000001"
    "000000070000006f626a65637400050000006e6f6465000e000000636f6e6e6563744f"
    "626a6563740005000000766f6964000200000004000000070000006f626a656374000d"
    "000000736f757263654f626a6563740007000000737472696e67000b000000736f7572"
    "6365506f727400070000006f626a656374000b000000646573744f626a656374000700"
    "0000737472696e67000900000064657374506f72740011000000646973636f6e6e6563"
    "744f626a6563740005000000766f6964000200000004000000070000006f626a656374"
    "000d000000736f757263654f626a6563740007000000737472696e67000b000000736f"
    "75726365506f727400070000006f626a656374000b000000646573744f626a65637400"
    "07000000737472696e67000900000064657374506f7274000b0000007175657279466c"
    "616773000e00000041747472696275746554797065000200000002000000070000006f"
    "626a65637400050000006e6f64650007000000737472696e670005000000706f727400"
    "0f00000063726561746552656365697665720013000000466c6f7753797374656d5265"
    "636569766572000200000003000000070000006f626a656374000b000000646573744f"
    "626a6563740007000000737472696e67000900000064657374506f7274001100000046"
    "6c6f7753797374656d53656e646572000700000073656e646572000000000000000000"
    "0b000000476c6f62616c436f6d6d000000000003000000040000007075740008000000"
    "626f6f6c65616e00020000000200000007000000737472696e67000900000076617269"
    "61626c650007000000737472696e67000600000076616c756500040000006765740007"
    "000000737472696e6700020000000100000007000000737472696e6700090000007661"
    "726961626c65000600000065726173650005000000766f696400020000000100000007"
    "000000737472696e6700090000007661726961626c650000000000000000000e000000"
    "546d70476c6f62616c436f6d6d00010000000b000000476c6f62616c436f6d6d000000"
    "00000000000000000000"
);
