/*
 * Copyright (c) 1999 Daniel M. Duley <mosfet@kde.org>
 * Copyright (c) 2000 Matthias Elter <elter@kde.org>
 *
 * Artistic License - See file LICENSE for details.
 */

#ifndef __menus_h__
#define __menus_h__

#include <qlist.h>
#include <qstringlist.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qintdict.h>
#include <qtimer.h>

#include <kpopupmenu.h>

#include "clientmenu.h"


class KAboutKDE;
class KProcess;

//class QDir; //conficting header hack
typedef QListIterator<QFileInfo>QFileInfoListIterator;

class KickerClientMenu;

// Base class for file and applnk menus
class PanelMenu : public KPopupMenu
{
  Q_OBJECT;
  
 public:
  PanelMenu(const QString &startDir, QWidget *parent=0,
            const char *name=0);
  ~PanelMenu(){}
  
  const QString& path() { return(startPath); }
  void setPath(const QString &p) { startPath = p; }
  bool initialized() { return(init); }

 public slots:
  virtual void slotAboutToShow();
  virtual void initialize() = 0;

 protected slots:
  virtual void slotExec(int id) = 0;
  void slotClear();

 protected:
  virtual void hideEvent(QHideEvent *ev);

  bool init;
  int clearDelay;
  QString startPath;
  QTimer t;
};

class PanelAppletMenu : public KPopupMenu
{
  Q_OBJECT;
  
 public:
  PanelAppletMenu(QWidget *parent=0, const char *name=0);

 protected slots:
  virtual void slotExec(int id);

 private:
  QStringList internalApplets;
};

// Both a file and applnk directory structure browser popupmenu
class PanelBrowserMenu : public PanelMenu
{
  Q_OBJECT;
  
 public:
  PanelBrowserMenu(QString startDir, bool useRelative = false,
		   bool expandFSTypes=false,
                   bool ignoreEmptyDirs=false, QWidget *parent=0,
                   const char *name=0,
                   int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                   int sorting = QDir::DirsFirst| QDir::Name);

  void append(const QPixmap &pixmap, const QString &title,
              const QString &filename);
  void append(const QPixmap &smallPixmap, const QPixmap &mediumPixmap,
              const QString &title,
              const QString &filename);
  void append(const QIconSet &iconSet, const QString &title,
              const QString &filename);
  void append(const QPixmap &pixmap, const QString &title,
              PanelBrowserMenu *subMenu);
  void append(const QPixmap &smallPixmap, const QPixmap &mediumPixmap,
              const QString &title,
              PanelBrowserMenu *subMenu);
  void append(const QIconSet &iconSet, const QString &title,
              PanelBrowserMenu *subMenu);

  
 public slots:
  virtual void initialize();

 protected slots:
  virtual void slotExec(int id);
 
 protected:
  virtual void mousePressEvent(QMouseEvent *);
  virtual void mouseMoveEvent(QMouseEvent *);  

  virtual PanelBrowserMenu* createSubMenu(QString startDir,
					  bool useRelative = false,
					  bool expandFSTypes=false,
                                  bool ignoreEmptyDirs=false, QWidget *parent=0,
                                  const char *name=0,
                                  int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                                  int sorting = QDir::DirsFirst| QDir::Name);

  bool useRel;
  QString relPath;
  QPoint m_pressedPos;
  QStringList fileList;
  QList<PanelBrowserMenu> subMenus;
  
  unsigned int max;
  bool merge;
  bool maxedOut, expandFS, ignoreEmpty;
  QDir::FilterSpec filterSpec;
  QDir::SortSpec sortSpec;
};


// The toplevel menu for the quickbrowser
class PanelQuickBrowser : public PanelMenu
{
  Q_OBJECT;

 public:
  PanelQuickBrowser(QWidget *parent=0, const char *name=0);
 
 public slots:
  virtual void initialize();

 protected slots:
  virtual void slotExec(int id);

 protected:
  void parseBrowserApplnks(QFileInfoListIterator &it, const QString &title,
                           const QString &pixmap);
  QStringList fileList;
  unsigned int max;
};

// A exec menu with the Kicker special popupmenu items.
class PanelKMenu : public PanelBrowserMenu
{
  Q_OBJECT;
  
 public:
  PanelKMenu(QWidget *parent=0, const char *name=0);
  ~PanelKMenu();
  
  virtual void initialize(); // call this before manually adding menus
  
  int insertClientMenu(KickerClientMenu *p);
  void removeClientMenu(int id);
  
 protected slots:
  void slotLock();
  void slotLogout();
  void slotRunCommand();
  void slotContextHelp();
  void slotAboutKDE();

 private:
  int client_id;
  KAboutKDE *aboutKDE;
  QIntDict<KickerClientMenu> clients;
};

class PanelAddAppsBaseMenu : public PanelBrowserMenu
{
  Q_OBJECT;
  
 public:
  PanelAddAppsBaseMenu(QString startDir, bool expandFSTypes=false,
                       bool ignoreEmptyDirs=false, QWidget *parent=0,
                       const char *name=0,
                       int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                       int sorting = QDir::DirsFirst| QDir::Name);

 protected slots:
  virtual void slotExec(int id);

 protected:
  virtual PanelBrowserMenu* createSubMenu(QString startDir, bool expandFSTypes=false,
                                          bool ignoreEmptyDirs=false, QWidget *parent=0,
                                          const char *name=0,
                                          int filter = QDir::Hidden | QDir::Dirs | QDir::Files,
                                          int sorting = QDir::DirsFirst| QDir::Name);

};

// Add applications menu
class PanelAddAppsMenu : public PanelAddAppsBaseMenu
{
  Q_OBJECT;
  
 public:
  PanelAddAppsMenu(QWidget *parent=0, const char *name=0);
  ~PanelAddAppsMenu(){;}

  virtual void initialize();
};

// Menu for the "Recent Documents". It mostly just re-initializes when shown.
class PanelRecentMenu : public PanelBrowserMenu
{
  Q_OBJECT;
  
 public:
  PanelRecentMenu(QWidget *parent=0, const char *name=0);
  virtual void initialize();
 
 protected slots:
  void slotClearHistory();
};

// The button operations menu (usually right click)
class PanelAppletOpMenu : public KPopupMenu
{
 public:
  enum OpButton{Move=1, Remove, Properties};
  PanelAppletOpMenu(QWidget *parent=0, const char *name=0);
};

// The directory dropped menu
class PanelDirDropMenu : public KPopupMenu
{
 public:
  enum OpButton{Url=1, Browser};
  PanelDirDropMenu(QWidget *parent=0, const char *name=0);
};

class PanelOpMenu : public KPopupMenu
{
  Q_OBJECT;
 
 public:
  PanelOpMenu(QWidget *parent=0, const char *name=0);

 protected slots:
  void slotSizeSmall();
  void slotSizeNormal();
  void slotSizeLarge();
  void slotConfigure();
  void slotRestart();
  void slotRestartDontAsk();
  void slotAddKMenu();
  void slotAddQuickBrowser();
  void slotAddNonKDEApp();
};

#endif // __menus_h__
