/*
 * (C) Antonio Larrosa Jimenez <larrosa@kde.org> KDE artistic license.
 * (C) Daniel M. Duley (mosfet@kde.org) KDE artistic license.
 */

#ifndef __PAGER_H
#define __PAGER_H

#include <qvaluelist.h>
#include <qbutton.h>
#include <qlayout.h>

#include "desktop.h"
#include "minibutton.h"
#include "../../internalapplet.h"

class KPager : public InternalApplet
{
  Q_OBJECT;

 public:
    KPager(QWidget *parent=0, const char *name=0);

    int widthForHeight(int height);
    int heightForWidth(int width);

public slots:
    void slotSetDesktop(int desktop);
    void slotSetDesktopCount(int count);
    void slotButtonClicked(int desk);
    void showPopupMenu(WId wid, QPoint pos);
    void setViewMode(int i);

    void test(WId);

protected:
    QWidget *desktopFactory(int desktop);
    void allocateDesktops();
    void resizeEvent(QResizeEvent*);

    /**
     * This could be a QValueList <KPagerDesktop *>, but I've preferred to use
     * a QWidget to be able to store the MiniPagerButtons in the same list
     * 
     */
    QValueList<QWidget*>dskList;
    QGridLayout *layout;
    QBoxLayout *mainlayout;
    int curDesk;

    /**
     *  
     */
    enum ViewMode {ButtonNumber=0, ButtonName, DesktopPlain=2, DesktopSimple, DesktopIcon, DesktopPixmap};
    ViewMode viewMode;

    /**
     * Returns true if viewMode is DesktopPlain, Simple, Icon or Pixmap. 
     * It returns false if we're using buttons
     */
    int isDesktopMode() const;
};

#endif

