/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __appletarea_h__
#define __appletarea_h__

#include <qlist.h>

#include <dcopobject.h>

#include "global.h"
#include "panner.h"
#include "appletcontainer.h"

class AppletArea : public Panner, DCOPObject
{
  Q_OBJECT;
  
 public:
  AppletArea( Orientation orientation, QWidget* parent, const char* name = 0);
  ~AppletArea();

  bool process(const QCString &fun, const QByteArray &data,
               QCString& replyType, QByteArray &replyData);

  void addKMenuButton();
  void addURLButton(const QString &url);
  void addBrowserButton(const QString &startDir);
  void addExeButton(const QString &filePath, const QString &icon,
                    const QString &cmdLine, bool inTerm);

  void addInternalFrame(const QString &name, const QString &desktopFile);

  void configure();

 public slots:
  void startAppletMove(AppletContainer *a);
  void stopAppletMove(AppletContainer *a);
  void removeApplet(AppletContainer *a);

 protected:
  void layoutChildren();
  AppletContainer* findApplet( QCString id );
  void dockMe( QCString application, QCString applet);
  // does AppletContainer a cover other AppletContainer's ? (if(strict == false): more than 25%)?
  AppletContainer* coversAppletContainer(AppletContainer *a, bool strict);
  void updateAppletContainerList();
  int relativeAppletContainerPos(AppletContainer* a);
  int totalFreeSpace();

  void mouseMoveEvent(QMouseEvent *);
  void mouseReleaseEvent(QMouseEvent *);

  void dragEnterEvent(QDragEnterEvent *ev);
  void dropEvent(QDropEvent *ev);

  void addApplet(AppletContainer* a);
  void setUniqueId(AppletContainer* a);
  void moveToFirstFreePosition(AppletContainer* a);

  bool isStretch(AppletContainer* a);
  bool isTopLevel(AppletContainer* a);

  void setupDummyWidget(AppletContainer* a);

 protected slots:
  void embeddedWindowDestroyed();
  void saveAppletConfig();
  void slotLayoutChildren();

 private:
  QList<AppletContainer> _applets;

  bool _block_relayout;
  bool _movingAC;
  AppletContainer *_moveAC;
  QPoint _moveOffset;
  int  _mouseAccel, _mouseThreshold;
  QWidget *_dummyWidget;

};

#endif

