/* $XConsortium: policy.c,v 1.12 94/04/17 20:03:41 hersh Exp $ */
/* $XFree86: xc/programs/xdm/policy.c,v 3.0 1994/06/28 12:32:38 dawes Exp $ */
/* $Id: policy.c,v 1.6 1999/11/17 00:12:07 steffen Exp $ */
/*

Copyright (c) 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * xdm - display manager daemon
 * Author:  Keith Packard, MIT X Consortium
 *
 * policy.c.  Implement site-dependent policy for XDMCP connections
 */

# include "dm.h"
#include <stdio.h>
#include <stdlib.h>

#include <config.h>

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#ifdef XDMCP

# include <X11/X.h>
#ifndef MINIX
# include <sys/socket.h>
#ifdef AF_INET
# include <netinet/in.h>
#endif
#endif

static ARRAY8 noAuthentication = { (CARD16) 0, (CARD8Ptr) 0 };

typedef struct _XdmAuth {
    ARRAY8  authentication;
    ARRAY8  authorization;
} XdmAuthRec, *XdmAuthPtr;

static XdmAuthRec auth[] = {
#ifdef HASXDMAUTH
{ {(CARD16) 20, (CARD8 *) "XDM-AUTHENTICATION-1"},
  {(CARD16) 19, (CARD8 *) "XDM-AUTHORIZATION-1"},
},
#endif
{ {(CARD16) 0, (CARD8 *) 0},
  {(CARD16) 0, (CARD8 *) 0},
}
};

#define NumAuth	(sizeof auth / sizeof auth[0])

ARRAY8Ptr
ChooseAuthentication (authenticationNames)
    ARRAYofARRAY8Ptr	authenticationNames;
{
    int	i, j;

    for (i = 0; i < (int)authenticationNames->length; i++)
	for (j = 0; j < NumAuth; j++)
	    if (XdmcpARRAY8Equal (&authenticationNames->data[i],
				  &auth[j].authentication))
		return &authenticationNames->data[i];
    return &noAuthentication;
}

int CheckAuthentication (pdpy, displayID, name, data)
    struct protoDisplay	*pdpy;
    ARRAY8Ptr		displayID, name, data;
{
#ifdef HASXDMAUTH
    if (name->length && !strncmp ((char *)name->data, "XDM-AUTHENTICATION-1", 20))
	return XdmCheckAuthentication (pdpy, displayID, name, data);
#endif
    return TRUE;
}

extern int ValidAuthorization( unsigned short name_length, char *name );

int
SelectAuthorizationTypeIndex (authenticationName, authorizationNames)
    ARRAY8Ptr		authenticationName;
    ARRAYofARRAY8Ptr	authorizationNames;
{
    int	i, j;

    for (j = 0; j < NumAuth; j++)
	if (XdmcpARRAY8Equal (authenticationName,
			      &auth[j].authentication))
	    break;
    if (j < NumAuth)
    {
    	for (i = 0; i < (int)authorizationNames->length; i++)
	    if (XdmcpARRAY8Equal (&authorizationNames->data[i],
				  &auth[j].authorization))
	    	return i;
    }
    for (i = 0; i < (int)authorizationNames->length; i++)
	if (ValidAuthorization (authorizationNames->data[i].length,
				(char *) authorizationNames->data[i].data))
	    return i;
    return -1;
}

extern int AcceptableDisplayAddress( ARRAY8Ptr clientAddress,
                                     CARD16 connectionType,
                                     xdmOpCode type );

/* Report the loadavg to chooser. Nice feature --
 * someone told me that the xdm packaged with Debian
 * already does this??
 *
 * Wed Mar 10 06:14:56 1999 -- Steffen Hansen
 */
static void Willing_msg( char* mbuf)
{
#ifdef __linux__
	int fd;
  const char *fail_msg = "Willing to manage";
  char buf[1024];
  FILE *f;
	float load[3];
  float mhz = 0.0;
	int numcpu = 0;

  fd = open( "/proc/loadavg", O_RDONLY);
  if( fd == -1) {
		sprintf( mbuf, fail_msg);
		return;

  } else if( read( fd, buf, 100) < 4) {
		close( fd);
	  sprintf( mbuf, fail_msg);	
		return;
  }

	sscanf(buf, "%f %f %f", &load[0], &load[1], &load[2]);
	snprintf(mbuf, 256, "Available (load: %0.2f, %0.2f, %0.2f)",
		load[0], load[1], load[2]);
	close( fd);

	mbuf[255] = 0;

	numcpu = 0;

	if(!(f = fopen("/proc/cpuinfo", "r")))
		return;

	while(!feof(f)) {	
	  float m;
		fgets(buf, 1024, f);
		buf[sizeof(buf)-1] = 0;

		if(sscanf(buf, "cpu MHz : %f", &m)) {
			numcpu++;
			mhz = m ;
		}
	}

   fclose(f);

   if(numcpu) {
        if(numcpu > 1) 
	   sprintf(buf, " %d*%0.0f MHz", numcpu, mhz);	   
        else
	   sprintf(buf, " %0.0f MHz", mhz);	   
	
	strncat(mbuf, buf, 256);

	mbuf[255] = 0;
   }
#elif BSD4_3
#warning This code is untested...
     double load[3];
     getloadavg(load, 3);
     sprintf( mbuf, "Available (load: %0.2f, %0.2f, %0.2f)", load[0], load[1], load[2]);
#else /* !__linux__ */
     sprintf( mbuf, "Willing to manage");     
#endif
}

/*ARGSUSED*/
int
Willing (addr, connectionType, authenticationName, status, type)
    ARRAY8Ptr	    addr;
    CARD16	    connectionType;
    ARRAY8Ptr	    authenticationName;
    ARRAY8Ptr	    status;
    xdmOpCode	    type;
{
    char	statusBuf[256];
    int		ret;
    
    ret = AcceptableDisplayAddress (addr, connectionType, type);
    if (!ret)
	sprintf (statusBuf, "Display not authorized to connect");
    else
	Willing_msg(statusBuf);
    status->length = strlen (statusBuf);
    status->data = (CARD8Ptr) malloc (status->length);
    if (!status->data)
	status->length = 0;
    else
	memmove( status->data, statusBuf, status->length);
    return ret;
}

/*ARGSUSED*/
ARRAY8Ptr
Accept (from, fromlen, displayNumber)
    struct sockaddr *from;
    int		    fromlen;
    CARD16	    displayNumber;
{
    return 0;
}

/*ARGSUSED*/
int
SelectConnectionTypeIndex (connectionTypes, connectionAddresses)
    ARRAY16Ptr	     connectionTypes;
    ARRAYofARRAY8Ptr connectionAddresses;
{
    return 0;
}

#endif /* XDMCP */
