/* vi: ts=8 sts=4 sw=4
 *
 * $Id: bgmanager.h,v 1.15 2000/02/13 20:02:49 jansen Exp $
 *
 * This file is part of the KDE project, module kdesktop.
 * Copyright (C) 1999 Geert Jansen <g.t.jansen@stud.tue.nl>
 *
 * You can Freely distribute this program under the GNU General Public
 * License. See the file "COPYING" for the exact licensing terms.
 */

#ifndef __BGManager_h_Included__
#define __BGManager_h_Included__

#include <qstring.h>
#include <kdockwindow.h>
#include <qvector.h>

#include <KBackgroundIface.h>

class KConfig;
class QTimer;
class QPixmap;
class KPopupMenu;
class KWinModule;
class KPixmap;
class KBackgroundRenderer;
class KPixmapServer;

/**
 * A dock widget for KBackgroundManager. This implements the
 * "display settings" docking icon.
 */
class KBackgroundDockWidget
    : public KDockWindow
{
    Q_OBJECT

public:
    KBackgroundDockWidget();

    void setCommon(bool);
    void setExport(bool);

protected:
    virtual void dropEvent(QDropEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void dragEnterEvent(QDragEnterEvent *e);

public slots:
    void slotModeSelected(int);
    void slotBackgroundSettings();
    void slotAdvancedSettings();
    void slotCommon();
    void slotExport();
    void slotUndock();

signals:
    void changeWallpaper();
    void wallpaperDropped(QString wallpaper, int mode);
    void unDocked();
    void commonChanged(bool);
    void exportChanged(bool);

private:
    bool m_bExport, m_bCommon;
    int m_Export, m_Common;

    QString m_Wallpaper;
    KPopupMenu *m_pMainMenu, *m_pModeMenu;
};



/**
 * Internal struct for KBackgroundManager.
 */
struct KBackgroundCacheEntry
{
    int hash;
    int atime;
    int exp_from;
    KPixmap *pixmap;
};


/**
 * Background manager for KDE. This class is to be used in kdesktop. Usage is
 * very simple: instantiate this class once and the desktop background will
 * be painted automatically from now on.
 *
 * The background manager also has a DCOP interface to remotely control its
 * operation. See KBackgroundIface.h for details.
 */

class KBackgroundManager
    : public QObject,
      virtual public KBackgroundIface
{
    Q_OBJECT

public:
    KBackgroundManager(QWidget *desktop, KWinModule* kwinModule);
    ~KBackgroundManager();

    void configure();
    void changeDesktop(int desk);
    void setCommon(int);
    void setExport(int);
    void setDocking(int);

private slots:
    void slotImageDone(int desk);
    void slotWallpaperDropped(QString wallpaper, int mode);
    void slotUnDocked();
    void slotCommon(bool);
    void slotExport(bool);
    void slotTimeout();
    void slotChangeWallpaper();
    void slotChangeDesktop(int);
    void slotDesktopNumberChanged(int);

private:
    void applyCommon(bool common);
    void applyDocking(bool dock);
    void applyExport(bool _export);
    void applyCache(bool limit, int size);

    int realDesktop();
    int effectiveDesktop();

    void renderBackground(int desk);
    void exportBackground(int pixmap, int desk);
    int pixmapSize(QPixmap *pm);
    int cacheSize();
    void removeCache(int desk);
    bool freeCache(int size);
    void addCache(KPixmap *pm, int hash, int desk);
    void setPixmap(KPixmap *pm, int hash, int desk);

    bool m_bExport, m_bCommon, m_bDock;
    bool m_bLimitCache, m_bInit;

    int m_CacheLimit, m_X, m_Y;
    int m_Serial, m_Hash, m_Current;

    KConfig *m_pConfig;
    QWidget *m_pDesktop;
    KBackgroundDockWidget *m_pDockWidget;
    QTimer *m_pTimer;

    QVector<KBackgroundRenderer> m_Renderer;
    QVector<KBackgroundCacheEntry> m_Cache;
    
    KWinModule *m_pKwinmodule;
    KPixmapServer *m_pPixmapServer;
};


#endif // __BGManager_h_Included__
