/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


// Implementation einer von QMultiLineEdit abgleiteten Klasse, die
// einen Vorschreibpuffer zur Verfuegung stellt, wie ich ihn mir vorstelle.

#include <qkeycode.h>
#include <syslog.h>
#include <stdio.h>
#include <kwmmapp.h>
#include <qaccel.h>

#include "vorschreib.h"
#include "main.h"
#include "global.h"
#include "toolbox.h"


extern TopLevel *toplevel;


myVorschreib::myVorschreib( ChanList *rxlist, QWidget *rxchan, QWidget *parent, const char *name )
                     : QMultiLineEdit( parent, name )
{
   maxlines = 0;
   list = rxlist;
   chan = rxchan;
   clearTableFlags(Tbl_autoVScrollBar|Tbl_autoHScrollBar);
}


void myVorschreib::keyPressEvent( QKeyEvent *e)
{
   int line,col,anz_lines,len,oldcol;
   char text[500], text2[500];
   int i;

   if ((e->key() == Key_Right) && ((e->state() & ControlButton) != 0))
   {
      // Stellt den Cursor auf das Zeichen nach dem naechsten Space
      cursorPosition(&line,&col);
      oldcol = col;
      strcpy(text, textLine(line));
      if (strlen(text) >= (unsigned int)col)
      {
         // Jetzt werden alle Zeichen, die keine Spaces sind, uebersprungen
         while ((text[col] != ' ') && (text[col] != '\0')) col++;
         // Jetzt werden die naechsten Spaces uebersprungen, so dass der
         // Cursor am Anfang des naechsten Wortes Space steht
         while (text[col] == ' ') col++;

         setCursorPosition(line, col);
      }
      e->accept();
      return;
   }


   if ((e->key() == Key_Left) && ((e->state() & ControlButton) != 0))
   {
      // Stellt den Cursor auf das Zeichen nach dem letzten Space
      cursorPosition(&line,&col);
      strcpy(text, textLine(line));
      text[col] = '\0';
      if (col > 0)
      {
         col--;
         // Alle Spaces vor dem Cursor ueberspringen
         while ((text[col] == ' ') && (col > 0)) col--;
         // Alle Zeichen uebersprigen, die zwischen der aktuellen
         // Cursorposition und dem letzten Space liegen
         while ((text[col-1] != ' ') && (col > 0)) col--;

         setCursorPosition(line, col);
      }
      e->accept();
      return;
   }


   // Mit Cursor links nicht in die obere Zeile laufen
   if (e->key() == Key_Left)
   {
      cursorPosition(&line,&col);
      if (col == 0)
      {
         e->accept();
         return;
      }
   }
   if (e->key() == Key_Backspace)
   {
      cursorPosition(&line,&col);
      if (col == 0)
      {
         e->accept();
         return;
      }
   }


   // Die Escape-Taste nicht zulassen.
   if (e->key() == Key_Escape)
   {
      chan->hide();
      KWM::activate(toplevel->winId());
      toplevel->show();
      return;
   }

   // Die Verarbeitung der Return-Taste
   if (e->key() == Key_Enter || e->key() == Key_Return)
   {
      // Auf jeden Fall bescheid geben, dass Return gedrueckt wurde.
      emit returnPressed();

      // Wenn der Cursor ganz unten im Puffer steht, wird eine neue Zeile
      // angehaengt (newLine()). Ansonsten den Cursor einfach in die naechste
      // Zeile stellen.
      cursorPosition(&line,&col);
      if (((anz_lines = numLines())-1 == line) ||
          (textLine(line)[0] != '\0'))
      {
         // Den Cursor ans Ende der aktuellen Zeile stellen
         setCursorPosition(line, lineLength(line));
         if (line == anz_lines-1)
            newLine();
         setCursorPosition(line+1, 0);
      }
      else setCursorPosition(line+1, col);

      // Nicht mehr als maxlines Zeilen zulassen, wenn maxlines>0 ist.
      if (maxlines > 0)
      {
         while (numLines() > maxlines)
            removeLine(0);
      }

      return;
   }


   // Wenn Key_Down (Cursor) gedrueckt wurde, gucken, ob die unterste
   // Zeile schon beschrieben wurde. Wenn ja, eine Zeile weiter runter
   // gehen.
   if (e->key() == Key_Down)
   {
      cursorPosition(&line,&col);
      if (line == numLines()-1)
         if (lineLength(line) > 0)
         {
            setCursorPosition(line, lineLength(line));
            newLine();

            // Nicht mehr als maxlines Zeilen zulassen, wenn maxlines>0 ist.
            if (maxlines > 0)
            {
               while (numLines() > maxlines)
                  removeLine(0);
            }

            return;
         }
   }


   if (e->key() == Key_PageUp)
   {
      emit signalPageUp();
      return;
   }


   if (e->key() == Key_PageDown)
   {
      emit signalPageDown();
      return;
   }


   // CTRL-0 bis CTRL-9 abfangen
   if (((e->state() & ControlButton) != 0) && (e->key() >= Key_0) && (e->key() <= Key_9))
   {
      // Wenn fuer diese Tastenkombination ein Shortkey eingetragen
      // ist, wird er sofort ausgesendet
      if (config->shortcuts[e->key()-Key_0] != NULL)
      {
         ((Channel *)chan)->macroLine(text, config->shortcuts[e->key()-Key_0]);
         strcat(text, "\r");
         ((Channel *)chan)->sendString( text );
      }
      e->accept();
      return;
   }


   if (((e->state() & ControlButton) == 0) && (e->key() >= Key_F1) && (e->key() <= Key_F10))
   {
      emit signalFunctionKey(e->key()-Key_F1);
      e->accept();
      return;
   }


   // Zeilenumbruch?
   if (((Channel *)chan)->userinfo->getUmbruch())
   {
      if ((e->key() >= Key_Space) && (e->key() <= Key_ydiaeresis))
      {
         cursorPosition(&line,&col);
         if (lineLength(line) >= ((Channel *)chan)->userinfo->getUmbruchPos())
         {
            // Zeile umbrechen, wenn der Cursor am Ende der Zeile steht.
            // Wenn nicht wird nur gepiept.
            if (lineLength(line) == col)
            {
               // Umbrechen.
               // Alles bis zum letzten Space wird gesendet, der Rest in die
               // naechste Zeile gepackt.
               strcpy(text2, textLine(line));
               if ((i = lPOS(' ', text2)) > -1)
               {
                  strcpy(text, text2);
                  text2[i] = '\0';
                  insertLine(text2, line);
                  removeLine(line+1);
                  emit returnPressed();
                  len = strlen(text)-i-1;
                  memmove(text, text+i+1, len);
                  text[len] = (char)e->ascii();
                  text[len+1] = '\0';
                  insertLine(text, line+1);
                  setCursorPosition(line+1, lineLength(line+1));
                  e->accept();
                  return;
               }
            }
            else
            {
               // Ansonsten piepen und das gerade eingetippte Zeichen verwerfen
               QApplication::beep();
               e->accept();
               return;
            }
         }
      }
   }

   QMultiLineEdit::keyPressEvent( e );
}


void myVorschreib::setMaxLines(int count)
{
   maxlines = count;
}


void myVorschreib::focusInEvent(QFocusEvent *f)
{
   list->setNew( chan, false );

   // Dieser Kanal ist der aktuelle
   toplevel->currentChannel = chan;

   QMultiLineEdit::focusInEvent(f);
}


void myVorschreib::setColors( QColor & font, QColor & back)
{
   QPalette p;
   QColorGroup cg;


   p = palette();
   cg = p.normal();

   QColorGroup cg_new(back, back, back, back, back,
                      font, back);

   p.setNormal(cg_new);
   p.setActive(cg_new);
	setPalette(p);

   setBackgroundColor( back );

   cFont = font;
   cBack = back;

   update();
}


void myVorschreib::setupPainter(QPainter *p)
{
   p->setPen( cFont );
   p->setBrush( cFont );
}


void myVorschreib::paintCell( QPainter *p, int row, int col )
{
   p->setPen( cFont );
   p->setBrush( cFont );

   QMultiLineEdit::paintCell(p, row, col);
}


void myVorschreib::mousePressEvent( QMouseEvent *e)
{
   if (e->button() == RightButton)
      emit kontextMenu();

   QMultiLineEdit::mousePressEvent(e);
}



#include "vorschreib.moc"

