/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "remote.h"
#include "toolbox.h"
#include "channel.h"
#include "global.h"
#include "ax25k.h"
#include "version.h"
#include "main.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


extern TopLevel *toplevel;


typedef struct
{
  char str[20];
  long flag;
} s_remotes;

#define ANZ_REMOTECMD 15
s_remotes RemoteCommands[ANZ_REMOTECMD]={
                   {"QUIT",    REMOTE_QUIT},
                   {"VERSION", REMOTE_VERSION},
                   {"CS",      REMOTE_CS},
                   {"INFO",    REMOTE_INFO},
                   {"HELP",    REMOTE_HELP},
                   {"NAME",    REMOTE_NAME},
                   {"NEWS",    REMOTE_NEWS},
                   {"ECHO",    REMOTE_ECHO},
                   {"RTT",     REMOTE_RTT},
                   {"COMP",    REMOTE_COMP},
                   {"TALK",    REMOTE_TALK},
                   {"DATE",    REMOTE_DATE},
                   {"DDATE",   REMOTE_DDATE},
                   {"COOKIE",  REMOTE_COOKIE},
                   {"RING",    REMOTE_RING}};
/*                   {"WRITE",REMOTE_WRITE},
                   {"READ",REMOTE_READ},
                   {"DIR",REMOTE_DIR},
*/



RemoteCmds::RemoteCmds( QWidget *channel )
{
   chan = channel;
}


RemoteCmds::~RemoteCmds()
{
}


// Jede empfangene Zeile wird an diese Funktion geschickt, wenn Remote-
// Befehle aktiviert sind.
void RemoteCmds::checkLine( char *rxstr )
{
   char *line, *command, str1[500],str2[500],*str;
   int i,len;
   bool found=false;

   str = (char *) strdup(rxstr);

   i = strlen(str)-1;
   if (str[i] == 0xD) str[i] = '\0';
   if (str[i] == 0xA) str[i] = '\0';


   if (strlen(str) < 1)
   {
      free(str);
      return;
   }

   line = (char *) strdup(str);
   command = (char *) malloc(strlen(str)+1);


   KillSpacesLeft(line);
   KillSpacesRight(line);

   if ((i = POS(' ',line)) == -1)
   {
      strcpy(command, line);
      line[0] = '\0';
   }
   else
   {
      memcpy(command, line, i);
      len = strlen(line)-i-1;
      memmove(line, line+i+1, len);
      command[i] = '\0';
      line[len] = '\0';
      KillSpacesLeft(line);
   }

   Gross(command);


   len = strlen(command);

   i = 0;
   while (!found)
   {
      COPY(str1,command,0,len);
      COPY(str2,RemoteCommands[i].str,0,len);
      if (!strcmp(str1,str2))
         found = true;
      else
         i++;
      if (i>ANZ_REMOTECMD) found=true;
   }

   if (i>ANZ_REMOTECMD)
      sendString( "<LinKT>: Unknown command!\xD" );
   else
   {
      // Gucken, ob dieser Befehl ueberhaupt ausgefuehrt werden darf
      if ((((Channel *)chan)->userinfo->getRemotes() & RemoteCommands[i].flag) == 0)
      {
         // Nein, darf nicht.
         sendString( "<LinKT>: Permission denied.\xD" );
         free(line);
         free(command);
         free(str);
         return;
      }


      if (i<=ANZ_REMOTECMD)
      {
         switch(i)
         {
            case  0: cmdQuit(); break;
            case  1: cmdVersion(); break;
            case  2: cmdCS(); break;
            case  3: cmdInfo(); break;             // INFO
            case  4: cmdHelp(); break;             // HELP
            case  5: cmdName(line); break;         // NAME <Name>
            case  6: cmdNews(); break;             // NEWS
            case  7: cmdEcho(line); break;         // ECHO
            case  8: cmdRTT(line); break;          // RTT [<timestamp>]
            case  9: cmdComp(line); break;         // COMP [ON|OFF|0|1]
            case 10: cmdTalk(line); break;         // TALK <call> <text>
            case 11: cmdDate(); break;             // DATE
            case 12: cmdDDate(line); break;        // DDATE [<day> <mon> <year>]
            case 13: cmdCookie(); break;           // COOKIE
            case 14: cmdRing(); break;		         // RING
//            case  5: remote_write(chan,params); break;	//WRITE <filename>
//            case  6: remote_read(chan,params); break;	//READ <filename>
//            case 12: remote_dir(chan, params); break;	//DIR [directory]
            default: sendString( "<LinKT>: Unknown command!\xD" );
         }
      }
   }


   free(command);
   free(line);
   free(str);
}


void RemoteCmds::sendString( char *str )
{
   ((Channel *)chan)->sendString( str );
}


// Wenn CS_PROMPT 1 ist, wird ein Prompt ausgesendet
void RemoteCmds::sendPrompt()
{
  char tmp[200];

  if ((((Channel *)chan)->getFlags() & CH_PROMPT) != 0)
  {
    sprintf(tmp,"%s de %s>\xD",((Channel *)chan)->getCall(),((Channel *)chan)->getMycall());
    sendString( tmp );
  }
}



void RemoteCmds::cmdQuit()
{
   char tmp[500];

   sprintf(tmp,"%s/qtext",config->maindir);
   ((Channel *)chan)->sendMacrofile( tmp );

   ((Channel *)chan)->discStnAuto();
}


void RemoteCmds::cmdVersion()
{
   char tmp[100];
   struct tm sTm;
   int i;
   char sendthistext[5000];
   s_ports *porttmp;
  
  
   sTm = *gmtime(&config->starttime);
  
   sprintf(sendthistext,"LinKT - Linux Kde pr-Terminal V%s (%s)\xD",LINKT_VERSION, DATE);
   strcat(sendthistext,"Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ\xD");
  

   sprintf(tmp,"Running since %.2i.%.2i.%.4i %.2i:%.2i:%.2i\xD"
              ,sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900,sTm.tm_hour,sTm.tm_min,sTm.tm_sec);
   strcat(sendthistext,tmp);




   porttmp = portlist;
   i = 0;
   while (porttmp != NULL)
   {
      if (porttmp->ax25 != NULL)
      {
         sprintf(tmp,"port %i: %s %i baud (%s)\xD",i,porttmp->name,porttmp->baud,porttmp->desc);
         strcat(sendthistext,tmp);
         i++;
      }
      porttmp = porttmp->next;
   }
  
   sendString( sendthistext );
   sendPrompt();
}


void RemoteCmds::cmdCS()
{
   char tmp[100], str[1000];
   s_chanlist *chantmp;

   // Ueberschrift
   sendString( "      port     remote   local      name\xD" \
               "-------------------------------------------------------------\xD" );

   chantmp = toplevel->getChanListPtr();
   str[0] = '\0';
   while (chantmp != NULL)
   {
      if (chantmp->channel->getCall() != NULL)
      {
         if (chantmp->channel == (Channel *)chan)
            sprintf(tmp,"* %8s %10s - %-10s",chantmp->channel->getPort(),chantmp->channel->getCall(),chantmp->channel->getMycall());
         else
            sprintf(tmp,"  %8s %10s - %-10s",chantmp->channel->getPort(),chantmp->channel->getCall(),chantmp->channel->getMycall());

         if (chantmp->channel->userinfo->getName() != NULL)
            sprintf(tmp,"%s %-20s\xD",tmp,chantmp->channel->userinfo->getName());
         else
            sprintf(tmp,"%s%20s\xD",tmp,"");
         strcat(str, tmp);
         if (strlen(tmp) > 800)
         {
            sendString( str );
            str[0] = '\0';
         }
      }

      chantmp = chantmp->next;
   }
   sendString( str );
   sendPrompt();
}


void RemoteCmds::cmdInfo()
{
   char tmp[500];

   sprintf(tmp,"%s/info.linkt",config->maindir);
  
   if (!file_exist(tmp))
      sendString( "<LinKT>: No info available.\r" );
   else
     ((Channel *)chan)->sendMacrofile( tmp );

  sendPrompt();
}



void RemoteCmds::cmdHelp()
{
   char tmp[500];

   sprintf(tmp,"%s/help.linkt",config->maindir);
  
   if (!file_exist(tmp))
      sendString( "<LinKT>: No help available.\r" );
   else
     ((Channel *)chan)->sendMacrofile( tmp );

  sendPrompt();
}


void RemoteCmds::cmdNews()
{
   char tmp[500];

   sprintf(tmp,"%s/news.linkt",config->maindir);
  
   if (!file_exist(tmp))
      sendString( "<LinKT>: No news available.\r" );
   else
     ((Channel *)chan)->sendMacrofile( tmp );

  sendPrompt();
}



void RemoteCmds::cmdName(char *param)
{
   char tmp[100];

   if (param[0] == '\0')
   {
      if (((Channel *)chan)->userinfo->getName() == NULL)
        strcpy(tmp,"<LinKT>: No name set.\xD");
      else
         sprintf(tmp,"<LinKT>: Name: %s.\xD",((Channel *)chan)->userinfo->getName());
      sendString(tmp);
      sendPrompt();
      return;
   }


   if (strlen(param) > 20) param[21] = '\0';
   ((Channel *)chan)->userinfo->setName(param);

   sprintf(tmp,"<LinKT>: OK, %s, your name has been saved.\xD",param);
   sendString(tmp);
   sendPrompt();
}


void RemoteCmds::cmdEcho(char *str)
{
  char *tmp;
  int len;
  
  len = strlen(str);
  tmp = (char *) malloc(len+2);
  strcpy(tmp,str);
  tmp[len] = '\r';
  tmp[len+1] = '\0';

  sendString(tmp);
  
  free(tmp);
}


void RemoteCmds::cmdRTT(char *str)
{
  time_t akttime,rxtime,difftime;
  char tmp[500],*diffstr; 


  akttime = time(NULL);
  
  if (str[0] == '\0')
  {
    // Kein Parameter. Aktuelle Zeit mit //ECHO zurck senden
    sprintf(tmp,"//ECHO //RTT %lX\r",akttime);
    sendString(tmp);
    return;
  }
  
  rxtime = get_hex (str);

  if (rxtime < 1)
  {
    sendString("<LinKT>: Wrong parameter.\r" );
    return;
  }

  if ((difftime = akttime - rxtime) == 0)
     sprintf(tmp,"<LinKT>: RTT %s <-> %s <-> %s is less than one second!\r",
                 ((Channel *)chan)->getMycall(),
                 ((Channel *)chan)->getCall(),
                 ((Channel *)chan)->getMycall());
  else
  {
    diffstr = (char *) spec_time(difftime);
    sprintf(tmp,"<LinKT>: RTT %s <-> %s <-> %s is %s.\r",
                ((Channel *)chan)->getMycall(),
                ((Channel *)chan)->getCall(),
                ((Channel *)chan)->getMycall(),
                diffstr);
    free(diffstr);
  }
  sendString( tmp );
}



void RemoteCmds::cmdComp(char *param)
{
  int zahl;
  char tmp[100];

  Gross(param);
  if (!strcmp(param,"ON"))
  {
    strcpy(tmp, "//COMP 1\r" );
    ((Channel *)chan)->sendStringComp(strlen(tmp), tmp, true, COMP_NO);
    ((Channel *)chan)->flags |= CH_COMP;
    return;
  }

  if (!strcmp(param,"OFF"))
  {
    strcpy(tmp, "//COMP 0\r" );
    ((Channel *)chan)->sendStringComp(strlen(tmp), tmp, true, COMP_SP);
    ((Channel *)chan)->flags &= ~CH_COMP;
    return;
  }

  zahl = atoi(param);

  switch (zahl)
  {
    case 0: if ((((Channel *)chan)->flags & CH_COMP) == 0) return;
            ((Channel *)chan)->flags &= ~CH_COMP;
            break;
    case 1: if ((((Channel *)chan)->flags & CH_COMP) == CH_COMP) return;
            ((Channel *)chan)->flags |= CH_COMP;
            break;
  }
}


//   void RemoteCmds::cmdTalk(char param)
//
// Mit einem anderen eingeloggten User uber //TALK <Rufzeichen> <Text> in
// Verbindung treten.
// Funktioniert nur mit Stationen, die als "Terminal" angemeldet sind.
void RemoteCmds::cmdTalk(char *param)
{
   char call[100],tmpcall[100], tmp[500];
   int i,len;
   s_chanlist *chantmp;
   char *chancall;


   KillSpacesLeft(param);
   if ((i = POS(' ', param)) == -1)
   {
      sendString("<LinKT>: Syntax: //TALK <Call> <Text>\r" );
      return;
   }

   memcpy(call, param, i);
   call[i] = '\0';
   Gross(call);
   len = strlen(param)-i-1;
   memcpy(param, param+i+1, len);
   param[len] = '\0';


   chantmp = toplevel->getChanListPtr();
   while (chantmp != NULL)
   {
      if (chantmp->channel->userinfo->getType() == TYPE_TERMINAL)
         if ((chancall = chantmp->channel->getCall()) != NULL)
         {
            strcpy(tmpcall, chancall);
            if ((i = POS('-', tmpcall)) > -1)
               tmpcall[i] = '\0';

            if (!strcmp(tmpcall, call))
            {
               sprintf(tmp,"-%s-: %s\r", ((Channel *)chan)->getCall(), param);
               chantmp->channel->sendString(tmp);
               return;
            }
         }

      chantmp = chantmp->next;
   }

   sprintf(tmp, "<LinKT>: %s is not logged in.\r", call);
   sendString( tmp );
}


char wday[][10] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday",
                   "Saturday"};

void RemoteCmds::cmdDate()
{
   time_t t;
   struct tm *tm;
   char tmp[100];

   t = time(NULL);
   tm = localtime(&t);

   sprintf(tmp, "<LinKT>: %s, %.2i.%.2i.%.4i %.2i:%.2i:%.2i\r",
                wday[tm->tm_wday],
                tm->tm_mday, tm->tm_mon+1, tm->tm_year+1900,
                tm->tm_hour, tm->tm_min, tm->tm_sec);
   sendString( tmp );
}




///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

/* ddate.c .. converts boring normal dates to fun Discordian Date -><-
   original incarnation written the 65th day of The Aftermath in the 
   Year of Our Lady of Discord 3157 by Druel the Chaotic aka Jeremy Johnson 
   aka mpython@gnu.ai.mit.edu.
   Majorly hacked, extended and bogotified/debogotified on 
   Sweetmorn, Bureaucracy 42, 3161 YOLD, by Lee H:. O:. Smith, KYTP, 
   aka Andrew Bulhak, aka acb@zikzak.net

   Hacked for simple use in LinKT by Jochen Sarrazin, DG6VJ

   and I'm not responsible if this program messes anything up (except your 
   mind, I'm responsible for that) (and that goes for me as well --lhos)
*/


/* configuration options  VVVVV   READ THIS!!! */

/* If you wish ddate(1) to print the date in the same format as Druel's 
 * original ddate when called in immediate mode, define OLD_IMMEDIATE_FMT 
 */

/* #define OLD_IMMEDIATE_FMT */

/* If you wish to use the US format for aneristic dates (m-d-y), as opposed to
 * the Commonwealth format, define US_FORMAT.
 */

/* #define US_FORMAT */

/* If you are ideologically, theologically or otherwise opposed to the 
 * Church of the SubGenius and do not wish your copy of ddate(1) to contain
 * code for counting down to X-Day, undefine PRAISE_BOB */

#define PRAISE_BOB 13013

/*#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef __GNUC__
#define inline
#endif*/

/* string constants */

char *day_long[5] = { 
    "Sweetmorn", "Boomtime", "Pungenday", "Prickle-Prickle", "Setting Orange"
};

char *day_short[5] = {"SM","BT","PD","PP","SO"};

char *season_long[5] = { 
    "Chaos", "Discord", "Confusion", "Bureaucracy", "The Aftermath"
};

char *season_short[5] = {"Chs", "Dsc", "Cfn", "Bcy", "Afm"};

char *holyday[5][2] = { 
    {"Mungday", "Chaoflux"},
    {"Mojoday", "Discoflux"},
    {"Syaday",  "Confuflux"},
    {"Zaraday", "Bureflux"},
    {"Maladay", "Afflux"}
};

struct disc_time {
    int season; /* 0-4 */
    int day; /* 0-72 */
    int yday; /* 0-365 */
    int year; /* 3066- */
};

char *excl[] = {
    "Hail Eris!", "All Hail Discordia!", "Kallisti!", "Fnord.", "Or not.",
    "Wibble.", "Pzat!", "P'tang!", "Frink!",
#ifdef PRAISE_BOB
    "Slack!", "Praise \"Bob\"!", "Or kill me.",
#endif /* PRAISE_BOB */
    /* randomness, from the Net and other places. Feel free to add (after
       checking with the relevant authorities, of course). */
    "Grudnuk demand sustenance!", "Keep the Lasagna flying!", 
    "Umlaut Zebra ber alles!",
    ""
};

char default_fmt[] = "%{%A, %B %d%}, %Y YOLD";
char *default_immediate_fmt=
"Today is %{%A, the %e day of %B%} in the YOLD %Y%N";
char *ends[]={"st","nd","rd","th"
};

#define DY(y) (y+1166)


/*inline */char *ending(int i) { return (i%10==1)?ends[0]:(i%10==2?ends[1]:(i%10==3?ends[2]:ends[3]));}
/*inline */int leapp(int i) { return (!(DY(i)%4))&&((DY(i)%100)||(!(DY(i)%400)));}

void print(struct disc_time,char **); /* old */
void format(char *buf, const char* fmt, struct disc_time dt);
/* select a random string */
/*inline */char *sel(char **strings, int num) {return(strings[random()%num]); }
/* read a fortune file */
int load_fortunes(char *fn, char *delim, char** result);

int xday_countdown(int yday, int year);

struct disc_time convert(int,int);
struct disc_time makeday(int,int,int);


void format(char *buf, const char* fmt, struct disc_time dt)
{
    int tib_start=-1, tib_end=0;
    int i, fmtlen=strlen(fmt);
    char *bufptr=buf;

/*    fprintf(stderr, "format(%p, \"%s\", dt)\n", buf, fmt);*/

    /* first, find extents of St. Tib's Day area, if defined */
    for(i=0; i<fmtlen; i++) {
	if(fmt[i]=='%') {
	    switch(fmt[i+1]) {
	    case 'A':
	    case 'a':
	    case 'd':
	    case 'e':
		if(tib_start>0)	    tib_end=i+1;
		else		    tib_start=i;
		break;
	    case '{': tib_start=i; break;
	    case '}': tib_end=i+1; break;
	    }
	}
    }

    /* now do the formatting */
    buf[0]=0;

    for(i=0; i<fmtlen; i++) {
	if((i==tib_start) && (dt.day==-1)) {
	    /* handle St. Tib's Day */
	    strcpy(bufptr, "St. Tib's Day"); bufptr += 13;
	    i=tib_end;
	} else {
	    if(fmt[i]=='%') {
		char *wibble=0, snarf[23];
		switch(fmt[++i]) {
		case 'A': wibble=day_long[dt.yday%5]; break;
		case 'a': wibble=day_short[dt.yday%5]; break;
		case 'B': wibble=season_long[dt.season]; break;
		case 'b': wibble=season_short[dt.season]; break;
		case 'd': sprintf(snarf, "%d", dt.day+1); wibble=snarf; break;
		case 'e': sprintf(snarf, "%d%s", dt.day+1, ending(dt.day+1)); 
		    wibble=snarf; break;
		case 'H': if(dt.day==4||dt.day==49)
		    wibble=holyday[dt.season][dt.day==49]; break;
		case 'N': if(dt.day!=4&&dt.day!=49) goto eschaton; break;
		case 'n': *(bufptr++)='\n'; break;
		case 't': *(bufptr++)='\t'; break;
		    
		case 'Y': sprintf(snarf, "%d", dt.year); wibble=snarf; break;
		case '.': wibble=sel(excl, sizeof(excl)/sizeof(excl[0]));
		    break;
#ifdef PRAISE_BOB
		case 'X': sprintf(snarf, "%d", 
				  xday_countdown(dt.yday, dt.year));
				  wibble = snarf; break;
#endif /* PRAISE_BOB */
		}
		if(wibble) {
/*		    fprintf(stderr, "wibble = (%s)\n", wibble);*/
		    strcpy(bufptr, wibble); bufptr+=strlen(wibble);
		}
	    } else {
		*(bufptr++) = fmt[i];
	    }
	}
    }
  eschaton:
    *(bufptr)=0;
}

struct disc_time makeday(int imonth,int iday,int iyear) /*i for input */
{ 
    struct disc_time funkychickens;
    
    int cal[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    int dayspast=0;
    
    imonth--;
    funkychickens.year= iyear+1166;
    while(imonth>0) { dayspast+=cal[--imonth]; }
    funkychickens.day=dayspast+iday-1;
    funkychickens.season=0;
    if((funkychickens.year%4)==2) {
	if (funkychickens.day==59)  funkychickens.day=-1;
    }
    funkychickens.yday=funkychickens.day;
/*               note: EQUAL SIGN...hopefully that fixes it */
    while(funkychickens.day>=73) {
	funkychickens.season++;
	funkychickens.day-=73;
    }
    return funkychickens;
}

#if 0
char *ending(int num)
{  
 int temp;
 char *funkychickens;
 
 funkychickens=(char *)malloc(sizeof(char)*3);
 
  temp=num%10; /* get 0-9 */  
  switch (temp)
  { case 1:
      strcpy(funkychickens,"st");
      break;
    case 2:
      strcpy(funkychickens,"nd");
      break;
    case 3:
      strcpy(funkychickens,"rd");
      break;
    default:
      strcpy(funkychickens,"th");
    }
 return funkychickens;
}
#endif

struct disc_time convert(int nday, int nyear)
{  struct disc_time funkychickens;
   
   funkychickens.year = nyear+3066;
   funkychickens.day=nday;
   funkychickens.season=0;
   if ((funkychickens.year%4)==2)
     {if (funkychickens.day==59)
	funkychickens.day=-1;
     else if (funkychickens.day >59)
       funkychickens.day-=1;
    }
   funkychickens.yday=funkychickens.day;
   while (funkychickens.day>=73)
     { funkychickens.season++;
       funkychickens.day-=73;
     }
   return funkychickens;
  
 }


#ifdef PRAISE_BOB

/* Code for counting down to X-Day, X-Day being Cfn 40, 3164 */

int xday_countdown(int yday, int year) {
    int r=(185-yday)+(((yday<59)&&(leapp(year)))?1:0);
    while(year<3164) r+=(leapp(++year)?366:365);
    while(year>3164) r-=(leapp(year--)?366:365);
    return r;
}

#endif

#if 0
void print(struct disc_time tick, char **args)
{ 
  if (args[1]==NULL)
    printf("Today is ");
  else
    printf("%s-%s-%s is ",args[1],args[2],args[3]);
  if (tick.day==-1) printf("St. Tib's Day!");
  else
    { tick.day++;
      printf("%s",days[tick.yday%5]);
      printf(",the %d", tick.day);
      printf("%s day of %s",ending(tick.day),seasons[tick.season]) ;
    }
  printf(" in the YOLD %d\n",tick.year);
  if ((tick.day==5)||(tick.day==50))
    { printf("Celebrate ");
      if (tick.day==5)
	printf("%s\n",holidays[tick.season][0]);
      else
	printf("%s\n",holidays[tick.season][1]);
    }
}
#endif


void getDiscordianDate( char *schwa, int day, int mon, int year, bool today )
{
   struct disc_time hastur;
   char *fnord=0;

   srandom(time(NULL));

	hastur=makeday(day, mon, year);
// 	hastur=convert(bob,raw);
   if (today)
   	fnord=fnord?fnord:default_immediate_fmt;
   else
   	fnord=fnord?fnord:default_fmt;
   format(schwa, fnord, hastur);
}


void RemoteCmds::cmdDDate( char *param )
{
   char tmp[500], tmp2[500];
   time_t t;
   struct tm *tm;
   int day, mon, year;
   bool today=false;


   OnlyOneSpace(tmp, param);
   KillSpacesLeft(tmp);
   KillSpacesRight(tmp);

   if (sscanf(tmp, "%i %i %i", &day, &mon, &year) != 3)
   {
      t = time(NULL);
      tm = localtime(&t);
      day = tm->tm_mday;
      mon = tm->tm_mon+1;
      year = tm->tm_year+1900;
      today = true;
   }
   else
   {
      if (day < 1 || day > 31 || mon < 1 || mon > 12)
      {
         strcpy(tmp, "<LinKT>: Syntax: //DDATE [<day> <mon> <year>]\r");
         sendString( tmp );
         return;
      }
   }

   getDiscordianDate(tmp, mon, day, year, today);
   sprintf(tmp2, "<LinKT>: %s\r", tmp);
   sendString( tmp2 );
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////


void RemoteCmds::cmdCookie()
{
   char tmp[5000];

   strcpy(tmp, "<LinKT>: Here is a cookie for you:\r");
   ((Channel *)chan)->getCookie(tmp+strlen(tmp));
   strcat(tmp, "\r");
   sendString( tmp );
   sendPrompt();
}


void RemoteCmds::cmdRing()
{
   char tmp[500];

   if ((config->sound->ring == NULL) || !config->sound->enabled)
   {
     sendString( "<LinKT>: Sri, bell is off.\r" );
     return;
   }

   sprintf(tmp,"<LinKT>: Ok, %s is being called. Please wait.\r", ((Channel *)chan)->getMycall());
   sendString( tmp );

   toplevel->playSound( SOUND_RING );
}


/*
void remote_write(int chan, char *param)
{
  char tmp[500],fullname[500];
  int fd;
  int i;
  
  
  if ((chaninfo[chan]->flags & (CH_AUTOBINRX|CH_AUTOBINTX)) != 0)
  {

    send_Textline(chan,"<LinKT>: No //WRITE while AutoBIN-Transfer.\r");

    return;
  }
  
  if (param[0] == '\0')
  {

    send_Textline(chan,"<LinKT>: Syntax: //WRITE <filename>\r");

    return;
  }
  
  
  // Eine Station von 'drauen' soll nur in einem einzigen Verzeichnis 'rummatschen drfen.
  // deshalb schneiden wir alle angegebenen Verzeichnisse ab, und packen das 'down'-Verzeichnis
  // davor.
  while ((i = POS('/',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  while ((i = POS('\\',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  
  sprintf(fullname,"%s/down/%s",config->maindir,param);
  
  
  if (file_exist(fullname))
  {

    sprintf(tmp,"<LinKT>: File '%s' already exists. Write aborted.\r",param);

    send_Textline(chan,tmp);
    return;
  }
  
  if ((fd = open(fullname,O_WRONLY|O_CREAT)) == -1)
  {

    sprintf(tmp,"<LinKT>: Cannot open '%s'.\r",param);

    send_Textline(chan,tmp);
    return;
  }
  
  // Zugriffsrechte einstellen
  fchmod(fd,S_IRUSR|S_IWUSR);
  

  sprintf(tmp,"<LinKT>: '%s' is open now. Close it with '***END' or CTRL-Z.\r",param);

  send_Textline(chan,tmp);
  
  chaninfo[chan]->flags |= CH_SAVE;
  chaninfo[chan]->saveplain = (s_saveplain *)malloc(sizeof(s_saveplain));
  chaninfo[chan]->saveplain->fd = fd;
  chaninfo[chan]->saveplain->filename = (char *)strdup(fullname);
  chaninfo[chan]->saveplain->local = 2;
  update_upper_statusline(TRUE);
}



void remote_read(int chan, char *param)
{
  char tmp[500];
  int i;

  if ((chaninfo[chan]->flags & (CH_AUTOBINRX|CH_AUTOBINTX)) != 0)
  {

    send_Textline(chan,"<LinKT>: No //READ while AutoBIN-Transfer.\r");

    return;
  }
  
  if (param[0] == '\0')
  {

    send_Textline(chan,"<LinKT>: Syntax: //READ <filename>\r");

    return;
  }
  
  while ((i = POS('/',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  while ((i = POS('\\',param)) != -1) COPY(param,param,i+1,strlen(param)-i-1); 
  
  sprintf(tmp,"%s/up/%s",config->maindir,param);
  
  if (!file_exist(tmp))
  {

    sprintf(tmp,"'%s' is not available.\r",param);

    send_Textline(chan,tmp);
  }
  
  send_Plainfile(chan,tmp);
}



// Zeigt den Inhalt eines Verzeichnisses an. Das Verzeichnis ist immer Relativ zum
// Verzeichnis ./up!
void remote_dir(int chan, char *str)
{
  char dir[500],tmp[500];
  DIR *dirptr;
  struct dirent *entry;
  
  if (strlen(str) > 200) str[201] = '\0';
  
  if (strstr(str,"..") != NULL)
  {
    send_Textline(chan,"<LinKT>: Permission denied\r");
    return;
  }
  
  if (str[0] == '\0')
     sprintf(dir,"%s/up/",config->maindir);
  else
     sprintf(dir,"%s/up/%s/",config->maindir,str);
  
  dirptr = opendir(dir);
  
  sprintf(tmp,"\rDirectory %s:\xD",dir);
  send_Textline(chan,tmp);
  while ((entry = readdir(dirptr)) != NULL)
  {
    sprintf(tmp,"%s\xD",entry->d_name);
    send_Textline(chan,tmp);
  }
  
  check_send_prompt(chan);
  
  closedir(dirptr);
}

*/

