/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef CHANLIST_H
#define CHANLIST_H

#include <qtableview.h>
#include <qlist.h>



#define SWITCH_UP 1
#define SWITCH_DOWN 2


class ChanListEntry : public QObject
{
   Q_OBJECT;
public:
   ChanListEntry( QWidget *rxchan, char *rxcall, char *rxmycall, char *rxtype, bool rxincoming );
   ~ChanListEntry();

   char * getCall();
   char * getMycall();
   char * getType();
   bool isIncoming();
   bool isNew();
   int getMode();

   void setType( int newtype );
   void setCall( char *newcall );
   bool setNew( bool neu );
   void setMode( int newmode );

   QWidget *chan;

private:
   char *mycall;
   char *call;
   char *type;
   bool incoming;
   int mode;

   bool isnew;
};


class ChanList : public QTableView
{
   Q_OBJECT;
public:
   ChanList( QWidget* parent=0 );
   ~ChanList();

   void addLine( QWidget *chan, char *call, char *mycall, int itype, bool incoming );
   void delLine( QWidget *chan );

   int useWidth();
   int useHeight();

   void changeType( QWidget *chan, int newtype );
   void changeCall( QWidget *chan, char *newcall );
   void changeCallAndType( QWidget *chan, char *newcall, int newtype );
   void setNew( QWidget *chan, bool neu );
   void setMode( QWidget *chan, int mode );

   void switchChannel(int sw);
   void auswahlLoeschen();

public slots:
   void slotCTRLKeyUp();
   void slotCTRLKeyDown();
   void activateWindow();
   void slotLastChannel();

signals:
   void signalFunctionKey(int id);


private:
   QList<ChanListEntry> *rows;

   QFont font;
   bool change_chan;
   int akt_row;

   void updateRow( int row );

protected:
   void paintCell( QPainter *p, int row, int col );
   int cellWidth(int cell);
   void mousePressEvent( QMouseEvent *e );
   void keyReleaseEvent( QKeyEvent *e );
   void keyPressEvent( QKeyEvent *e);
};


#endif // CHANLIST_H

