#include "irc.h"
#include "struct.h"

#include "alist.h"
#include "ircaux.h"
#include "screen.h"
#include "hook.h"
#include "output.h"
#include "misc.h"
#include "vars.h"

extern void reinit_status (Window *, char *, int);

IrcVariable fset_array[] = 
{
	{ "FORMAT_381",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_391",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_443",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_471",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_473",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_474",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_475",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_476",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_ACTION",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_AR",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_CHANNEL",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_OTHER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_OTHER_AR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_USER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ACTION_USER_AR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ALIAS",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ASSIGN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_AWAY",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BACK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BANS",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BANS_FOOTER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BANS_HEADER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BITCH",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BOT",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BOT_FOOTER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BOT_HEADER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_BWALL",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_CHANNEL_SIGNOFF",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	
	{ "FORMAT_COMPLETE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CONNECT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CSET",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_FUNC",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_FUNC_USER",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_UNKNOWN",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_UNKNOWN_USER", 0,STR_TYPE_VAR,0,NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_CLOAK_USER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_FUNC",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_FUNC_USER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_REPLY",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_UNKNOWN",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_UNKNOWN_USER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_CTCP_USER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_CHAT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_CONNECT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_ERROR",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_LOST",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DCC_REQUEST",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_DESYNC",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	
	{ "FORMAT_DISCONNECT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_EBANS",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_EBANS_FOOTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_EBANS_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ENCRYPTED_NOTICE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_ENCRYPTED_PRIVMSG",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_FLOOD",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_FRIEND_JOIN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_HELP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_HOOK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_IGNORE_INVITE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_MSG",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_MSG_AWAY",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_NOTICE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_IGNORE_WALL",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_INVITE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_INVITE_USER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_JOIN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_KICK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_KICK_USER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_KILL",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_LASTLOG",		0,STR_TYPE_VAR, 0, NULL, NULL, 0, 0},
	{ "FORMAT_LEAVE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_LINKS",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_LIST",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MAIL",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MODE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MODE_CHANNEL",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSG",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSGCOUNT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSGLOG",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_MSG_GROUP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_BANNER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_NAMES_BOT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_BOTCOLOR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_FOOTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_FRIEND",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_FRIENDCOLOR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_IRCOP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_NICKCOLOR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_NONOP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_OP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_OPCOLOR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_SHIT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_SHITCOLOR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_VOICE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NAMES_VOICECOLOR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_NETADD",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NETJOIN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NETSPLIT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NETSPLIT_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICKNAME",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICKNAME_OTHER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICKNAME_USER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICK_AUTO",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICK_COMP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NICK_MSG",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NONICK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTICE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_OFF",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_ON",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_SIGNOFF",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_NOTIFY_SIGNON",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_OPER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_OV",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PASTE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_AR",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_MSG",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_MSG_AR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_NOTICE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_NOTICE_AR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_OTHER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_PUBLIC_OTHER_AR",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_REL",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELM",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELS",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELSM",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_RELSN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_ACTION",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_ACTION_OTHER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_AWAY",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_CTCP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_DCC_CHAT",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_MSG",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_NOTICE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_PUBLIC",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SEND_PUBLIC_OTHER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG1",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG1_FROM",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG2",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_MSG2_FROM",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_SERVER_NOTICE_BOT",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_BOT1",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_BOT_ALARM",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_CONNECT",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_EXIT",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_INVALID",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_CLIENT_TERM",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_FAKE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_GLINE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_KILL",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_KILL_LOCAL",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_KLINE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_NICKC",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_OPER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_REHASH",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_STATS",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_TRAFFIC_HIGH",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_TRAFFIC_NORM",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SERVER_NOTICE_UNAUTH",0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},

	{ "FORMAT_SET",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SET_NOVALUE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SHITLIST",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SHITLIST_FOOTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SHITLIST_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SIGNOFF",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SILENCE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_SMODE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_STATUS",		0,STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_STATUS1",		0,STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_STATUS2",		0,STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_STATUS3",		0,STR_TYPE_VAR,	0, NULL, reinit_status, 0, 0},
	{ "FORMAT_TIMER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_CHANGE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_CHANGE_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_SETBY",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TOPIC_UNSET",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TRACE_OPER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TRACE_SERVER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_TRACE_USER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USAGE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERLIST",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERLIST_FOOTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERLIST_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERMODE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_SHIT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_TITLE",		0,STR_TYPE_VAR, 0, NULL, NULL, 0, 0},
	{ "FORMAT_USERS_USER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_VERSION",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WALL",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WALLOP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WALL_AR",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHO",			0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_ADMIN",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_AWAY",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_BOT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_CHANNELS",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_FOOTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_FRIEND",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_HELP",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_IDLE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_NAME",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_NICK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_OPER",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_REGISTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SERVER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SERVICE",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SHIT",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOIS_SIGNON",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOLEFT_FOOTER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOLEFT_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOLEFT_USER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOWAS_HEADER",	0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WHOWAS_NICK",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WIDELIST",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_WINDOW_SET",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ "FORMAT_XTERM_TITLE",		0,STR_TYPE_VAR,	0, NULL, NULL, 0, 0},
	{ NULL,				0, 0,		0, NULL, NULL, 0, 0}
};

typedef struct FSet_struc
{
	IrcVariable **list;
	int max;
	int max_set;
	alist_func func;
	unsigned long hash;
} FSet;

int strncasecmp(const char *s1, const char *s2, size_t n);
       
FSet ext_fset_list = { NULL, 0, 0, strncasecmp, 0};

void delete_all_ext_fset(void)
{
IrcVariable *ptr;
int index;

	for (index = 0; index < ext_fset_list.max; index++)
	{
		ptr = ext_fset_list.list[index];
		new_free(&ptr->name);
		new_free(&ptr->string);
		new_free(&ptr);
	}
	new_free(&ext_fset_list.list);
	ext_fset_list.max = 0;
	ext_fset_list.max_set = 0;
}

void add_new_fset(char *name, char *args)
{
	if (args && *args)
	{
		IrcVariable *tmp = NULL;
		int cnt, loc;
		tmp = (IrcVariable *)find_array_item((array *)&ext_fset_list, name, &cnt, &loc);
		if (!tmp || cnt >= 0)
		{
			tmp = new_malloc(sizeof(IrcVariable));
			tmp->name = m_strdup(name);
			tmp->type = STR_TYPE_VAR;
			add_to_array((array *)&ext_fset_list, (array_item *)tmp);
		}
		malloc_strcpy(&tmp->string, args);
	}
	else 
	{
		IrcVariable *tmp;
		if ((tmp = (IrcVariable *)remove_from_array((array *)&ext_fset_list, name)))
		{
			new_free(&tmp->name);
			new_free(&tmp->string);
			new_free(&tmp);
		}
	}
}

IrcVariable *find_ext_fset_var(char *name)
{
IrcVariable *tmp = NULL;
int loc, cnt;
	tmp = (IrcVariable *)find_array_item((array *)&ext_fset_list, name, &cnt, &loc);
	if (tmp && cnt < 0)
		return tmp;
	return NULL;
}



char *fget_string_var(enum FSET_TYPES var)
{
IrcVariable *tmp = NULL;
	if ((tmp = find_ext_fset_var(fset_array[var].name)))
		return tmp->string;
	return (fset_array[var].string);
}

void fset_string_var(enum FSET_TYPES var, char *value)
{
	if (value && *value)
		malloc_strcpy(&(fset_array[var].string), value);
	else
		new_free(&(fset_array[var].string));
}

static int find_fset_variable(IrcVariable *array, char *org_name, int *cnt)
{
	IrcVariable *v, *first;
	int     len, var_index;
	char    *name = NULL;

	malloc_strcpy(&name, org_name);
	upper(name);
	len = strlen(name);
	var_index = 0;
	for (first = array; first->name; first++, var_index++) 
	{
		if (strncmp(name, first->name, len) == 0) 
		{
			*cnt = 1;
			break;
		}
	}
	if (first->name) 
	{
		if (strlen(first->name) != len) 
		{
			v = first;
			for (v++; v->name; v++, (*cnt)++) 
			{
				if (strncmp(name, v->name, len) != 0)
					break;
			}
		}
		new_free(&name);
		return (var_index);
	}
	else 
	{
		*cnt = 0;
		new_free(&name);
		return (-1);
	}
}


static void set_fset_var_value(int var_index, char *name, char *value)
{
	IrcVariable *var = NULL;
	if (name)
		var = find_ext_fset_var(name);
	if (!var)
		var = &(fset_array[var_index]);
	
	switch (var->type) 
	{
	case STR_TYPE_VAR:
		{
			if (value)
			{
				if (*value)
					malloc_strcpy(&(var->string), value);
				else
				{
					put_it("%s", convert_output_format(fget_string_var(FORMAT_SET_FSET), "%s %s", var->name, var->string?var->string:empty_string));
					return;
				}
			} else
				new_free(&(var->string));
			if (var->func)
				(var->func) (current_window, var->string, 0);
			say("Value of %s set to %s", var->name, var->string ?
				var->string : "<EMPTY>");
		}
		break;
	default:
		say("FSET_type not supported");
	}
}

static inline void fset_variable_case1(char *name, int var_index, char *args)
{
	set_fset_var_value(var_index, name, args);
}

static inline void fset_variable_casedef(char *name, int cnt, int var_index, char *args)
{
	for (cnt += var_index; var_index < cnt; var_index++)
		set_fset_var_value(var_index, NULL, args);
}

static inline void fset_variable_noargs(char *name)
{
int var_index = 0;
	for (var_index = 0; var_index < NUMBER_OF_FSET; var_index++)
		set_fset_var_value(var_index, NULL, empty_string);
	for (var_index = 0; var_index < ext_fset_list.max; var_index++)
		set_fset_var_value(var_index, (*ext_fset_list.list[var_index]).name, empty_string);
}


BUILT_IN_COMMAND(fset_variable)
{
	char    *var;
	char 	*name = NULL;
	int     cnt, var_index;
	int	hook = 0;
	
	if ((var = next_arg(args, &args)) != NULL) 
	{
		if (*var == '-') 
		{
			var++;
			args = NULL;
		}
		else if (*var == '+')
		{
			var++;
			add_new_fset(var, args);
			return;
		}
		var_index = find_fset_variable(fset_array, var, &cnt);

		if ((cnt >= 0) || !(fset_array[var_index].int_flags & VIF_PENDING))
			hook = 1;

		if (cnt < 0)
			fset_array[var_index].int_flags |= VIF_PENDING;

		if (hook)
			hook = do_hook(SET_LIST, "%s %s", var, args ? args : empty_string);
		else
			hook = 1;

		if (cnt < 0)
			fset_array[var_index].int_flags &= ~VIF_PENDING;
		
		if (hook)
		{
			switch (cnt) 
			{
				case 0:
					say("No such variable \"%s\"", var);
					return;
				case 1:
					fset_variable_case1(name, var_index, args);
					return;
				default:
					say("%s is ambiguous", var);
					fset_variable_casedef(name, cnt, var_index, empty_string);
					return;
			}
		}
	} else
		fset_variable_noargs(name);
}


void create_fsets(Window *win, int ansi)
{
	fset_string_var(FORMAT_381_FSET, DEFAULT_FORMAT_381_FSET);
	fset_string_var(FORMAT_391_FSET, DEFAULT_FORMAT_391_FSET);
	fset_string_var(FORMAT_443_FSET, DEFAULT_FORMAT_443_FSET);
	fset_string_var(FORMAT_471_FSET, DEFAULT_FORMAT_471_FSET);
	fset_string_var(FORMAT_473_FSET, DEFAULT_FORMAT_473_FSET);
	fset_string_var(FORMAT_474_FSET, DEFAULT_FORMAT_474_FSET);
	fset_string_var(FORMAT_475_FSET, DEFAULT_FORMAT_475_FSET);
	fset_string_var(FORMAT_476_FSET, DEFAULT_FORMAT_476_FSET);
	fset_string_var(FORMAT_ACTION_FSET, DEFAULT_FORMAT_ACTION_FSET);
	fset_string_var(FORMAT_ACTION_AR_FSET, DEFAULT_FORMAT_ACTION_AR_FSET);
	fset_string_var(FORMAT_ACTION_CHANNEL_FSET, DEFAULT_FORMAT_ACTION_CHANNEL_FSET);
	fset_string_var(FORMAT_ACTION_OTHER_FSET, DEFAULT_FORMAT_ACTION_OTHER_FSET);
	fset_string_var(FORMAT_ACTION_OTHER_AR_FSET, DEFAULT_FORMAT_ACTION_OTHER_AR_FSET);
	fset_string_var(FORMAT_ACTION_USER_FSET, DEFAULT_FORMAT_ACTION_USER_FSET);
	fset_string_var(FORMAT_ACTION_USER_AR_FSET, DEFAULT_FORMAT_ACTION_USER_AR_FSET);
	fset_string_var(FORMAT_ACTION_FSET, DEFAULT_FORMAT_ACTION_FSET);
	fset_string_var(FORMAT_ACTION_AR_FSET, DEFAULT_FORMAT_ACTION_AR_FSET);
	fset_string_var(FORMAT_ACTION_CHANNEL_FSET, DEFAULT_FORMAT_ACTION_CHANNEL_FSET);
	fset_string_var(FORMAT_ACTION_OTHER_FSET, DEFAULT_FORMAT_ACTION_OTHER_FSET);
	fset_string_var(FORMAT_ACTION_OTHER_AR_FSET, DEFAULT_FORMAT_ACTION_OTHER_AR_FSET);
	fset_string_var(FORMAT_ACTION_USER_FSET, DEFAULT_FORMAT_ACTION_USER_FSET);
	fset_string_var(FORMAT_ACTION_USER_AR_FSET, DEFAULT_FORMAT_ACTION_USER_AR_FSET);
	fset_string_var(FORMAT_ALIAS_FSET, DEFAULT_FORMAT_ALIAS_FSET);
	fset_string_var(FORMAT_ASSIGN_FSET, DEFAULT_FORMAT_ASSIGN_FSET);
	fset_string_var(FORMAT_AWAY_FSET, DEFAULT_FORMAT_AWAY_FSET);
	fset_string_var(FORMAT_BACK_FSET, DEFAULT_FORMAT_BACK_FSET);

	fset_string_var(FORMAT_BANS_HEADER_FSET, DEFAULT_FORMAT_BANS_HEADER_FSET);
	fset_string_var(FORMAT_BANS_FSET, DEFAULT_FORMAT_BANS_FSET);
#if defined(DEFAULT_FORMAT_BANS_FOOTER_FSET)
	fset_string_var(FORMAT_BANS_FOOTER_FSET, DEFAULT_FORMAT_BANS_FOOTER_FSET);
#endif

	fset_string_var(FORMAT_BITCH_FSET, DEFAULT_FORMAT_BITCH_FSET);
	fset_string_var(FORMAT_BOT_HEADER_FSET, DEFAULT_FORMAT_BOT_HEADER_FSET);
	fset_string_var(FORMAT_BOT_FOOTER_FSET, DEFAULT_FORMAT_BOT_FOOTER_FSET);
	fset_string_var(FORMAT_BOT_FSET, DEFAULT_FORMAT_BOT_FSET);
	fset_string_var(FORMAT_BWALL_FSET, DEFAULT_FORMAT_BWALL_FSET);
	fset_string_var(FORMAT_CHANNEL_SIGNOFF_FSET, DEFAULT_FORMAT_CHANNEL_SIGNOFF_FSET);
	fset_string_var(FORMAT_CONNECT_FSET, DEFAULT_FORMAT_CONNECT_FSET);
	fset_string_var(FORMAT_COMPLETE_FSET, DEFAULT_FORMAT_COMPLETE_FSET);
	fset_string_var(FORMAT_CTCP_FSET, DEFAULT_FORMAT_CTCP_FSET);
	fset_string_var(FORMAT_CTCP_CLOAK_FSET, DEFAULT_FORMAT_CTCP_CLOAK_FSET);
	fset_string_var(FORMAT_CTCP_CLOAK_FUNC_FSET, DEFAULT_FORMAT_CTCP_CLOAK_FUNC_FSET);
	fset_string_var(FORMAT_CTCP_CLOAK_FUNC_USER_FSET, DEFAULT_FORMAT_CTCP_CLOAK_FUNC_USER_FSET);
	fset_string_var(FORMAT_CTCP_CLOAK_UNKNOWN_FSET, DEFAULT_FORMAT_CTCP_CLOAK_UNKNOWN_FSET);
	fset_string_var(FORMAT_CTCP_CLOAK_UNKNOWN_USER_FSET, DEFAULT_FORMAT_CTCP_CLOAK_UNKNOWN_USER_FSET);
	fset_string_var(FORMAT_CTCP_CLOAK_USER_FSET, DEFAULT_FORMAT_CTCP_CLOAK_USER_FSET);
	fset_string_var(FORMAT_CTCP_FUNC_FSET, DEFAULT_FORMAT_CTCP_FUNC_FSET);
	fset_string_var(FORMAT_CTCP_FUNC_USER_FSET, DEFAULT_FORMAT_CTCP_FUNC_USER_FSET);
	fset_string_var(FORMAT_CTCP_UNKNOWN_FSET, DEFAULT_FORMAT_CTCP_UNKNOWN_FSET);
	fset_string_var(FORMAT_CTCP_UNKNOWN_USER_FSET, DEFAULT_FORMAT_CTCP_UNKNOWN_USER_FSET);
	fset_string_var(FORMAT_CTCP_USER_FSET, DEFAULT_FORMAT_CTCP_USER_FSET);
	fset_string_var(FORMAT_CTCP_REPLY_FSET, DEFAULT_FORMAT_CTCP_REPLY_FSET);
	fset_string_var(FORMAT_DCC_CHAT_FSET, DEFAULT_FORMAT_DCC_CHAT_FSET);
	fset_string_var(FORMAT_DCC_CONNECT_FSET, DEFAULT_FORMAT_DCC_CONNECT_FSET);
	fset_string_var(FORMAT_DCC_ERROR_FSET, DEFAULT_FORMAT_DCC_ERROR_FSET);
	fset_string_var(FORMAT_DCC_LOST_FSET, DEFAULT_FORMAT_DCC_LOST_FSET);
	fset_string_var(FORMAT_DCC_REQUEST_FSET, DEFAULT_FORMAT_DCC_REQUEST_FSET);
	fset_string_var(FORMAT_DESYNC_FSET, DEFAULT_FORMAT_DESYNC_FSET);
	fset_string_var(FORMAT_DISCONNECT_FSET, DEFAULT_FORMAT_DISCONNECT_FSET);
	fset_string_var(FORMAT_ENCRYPTED_NOTICE_FSET, DEFAULT_FORMAT_ENCRYPTED_NOTICE_FSET);
	fset_string_var(FORMAT_ENCRYPTED_PRIVMSG_FSET, DEFAULT_FORMAT_ENCRYPTED_PRIVMSG_FSET);
	fset_string_var(FORMAT_FLOOD_FSET, DEFAULT_FORMAT_FLOOD_FSET);
	fset_string_var(FORMAT_FRIEND_JOIN_FSET, DEFAULT_FORMAT_FRIEND_JOIN_FSET);
	fset_string_var(FORMAT_HELP_FSET, DEFAULT_FORMAT_HELP_FSET);
	fset_string_var(FORMAT_HOOK_FSET, DEFAULT_FORMAT_HOOK_FSET);
	fset_string_var(FORMAT_INVITE_FSET, DEFAULT_FORMAT_INVITE_FSET);
	fset_string_var(FORMAT_INVITE_USER_FSET, DEFAULT_FORMAT_INVITE_USER_FSET);
	fset_string_var(FORMAT_JOIN_FSET, DEFAULT_FORMAT_JOIN_FSET);
	fset_string_var(FORMAT_KICK_FSET, DEFAULT_FORMAT_KICK_FSET);
	fset_string_var(FORMAT_KICK_USER_FSET, DEFAULT_FORMAT_KICK_USER_FSET);
	fset_string_var(FORMAT_KILL_FSET, DEFAULT_FORMAT_KILL_FSET);
	fset_string_var(FORMAT_LEAVE_FSET, DEFAULT_FORMAT_LEAVE_FSET);
	fset_string_var(FORMAT_LINKS_FSET, DEFAULT_FORMAT_LINKS_FSET);
	fset_string_var(FORMAT_LINKS_FSET, DEFAULT_FORMAT_LINKS_FSET);
	fset_string_var(FORMAT_LIST_FSET, DEFAULT_FORMAT_LIST_FSET);
	fset_string_var(FORMAT_MAIL_FSET, DEFAULT_FORMAT_MAIL_FSET);
	fset_string_var(FORMAT_MSGCOUNT_FSET, DEFAULT_FORMAT_MSGCOUNT_FSET);
	fset_string_var(FORMAT_MSGLOG_FSET, DEFAULT_FORMAT_MSGLOG_FSET);
	fset_string_var(FORMAT_MODE_FSET, DEFAULT_FORMAT_MODE_FSET);
	fset_string_var(FORMAT_SMODE_FSET, DEFAULT_FORMAT_SMODE_FSET);
	fset_string_var(FORMAT_MODE_CHANNEL_FSET, DEFAULT_FORMAT_MODE_CHANNEL_FSET);
	fset_string_var(FORMAT_MSG_FSET, DEFAULT_FORMAT_MSG_FSET);
	fset_string_var(FORMAT_OPER_FSET, DEFAULT_FORMAT_OPER_FSET);
	fset_string_var(FORMAT_IGNORE_INVITE_FSET, DEFAULT_FORMAT_IGNORE_INVITE_FSET);
	fset_string_var(FORMAT_IGNORE_MSG_FSET, DEFAULT_FORMAT_IGNORE_MSG_FSET);
	fset_string_var(FORMAT_IGNORE_MSG_AWAY_FSET, DEFAULT_FORMAT_IGNORE_MSG_AWAY_FSET);
	fset_string_var(FORMAT_IGNORE_NOTICE_FSET, DEFAULT_FORMAT_IGNORE_NOTICE_FSET);
	fset_string_var(FORMAT_IGNORE_WALL_FSET, DEFAULT_FORMAT_IGNORE_WALL_FSET);
	fset_string_var(FORMAT_MSG_GROUP_FSET, DEFAULT_FORMAT_MSG_GROUP_FSET);
	fset_string_var(FORMAT_NAMES_FSET, DEFAULT_FORMAT_NAMES_FSET);
	fset_string_var(FORMAT_NAMES_BOT_FSET, DEFAULT_FORMAT_NAMES_BOT_FSET);
	fset_string_var(FORMAT_NAMES_FRIEND_FSET, DEFAULT_FORMAT_NAMES_FRIEND_FSET);
	fset_string_var(FORMAT_NAMES_BOTCOLOR_FSET, DEFAULT_FORMAT_NAMES_BOTCOLOR_FSET);
	fset_string_var(FORMAT_NAMES_FRIENDCOLOR_FSET, DEFAULT_FORMAT_NAMES_FRIENDCOLOR_FSET);
	fset_string_var(FORMAT_NAMES_NICKCOLOR_FSET, DEFAULT_FORMAT_NAMES_NICKCOLOR_FSET);
	fset_string_var(FORMAT_NAMES_NONOP_FSET, DEFAULT_FORMAT_NAMES_NONOP_FSET);
	fset_string_var(FORMAT_NAMES_VOICECOLOR_FSET, DEFAULT_FORMAT_NAMES_VOICECOLOR_FSET);
	fset_string_var(FORMAT_NAMES_OP_FSET, DEFAULT_FORMAT_NAMES_OP_FSET);
	fset_string_var(FORMAT_NAMES_IRCOP_FSET, DEFAULT_FORMAT_NAMES_IRCOP_FSET);
	fset_string_var(FORMAT_NAMES_SHIT_FSET, DEFAULT_FORMAT_NAMES_SHIT_FSET);
	fset_string_var(FORMAT_NAMES_SHITCOLOR_FSET, DEFAULT_FORMAT_NAMES_SHITCOLOR_FSET);
	fset_string_var(FORMAT_NAMES_VOICE_FSET, DEFAULT_FORMAT_NAMES_VOICE_FSET);
	fset_string_var(FORMAT_NAMES_OPCOLOR_FSET, DEFAULT_FORMAT_NAMES_OPCOLOR_FSET);
	fset_string_var(FORMAT_NETADD_FSET, DEFAULT_FORMAT_NETADD_FSET);
	fset_string_var(FORMAT_NETJOIN_FSET, DEFAULT_FORMAT_NETJOIN_FSET);
	fset_string_var(FORMAT_NETSPLIT_FSET, DEFAULT_FORMAT_NETSPLIT_FSET);
	fset_string_var(FORMAT_NICKNAME_FSET, DEFAULT_FORMAT_NICKNAME_FSET);
	fset_string_var(FORMAT_NICKNAME_OTHER_FSET, DEFAULT_FORMAT_NICKNAME_OTHER_FSET);
	fset_string_var(FORMAT_NICKNAME_USER_FSET, DEFAULT_FORMAT_NICKNAME_USER_FSET);
	fset_string_var(FORMAT_NONICK_FSET, DEFAULT_FORMAT_NONICK_FSET);
	fset_string_var(FORMAT_NOTE_FSET, DEFAULT_FORMAT_NOTE_FSET);
	fset_string_var(FORMAT_NOTICE_FSET, DEFAULT_FORMAT_NOTICE_FSET);
	fset_string_var(FORMAT_REL_FSET, DEFAULT_FORMAT_REL_FSET);
	fset_string_var(FORMAT_RELN_FSET, DEFAULT_FORMAT_RELN_FSET);
	fset_string_var(FORMAT_RELM_FSET, DEFAULT_FORMAT_RELM_FSET);
	fset_string_var(FORMAT_RELSN_FSET, DEFAULT_FORMAT_RELSN_FSET);
	fset_string_var(FORMAT_RELS_FSET, DEFAULT_FORMAT_RELS_FSET);
	fset_string_var(FORMAT_RELSM_FSET, DEFAULT_FORMAT_RELSM_FSET);
	fset_string_var(FORMAT_NOTIFY_SIGNOFF_FSET, DEFAULT_FORMAT_NOTIFY_SIGNOFF_FSET);
	fset_string_var(FORMAT_NOTIFY_SIGNON_FSET, DEFAULT_FORMAT_NOTIFY_SIGNON_FSET);
	fset_string_var(FORMAT_PASTE_FSET, DEFAULT_FORMAT_PASTE_FSET);
	fset_string_var(FORMAT_PUBLIC_FSET, DEFAULT_FORMAT_PUBLIC_FSET);
	fset_string_var(FORMAT_PUBLIC_AR_FSET, DEFAULT_FORMAT_PUBLIC_AR_FSET);
	fset_string_var(FORMAT_PUBLIC_MSG_FSET, DEFAULT_FORMAT_PUBLIC_MSG_FSET);
	fset_string_var(FORMAT_PUBLIC_MSG_AR_FSET, DEFAULT_FORMAT_PUBLIC_MSG_AR_FSET);
	fset_string_var(FORMAT_PUBLIC_NOTICE_FSET, DEFAULT_FORMAT_PUBLIC_NOTICE_FSET);
	fset_string_var(FORMAT_PUBLIC_NOTICE_AR_FSET, DEFAULT_FORMAT_PUBLIC_NOTICE_AR_FSET);
	fset_string_var(FORMAT_PUBLIC_OTHER_FSET, DEFAULT_FORMAT_PUBLIC_OTHER_FSET);
	fset_string_var(FORMAT_PUBLIC_OTHER_AR_FSET, DEFAULT_FORMAT_PUBLIC_OTHER_AR_FSET);
	fset_string_var(FORMAT_SEND_ACTION_FSET, DEFAULT_FORMAT_SEND_ACTION_FSET);
	fset_string_var(FORMAT_SEND_ACTION_OTHER_FSET, DEFAULT_FORMAT_SEND_ACTION_OTHER_FSET);
	fset_string_var(FORMAT_SEND_ACTION_FSET, DEFAULT_FORMAT_SEND_ACTION_FSET);
	fset_string_var(FORMAT_SEND_ACTION_OTHER_FSET, DEFAULT_FORMAT_SEND_ACTION_OTHER_FSET);
	fset_string_var(FORMAT_SEND_AWAY_FSET, DEFAULT_FORMAT_SEND_AWAY_FSET);
	fset_string_var(FORMAT_SEND_CTCP_FSET, DEFAULT_FORMAT_SEND_CTCP_FSET);
	fset_string_var(FORMAT_SEND_DCC_CHAT_FSET, DEFAULT_FORMAT_SEND_DCC_CHAT_FSET);
	fset_string_var(FORMAT_SEND_MSG_FSET, DEFAULT_FORMAT_SEND_MSG_FSET);
	fset_string_var(FORMAT_SEND_NOTICE_FSET, DEFAULT_FORMAT_SEND_NOTICE_FSET);
	fset_string_var(FORMAT_SEND_PUBLIC_FSET, DEFAULT_FORMAT_SEND_PUBLIC_FSET);
	fset_string_var(FORMAT_SEND_PUBLIC_OTHER_FSET, DEFAULT_FORMAT_SEND_PUBLIC_OTHER_FSET);
	fset_string_var(FORMAT_SERVER_FSET, DEFAULT_FORMAT_SERVER_FSET);
	fset_string_var(FORMAT_SERVER_MSG1_FSET, DEFAULT_FORMAT_SERVER_MSG1_FSET);
	fset_string_var(FORMAT_SERVER_MSG1_FROM_FSET, DEFAULT_FORMAT_SERVER_MSG1_FROM_FSET);
	fset_string_var(FORMAT_SERVER_MSG2_FSET, DEFAULT_FORMAT_SERVER_MSG2_FSET);
	fset_string_var(FORMAT_SERVER_MSG2_FROM_FSET, DEFAULT_FORMAT_SERVER_MSG2_FROM_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_FSET, DEFAULT_FORMAT_SERVER_NOTICE_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_BOT_FSET, DEFAULT_FORMAT_SERVER_NOTICE_BOT_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_BOT1_FSET, DEFAULT_FORMAT_SERVER_NOTICE_BOT1_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_BOT_ALARM_FSET, DEFAULT_FORMAT_SERVER_NOTICE_BOT_ALARM_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_CONNECT_FSET, DEFAULT_FORMAT_SERVER_NOTICE_CLIENT_CONNECT_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_EXIT_FSET, DEFAULT_FORMAT_SERVER_NOTICE_CLIENT_EXIT_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_INVALID_FSET, DEFAULT_FORMAT_SERVER_NOTICE_CLIENT_INVALID_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_CLIENT_TERM_FSET, DEFAULT_FORMAT_SERVER_NOTICE_CLIENT_TERM_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_FAKE_FSET, DEFAULT_FORMAT_SERVER_NOTICE_FAKE_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_KILL_FSET, DEFAULT_FORMAT_SERVER_NOTICE_KILL_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_KILL_LOCAL_FSET, DEFAULT_FORMAT_SERVER_NOTICE_KILL_LOCAL_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_KLINE_FSET, DEFAULT_FORMAT_SERVER_NOTICE_KLINE_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_GLINE_FSET, DEFAULT_FORMAT_SERVER_NOTICE_GLINE_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_NICK_COLLISION_FSET, DEFAULT_FORMAT_SERVER_NOTICE_NICK_COLLISION_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_OPER_FSET, DEFAULT_FORMAT_SERVER_NOTICE_OPER_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_REHASH_FSET, DEFAULT_FORMAT_SERVER_NOTICE_REHASH_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_STATS_FSET, DEFAULT_FORMAT_SERVER_NOTICE_STATS_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_TRAFFIC_HIGH_FSET, DEFAULT_FORMAT_SERVER_NOTICE_TRAFFIC_HIGH_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_TRAFFIC_NORM_FSET, DEFAULT_FORMAT_SERVER_NOTICE_TRAFFIC_NORM_FSET);
	fset_string_var(FORMAT_SERVER_NOTICE_UNAUTH_FSET, DEFAULT_FORMAT_SERVER_NOTICE_UNAUTH_FSET);
	fset_string_var(FORMAT_SET_FSET, DEFAULT_FORMAT_SET_FSET);
	fset_string_var(FORMAT_CSET_FSET, DEFAULT_FORMAT_CSET_FSET);
	fset_string_var(FORMAT_SET_NOVALUE_FSET, DEFAULT_FORMAT_SET_NOVALUE_FSET);
	fset_string_var(FORMAT_SHITLIST_FSET, DEFAULT_FORMAT_SHITLIST_FSET);
	fset_string_var(FORMAT_SHITLIST_FOOTER_FSET, DEFAULT_FORMAT_SHITLIST_FOOTER_FSET);
	fset_string_var(FORMAT_SHITLIST_HEADER_FSET, DEFAULT_FORMAT_SHITLIST_HEADER_FSET);
	fset_string_var(FORMAT_SIGNOFF_FSET, DEFAULT_FORMAT_SIGNOFF_FSET);
	fset_string_var(FORMAT_SILENCE_FSET, DEFAULT_FORMAT_SILENCE_FSET);
	fset_string_var(FORMAT_TRACE_OPER_FSET, DEFAULT_FORMAT_TRACE_OPER_FSET);
	fset_string_var(FORMAT_TRACE_SERVER_FSET, DEFAULT_FORMAT_TRACE_SERVER_FSET);
	fset_string_var(FORMAT_TRACE_USER_FSET, DEFAULT_FORMAT_TRACE_USER_FSET);
	fset_string_var(FORMAT_TIMER_FSET, DEFAULT_FORMAT_TIMER_FSET);
	fset_string_var(FORMAT_TOPIC_FSET, DEFAULT_FORMAT_TOPIC_FSET);
	fset_string_var(FORMAT_TOPIC_CHANGE_FSET, DEFAULT_FORMAT_TOPIC_CHANGE_FSET);
	fset_string_var(FORMAT_TOPIC_SETBY_FSET, DEFAULT_FORMAT_TOPIC_SETBY_FSET);
	fset_string_var(FORMAT_TOPIC_UNSET_FSET, DEFAULT_FORMAT_TOPIC_UNSET_FSET);
	fset_string_var(FORMAT_USAGE_FSET, DEFAULT_FORMAT_USAGE_FSET);
	fset_string_var(FORMAT_USERMODE_FSET, DEFAULT_FORMAT_USERMODE_FSET);
	fset_string_var(FORMAT_USERLIST_FSET, DEFAULT_FORMAT_USERLIST_FSET);
	fset_string_var(FORMAT_USERLIST_FOOTER_FSET, DEFAULT_FORMAT_USERLIST_FOOTER_FSET);
	fset_string_var(FORMAT_USERLIST_HEADER_FSET, DEFAULT_FORMAT_USERLIST_HEADER_FSET);
	fset_string_var(FORMAT_USERS_FSET, DEFAULT_FORMAT_USERS_FSET);
	fset_string_var(FORMAT_USERS_USER_FSET, DEFAULT_FORMAT_USERS_USER_FSET);
	fset_string_var(FORMAT_USERS_TITLE_FSET, DEFAULT_FORMAT_USERS_TITLE_FSET);
	fset_string_var(FORMAT_USERS_SHIT_FSET, DEFAULT_FORMAT_USERS_SHIT_FSET);
	fset_string_var(FORMAT_USERS_HEADER_FSET, DEFAULT_FORMAT_USERS_HEADER_FSET);
	fset_string_var(FORMAT_VERSION_FSET, DEFAULT_FORMAT_VERSION_FSET);
	fset_string_var(FORMAT_WALL_FSET, DEFAULT_FORMAT_WALL_FSET);
	fset_string_var(FORMAT_WALL_AR_FSET, DEFAULT_FORMAT_WALL_AR_FSET);
	fset_string_var(FORMAT_WALLOP_FSET, DEFAULT_FORMAT_WALLOP_FSET);
	fset_string_var(FORMAT_WHO_FSET, DEFAULT_FORMAT_WHO_FSET);
	fset_string_var(FORMAT_WHOIS_AWAY_FSET, DEFAULT_FORMAT_WHOIS_AWAY_FSET);
	fset_string_var(FORMAT_WHOIS_BOT_FSET, DEFAULT_FORMAT_WHOIS_BOT_FSET);
	fset_string_var(FORMAT_WHOIS_CHANNELS_FSET, DEFAULT_FORMAT_WHOIS_CHANNELS_FSET);
	fset_string_var(FORMAT_WHOIS_FRIEND_FSET, DEFAULT_FORMAT_WHOIS_FRIEND_FSET);
	fset_string_var(FORMAT_WHOIS_HEADER_FSET, DEFAULT_FORMAT_WHOIS_HEADER_FSET);
	fset_string_var(FORMAT_WHOIS_IDLE_FSET, DEFAULT_FORMAT_WHOIS_IDLE_FSET);
	fset_string_var(FORMAT_WHOIS_SHIT_FSET, DEFAULT_FORMAT_WHOIS_SHIT_FSET);
	fset_string_var(FORMAT_WHOIS_SIGNON_FSET, DEFAULT_FORMAT_WHOIS_SIGNON_FSET);
	fset_string_var(FORMAT_WHOIS_NAME_FSET, DEFAULT_FORMAT_WHOIS_NAME_FSET);
	fset_string_var(FORMAT_WHOIS_NICK_FSET, DEFAULT_FORMAT_WHOIS_NICK_FSET);
	fset_string_var(FORMAT_WHOIS_OPER_FSET, DEFAULT_FORMAT_WHOIS_OPER_FSET);
	fset_string_var(FORMAT_WHOIS_SERVER_FSET, DEFAULT_FORMAT_WHOIS_SERVER_FSET);
	fset_string_var(FORMAT_WHOLEFT_HEADER_FSET, DEFAULT_FORMAT_WHOLEFT_HEADER_FSET);
	fset_string_var(FORMAT_WHOLEFT_USER_FSET, DEFAULT_FORMAT_WHOLEFT_USER_FSET);
	fset_string_var(FORMAT_WHOWAS_HEADER_FSET, DEFAULT_FORMAT_WHOWAS_HEADER_FSET);
	fset_string_var(FORMAT_WHOWAS_NICK_FSET, DEFAULT_FORMAT_WHOWAS_NICK_FSET);
	fset_string_var(FORMAT_WHOIS_ADMIN_FSET, DEFAULT_FORMAT_WHOIS_ADMIN_FSET);
	fset_string_var(FORMAT_WHOIS_SERVICE_FSET, DEFAULT_FORMAT_WHOIS_SERVICE_FSET);
	fset_string_var(FORMAT_WHOIS_HELP_FSET, DEFAULT_FORMAT_WHOIS_HELP_FSET);
	fset_string_var(FORMAT_WHOIS_REGISTER_FSET, DEFAULT_FORMAT_WHOIS_REGISTER_FSET);
	fset_string_var(FORMAT_WHOIS_AWAY_FSET, DEFAULT_FORMAT_WHOIS_AWAY_FSET);
	fset_string_var(FORMAT_WHOIS_BOT_FSET, DEFAULT_FORMAT_WHOIS_BOT_FSET);
	fset_string_var(FORMAT_WHOIS_CHANNELS_FSET, DEFAULT_FORMAT_WHOIS_CHANNELS_FSET);
	fset_string_var(FORMAT_WHOIS_FRIEND_FSET, DEFAULT_FORMAT_WHOIS_FRIEND_FSET);
	fset_string_var(FORMAT_WHOIS_HEADER_FSET, DEFAULT_FORMAT_WHOIS_HEADER_FSET);
	fset_string_var(FORMAT_WHOIS_IDLE_FSET, DEFAULT_FORMAT_WHOIS_IDLE_FSET);
	fset_string_var(FORMAT_WHOIS_SHIT_FSET, DEFAULT_FORMAT_WHOIS_SHIT_FSET);
	fset_string_var(FORMAT_WHOIS_SIGNON_FSET, DEFAULT_FORMAT_WHOIS_SIGNON_FSET);
	fset_string_var(FORMAT_WHOIS_NAME_FSET, DEFAULT_FORMAT_WHOIS_NAME_FSET);
	fset_string_var(FORMAT_WHOIS_NICK_FSET, DEFAULT_FORMAT_WHOIS_NICK_FSET);
	fset_string_var(FORMAT_WHOIS_OPER_FSET, DEFAULT_FORMAT_WHOIS_OPER_FSET);
	fset_string_var(FORMAT_WHOIS_SERVER_FSET, DEFAULT_FORMAT_WHOIS_SERVER_FSET);
	fset_string_var(FORMAT_WHOLEFT_HEADER_FSET, DEFAULT_FORMAT_WHOLEFT_HEADER_FSET);
	fset_string_var(FORMAT_WHOLEFT_USER_FSET, DEFAULT_FORMAT_WHOLEFT_USER_FSET);
	fset_string_var(FORMAT_WHOWAS_HEADER_FSET, DEFAULT_FORMAT_WHOWAS_HEADER_FSET);
	fset_string_var(FORMAT_WHOWAS_NICK_FSET, DEFAULT_FORMAT_WHOWAS_NICK_FSET);
	fset_string_var(FORMAT_WHOIS_ADMIN_FSET, DEFAULT_FORMAT_WHOIS_ADMIN_FSET);
	fset_string_var(FORMAT_WHOIS_SERVICE_FSET, DEFAULT_FORMAT_WHOIS_SERVICE_FSET);
	fset_string_var(FORMAT_WHOIS_HELP_FSET, DEFAULT_FORMAT_WHOIS_HELP_FSET);
	fset_string_var(FORMAT_WHOIS_REGISTER_FSET, DEFAULT_FORMAT_WHOIS_REGISTER_FSET);
	fset_string_var(FORMAT_WIDELIST_FSET, DEFAULT_FORMAT_WIDELIST_FSET);
	fset_string_var(FORMAT_WINDOW_SET_FSET, DEFAULT_FORMAT_WINDOW_SET_FSET);
	fset_string_var(FORMAT_NICK_MSG_FSET, DEFAULT_FORMAT_NICK_MSG_FSET);
	fset_string_var(FORMAT_NICK_COMP_FSET, DEFAULT_FORMAT_NICK_COMP_FSET);
	fset_string_var(FORMAT_NICK_AUTO_FSET, DEFAULT_FORMAT_NICK_AUTO_FSET);
	fset_string_var(FORMAT_STATUS_FSET, DEFAULT_FORMAT_STATUS_FSET);
	fset_string_var(FORMAT_STATUS1_FSET, DEFAULT_FORMAT_STATUS1_FSET);
	fset_string_var(FORMAT_STATUS2_FSET, DEFAULT_FORMAT_STATUS2_FSET);
	fset_string_var(FORMAT_STATUS3_FSET, DEFAULT_FORMAT_STATUS3_FSET);
	fset_string_var(FORMAT_NOTIFY_OFF_FSET, DEFAULT_FORMAT_NOTIFY_OFF_FSET);
	fset_string_var(FORMAT_NOTIFY_ON_FSET, DEFAULT_FORMAT_NOTIFY_ON_FSET);
	fset_string_var(FORMAT_OV_FSET, DEFAULT_FORMAT_OV_FSET);

	fset_string_var(FORMAT_WHOIS_FOOTER_FSET, NULL);
	fset_string_var(FORMAT_XTERM_TITLE_FSET, NULL);
	fset_string_var(FORMAT_DCC_FSET, NULL);
	fset_string_var(FORMAT_NAMES_FOOTER_FSET, NULL);
	fset_string_var(FORMAT_NETSPLIT_HEADER_FSET, NULL);
	fset_string_var(FORMAT_TOPIC_CHANGE_HEADER_FSET, NULL);
	fset_string_var(FORMAT_WHOLEFT_FOOTER_FSET, NULL);
	fset_string_var(FORMAT_LASTLOG_FSET, DEFAULT_FORMAT_LASTLOG_FSET);	
	fset_string_var(FORMAT_EBANS_FSET, DEFAULT_FORMAT_EBANS_FSET);
	fset_string_var(FORMAT_EBANS_HEADER_FSET, DEFAULT_FORMAT_EBANS_HEADER_FSET);
#if defined(DEFAULT_FORMAT_EBANS_FOOTER_FSET)
	fset_string_var(FORMAT_EBANS_FOOTER_FSET, DEFAULT_FORMAT_EBANS_FOOTER_FSET);
#endif
}

int save_formats(FILE *outfile)
{
char thefile[BIG_BUFFER_SIZE+1];
char *p;
int i;
int count = 1;
#if defined(__EMX__) || defined(WINNT)
	sprintf(thefile, "%s/%s.fmt", get_string_var(CTOOLZ_DIR_VAR), version);
#else
	sprintf(thefile, "%s/%s.formats", get_string_var(CTOOLZ_DIR_VAR), version);
#endif
	p = expand_twiddle(thefile);
	outfile = fopen(p, "w");
	if (!outfile)
	{
		bitchsay("Cannot open file %s for saving!", thefile);
		new_free(&p);
		return 1;
	}
	for (i = 0; i < NUMBER_OF_FSET; i++)	
	{

		if (fset_array[i].string)
			fprintf(outfile, "FSET %s %s\n", fset_array[i].name, fset_array[i].string);
		else
			fprintf(outfile, "FSET -%s\n", fset_array[i].name);
		count++;
	}
	fclose(outfile);
	bitchsay("Saved %d formats to %s", count, thefile);
	new_free(&p);
	return 0;
}

void clear_fset(void)
{
int i;
	for (i = 0; i < NUMBER_OF_FSET; i++)	
	{

		if (fset_array[i].string)
			new_free(&fset_array[i].string);
	}
}

char *get_all_fset(void)
{
	int i;
	char *ret = NULL;
	for (i = 0; i < NUMBER_OF_FSET; i++)
		m_s3cat(&ret, space, fset_array[i].name);
	return ret;
}

char *get_fset(char *str)
{
	int i;
	char *ret = NULL;
	if (!str || !*str)
		return get_all_fset();
	for (i = 0; i < NUMBER_OF_FSET; i++)
		if (wild_match(str, fset_array[i].name))
			m_s3cat(&ret, space, fset_array[i].name);
	return ret ? ret : m_strdup(empty_string);
}

IrcVariable *fget_var_address(char *var_name)
{
	IrcVariable *var = NULL;
	int	cnt,
		msv_index;
	char	*tmp_var = alloca(strlen(var_name)+1);
	strcpy(tmp_var, var_name);
	upper(tmp_var);
	if ((var = find_ext_fset_var(tmp_var)))
		return var;
	if ((find_fixed_array_item (fset_array, sizeof(IrcVariable), NUMBER_OF_FSET, tmp_var, &cnt, &msv_index) == NULL))
		return NULL;
	if (cnt >= 0)
		return NULL;
	return &fset_array[msv_index];
}

char	*make_fstring_var(const char *var_name)
{
	IrcVariable *var = NULL;
	int	cnt,
		msv_index;
	char	*ret = NULL;
	char	*tmp_var = alloca(strlen(var_name)+1);
	strcpy(tmp_var, var_name);
	upper(tmp_var);
	if ((var = find_ext_fset_var(tmp_var)))
		return m_strdup(var->string);

	if ((find_fixed_array_item (fset_array, sizeof(IrcVariable), NUMBER_OF_FSET, tmp_var, &cnt, &msv_index) == NULL))
		return NULL;
	if (cnt >= 0)
		return NULL;
	switch (fset_array[msv_index].type)
	{
		case STR_TYPE_VAR:
			ret = m_strdup(fset_array[msv_index].string);
			break;
		case INT_TYPE_VAR:
			ret = m_strdup(ltoa(fset_array[msv_index].integer));
			break;
		case BOOL_TYPE_VAR:
			ret = m_strdup(var_settings[fset_array[msv_index].integer]);
			break;
		case CHAR_TYPE_VAR:
			ret = m_dupchar(fset_array[msv_index].integer);
			break;
	}
	return ret;
}

#ifdef WANT_TCL
char *fset_rem_str(ClientData *cd, Tcl_Interp *intp, char *name1, char *name2, int flags)
{
char *s;
IrcVariable *n;
	n = (IrcVariable *)cd;
	if ((s = Tcl_GetVar(intp, name1, TCL_GLOBAL_ONLY)))
	{
		malloc_strcpy(&n->string, s);
	}
	return NULL;
}

void add_tcl_fset(Tcl_Interp *irp)
{
char varname[80];
int i = 0;
	for(i = 0; fset_array[i].name; i++)
	{
		int type_of = -1;
		switch(fset_array[i].type)
		{
			case INT_TYPE_VAR:
				type_of = TCL_LINK_INT;
				break;
			case STR_TYPE_VAR:
				type_of = TCL_LINK_STRING;
				break;
			case BOOL_TYPE_VAR:
				type_of = TCL_LINK_BOOLEAN;
				break;
			default:
				continue;
		}
		strncpy(varname, fset_array[i].name, sizeof(varname)-1);
		lower(varname);
		Tcl_LinkVar(irp, varname, 
			(fset_array[i].type == STR_TYPE_VAR) ? 
				(char *)&fset_array[i].string : 
				(char *)&fset_array[i].integer,
			type_of);
		if (fset_array[i].type == STR_TYPE_VAR)
		{
			Tcl_TraceVar(irp, varname, TCL_TRACE_WRITES,
				(Tcl_VarTraceProc *)fset_rem_str, (ClientData)&fset_array[i]);
		}
	}
}
#endif


#ifdef GUI
IrcVariable *return_fset_var(int nummer)
{
   return &fset_array[nummer];
}
#endif

