/* $TOG: PsLine.c /main/4 1998/02/09 15:42:47 kaleb $ */
/*

Copyright 1996, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/
/*
 * (c) Copyright 1996 Hewlett-Packard Company
 * (c) Copyright 1996 International Business Machines Corp.
 * (c) Copyright 1996 Sun Microsystems, Inc.
 * (c) Copyright 1996 Novell, Inc.
 * (c) Copyright 1996 Digital Equipment Corp.
 * (c) Copyright 1996 Fujitsu Limited
 * (c) Copyright 1996 Hitachi, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Except as contained in this notice, the names of the copyright holders
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * from said copyright holders.
 */

/*******************************************************************
**
**    *********************************************************
**    *
**    *  File:		PsLine.c
**    *
**    *  Contents:	Line drawing routines for the PS driver
**    *
**    *  Created By:	Roger Helmendach (Liberty Systems)
**    *
**    *  Copyright:	Copyright 1996 The Open Group, Inc.
**    *
**    *********************************************************
** 
********************************************************************/
/* $XFree86: xc/programs/Xserver/Xprint/ps/PsLine.c,v 1.4 1998/10/04 09:37:27 dawes Exp $ */

#include "Ps.h"
#include "gcstruct.h"
#include "windowstr.h"

void
PsPolyLine(
  DrawablePtr  pDrawable,
  GCPtr        pGC,
  int          mode,
  int          nPoints,
  xPoint      *pPoints)
{
  if( pDrawable->type==DRAWABLE_PIXMAP )
  {
    DisplayElmPtr   elm;
    PixmapPtr       pix  = (PixmapPtr)pDrawable;
    PsPixmapPrivPtr priv = (PsPixmapPrivPtr)pix->devPrivate.ptr;
    DisplayListPtr  disp;
    GCPtr           gc;

    if ((gc = PsCreateAndCopyGC(pDrawable, pGC)) == NULL) return;

    disp = PsGetFreeDisplayBlock(priv);

    elm  = &disp->elms[disp->nelms];
    elm->type = PolyLineCmd;
    elm->gc   = gc;
    elm->c.polyPts.mode    = mode;
    elm->c.polyPts.nPoints = nPoints;
    elm->c.polyPts.pPoints = (xPoint *)xalloc(nPoints*sizeof(xPoint));
    memcpy(elm->c.polyPts.pPoints, pPoints, nPoints*sizeof(xPoint));
    disp->nelms += 1;
  }
  else
  {
    int         i;
    PsOutPtr    psOut;
    PsPointPtr  pts;
    ColormapPtr cMap;

    if( PsUpdateDrawableGC(pGC, pDrawable, &psOut, &cMap)==FALSE ) return;
    PsOut_Offset(psOut, pDrawable->x, pDrawable->y);
    PsOut_Color(psOut, PsGetPixelColor(cMap, pGC->fgPixel));
    PsLineAttrs(psOut, pGC, cMap);
    pts = (PsPointPtr)xalloc(sizeof(PsPointRec)*nPoints);
    if( mode==CoordModeOrigin )
    {
      for( i=0 ; i<nPoints ; i++ )
        { pts[i].x = pPoints[i].x; pts[i].y = pPoints[i].y; }
    }
    else
    {
      pts[0].x = pPoints[0].x; pts[0].y = pPoints[0].y;
      for( i=1 ; i<nPoints ;  i++ )
      {
        pts[i].x = pts[i-1].x+pPoints[i].x;
        pts[i].y = pts[i-1].y+pPoints[i].y;
      }
    }
    PsOut_Lines(psOut, nPoints, pts);
    xfree(pts);
  }
}

void
PsPolySegment(
  DrawablePtr  pDrawable,
  GCPtr        pGC,
  int          nSegments,
  xSegment    *pSegments)
{
  if( pDrawable->type==DRAWABLE_PIXMAP )
  {
    DisplayElmPtr   elm;
    PixmapPtr       pix  = (PixmapPtr)pDrawable;
    PsPixmapPrivPtr priv = (PsPixmapPrivPtr)pix->devPrivate.ptr;
    DisplayListPtr  disp;
    GCPtr           gc;

    if ((gc = PsCreateAndCopyGC(pDrawable, pGC)) == NULL) return;

    disp = PsGetFreeDisplayBlock(priv);

    elm  = &disp->elms[disp->nelms];
    elm->type = PolySegmentCmd;
    elm->gc   = gc;
    elm->c.segments.nSegments = nSegments;
    elm->c.segments.pSegments = (xSegment *)xalloc(nSegments*sizeof(xSegment));
    memcpy(elm->c.segments.pSegments, pSegments, nSegments*sizeof(xSegment));
    disp->nelms += 1;
  }
  else
  {
    int         i;
    PsOutPtr    psOut;
    PsPointRec  pts[2];
    ColormapPtr cMap;

    if( PsUpdateDrawableGC(pGC, pDrawable, &psOut, &cMap)==FALSE ) return;
    PsOut_Offset(psOut, pDrawable->x, pDrawable->y);
    PsOut_Color(psOut, PsGetPixelColor(cMap, pGC->fgPixel));
    PsLineAttrs(psOut, pGC, cMap);
    for( i=0 ; i<nSegments ; i++ )
    {
      pts[0].x = pSegments[i].x1;
      pts[0].y = pSegments[i].y1;
      pts[1].x = pSegments[i].x2;
      pts[1].y = pSegments[i].y2;
      PsOut_Lines(psOut, 2, pts);
    }
  }
}
