/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __BSPLINE_H__
#define __BSPLINE_H__

#include "basics.h"
#include "xforms.h"
#include "tlib.h"

#define MAX_SUBDIVS  20

#define SURFACE_TYPE_BEZIER  0
#define SURFACE_TYPE_BSPLINE  1

typedef struct _bspline_patch
{
	Vector *ctrl_pts; // points to the control points of a bspline surface
	Vector *ctrl_norms; // points to the control normals of a bspline surface
	int nu; // corresponding nu of the bspline surface where the control points are from
	int u; // 3 to nu of the surface
	int v; // 3 to nv of the surface
	int subdivs;
	VertexData left_verts[MAX_SUBDIVS+1];
	VertexData right_verts[MAX_SUBDIVS+1];
	VertexData bottom_verts[MAX_SUBDIVS+1];
	VertexData top_verts[MAX_SUBDIVS+1];
} BSplinePatch;

typedef struct _bspline_surface
{
	int nu;
	int nv;
	Vector *ctrl_pts;
	Vector *ctrl_norms;
	BSplinePatch *patches; // (nu-3)*(nv-3) patches
} BSplineSurface;

// global variables
extern BSplineSurface *gSurfaces;
extern int gNumSurfaces;
extern int gSurfaceType;

FxBool InitSurface();
void ReloadBsplineTextures();
FxBool LoadSurfaces(char *filename);
FxBool SaveSurfaces(char *filename);
void CleanupSurface();
int RenderBSplineSurface();
int DrawBSplineSurface(BSplineSurface *surface, float s0, float t0, float s1, float t1);
Vector *SelectControlPoint(int x, int y);
float HeightAt(BSplineSurface *surface, float x, float y);

#endif // __BSPLINE_H__
