#include <stdio.h>
#include <orb/orbit.h>

int main(int argc, char *argv[])
{
	CORBA_Environment ev;
	CORBA_ORB orb;
	CORBA_Repository ir;
	CORBA_PrimitiveDef prim_long;
	CORBA_ConstantDef constant;
	CORBA_StringDef str;
	CORBA_ContainedSeq *contained_seq;
	CORBA_Contained_Description *contained_desc;
	CORBA_ConstantDescription *constant_desc;
	CORBA_any any;
	CORBA_long fooval=1;
	int i;

	CORBA_exception_init(&ev);
	orb=CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);

	ir=CORBA_ORB_resolve_initial_references(orb, "InterfaceRepository",
						&ev);
	if(CORBA_Object_is_nil(ir, &ev)) {
		g_print("No Interface Repo found.\n");
		exit(0);
	}

	any._type=(CORBA_TypeCode)TC_CORBA_long;
	any._value=&fooval;
	CORBA_any_set_release(&any, CORBA_FALSE);

	prim_long=CORBA_Repository_get_primitive(ir, CORBA_pk_long, &ev);
	
	constant=CORBA_Repository_create_constant(ir, "IDL:wibble:1.0", "wibble", "1.0", prim_long, &any, &ev);
	if(constant!=CORBA_OBJECT_NIL) {
		g_print("%s\n", CORBA_ConstantDef__get_id(constant, &ev));
		g_print("%s\n", CORBA_ConstantDef__get_absolute_name(constant, &ev));

#if 0
		contained_desc=CORBA_ConstantDef_describe(constant, &ev);
		if(contained_desc==NULL) {
			g_print("ConstantDef_describe returned NULL!\n");
		} else {
			constant_desc=contained_desc->value._value;
			
			g_print("Constant Description\n");
			g_print("--------------------\n");
			g_print("name: %s\n", constant_desc->name);
			g_print("id: %s\n", constant_desc->id);
			g_print("defined_in: %s\n", constant_desc->defined_in);
			g_print("version: %s\n", constant_desc->version);
		}
#endif
	}
	constant=CORBA_Repository_create_constant(ir, "IDL:wibble:1.1", "wibble", "1.1", prim_long, &any, &ev);
	constant=CORBA_Repository_create_constant(ir, "IDL:wobble:1.0", "wibble", "1.0", prim_long, &any, &ev);
	constant=CORBA_Repository_create_constant(ir, "IDL:wibble:1.0", "wobble", "1.0", prim_long, &any, &ev);

	str=CORBA_Repository_create_string(ir, 10, &ev);
	
	contained_seq=CORBA_Repository_contents(ir, CORBA_dk_all,
						CORBA_FALSE,
						&ev);
	
	g_print("%d items in repository\n", contained_seq->_length);

#ifdef THIS_SEEMS_TO_BE_BORKEN
	for(i=0;i<contained_seq->_length;i++) {
		g_print("%d\n", CORBA_Contained__get_def_kind(contained_seq->_buffer[i], &ev));
		
		switch(CORBA_Contained__get_def_kind(contained_seq->_buffer[i], &ev)) {
		case CORBA_dk_Constant:
			g_print("Item %d is constant called %s\n", i, CORBA_ConstantDef__get_id(contained_seq->_buffer[i], &ev));
			break;
		case CORBA_dk_String:
			g_print("Item %d is string of length %d\n", i, CORBA_StringDef__get_bound(contained_seq->_buffer[i], &ev));
			break;
		default:
			g_print("Item %d is of unknown type\n");
			break;
		}
	}
#endif
	
	contained_seq=CORBA_Repository_lookup_name(ir, "wibble", 1,
						   CORBA_dk_all,
						   CORBA_FALSE,
						   &ev);
	g_print("%d wibbles directly in repository\n", contained_seq->_length);
	
	contained_seq=CORBA_Repository_lookup_name(ir, "wibble", -1,
						   CORBA_dk_all,
						   CORBA_FALSE,
						   &ev);
	g_print("%d wibbles overall in repository\n", contained_seq->_length);

	CORBA_Repository_lookup(ir, "::wibble", &ev);
	CORBA_Repository_lookup(ir, "wibble", &ev);
	CORBA_Repository_lookup(ir, "::foo::bar::baz", &ev);
	
	CORBA_Repository_destroy(ir, &ev);
	
	CORBA_Object_release(constant, &ev);
	CORBA_Object_release(str, &ev);
	CORBA_Object_release(ir, &ev);
	CORBA_Object_release((CORBA_Object) orb, &ev);

	return 0;
}
